/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.monitoring.MonitoringFeatureSet;
import org.elasticsearch.xpack.monitoring.MonitoringService;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.action.TransportMonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.cleaner.CleanerService;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.ml.JobStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.node.NodeStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardsCollector;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExporter;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalExporter;
import org.elasticsearch.xpack.monitoring.rest.action.RestMonitoringBulkAction;
import org.elasticsearch.xpack.ssl.SSLService;

public class Monitoring
implements ActionPlugin {
    public static final String NAME = "monitoring";
    public static final TimeValue HISTORY_DURATION_MINIMUM = TimeValue.timeValueHours((long)24L);
    public static final Setting<TimeValue> HISTORY_DURATION = Setting.timeSetting((String)"xpack.monitoring.history.duration", (TimeValue)TimeValue.timeValueHours((long)168L), (TimeValue)HISTORY_DURATION_MINIMUM, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> CLEAN_WATCHER_HISTORY = Setting.boolSetting((String)"xpack.watcher.history.cleaner_service.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final Settings settings;
    private final XPackLicenseState licenseState;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final boolean tribeNode;

    public Monitoring(Settings settings, XPackLicenseState licenseState) {
        this.settings = settings;
        this.licenseState = licenseState;
        this.enabled = (Boolean)XPackSettings.MONITORING_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode(settings);
        this.tribeNode = XPackPlugin.isTribeNode(settings);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isTransportClient() {
        return this.transportClientMode;
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> {
            XPackPlugin.bindFeatureSet(b, MonitoringFeatureSet.class);
            if (this.transportClientMode || !this.enabled || this.tribeNode) {
                b.bind(Exporters.class).toProvider(Providers.of(null));
            }
        });
        return modules;
    }

    public Collection<Object> createComponents(Client client, ThreadPool threadPool, ClusterService clusterService, LicenseService licenseService, SSLService sslService) {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        CleanerService cleanerService = new CleanerService(this.settings, clusterSettings, threadPool, this.licenseState);
        SSLService dynamicSSLService = sslService.createDynamicSSLService();
        HashMap<String, Exporter.Factory> exporterFactories = new HashMap<String, Exporter.Factory>();
        exporterFactories.put("http", config -> new HttpExporter(config, dynamicSSLService, threadPool.getThreadContext()));
        exporterFactories.put("local", config -> new LocalExporter(config, client, cleanerService));
        Exporters exporters = new Exporters(this.settings, exporterFactories, clusterService, this.licenseState, threadPool.getThreadContext());
        HashSet<Collector> collectors = new HashSet<Collector>();
        collectors.add(new IndexStatsCollector(this.settings, clusterService, this.licenseState, client));
        collectors.add(new ClusterStatsCollector(this.settings, clusterService, this.licenseState, client, licenseService));
        collectors.add(new ShardsCollector(this.settings, clusterService, this.licenseState));
        collectors.add(new NodeStatsCollector(this.settings, clusterService, this.licenseState, client));
        collectors.add(new IndexRecoveryCollector(this.settings, clusterService, this.licenseState, client));
        collectors.add(new JobStatsCollector(this.settings, clusterService, this.licenseState, client));
        MonitoringService monitoringService = new MonitoringService(this.settings, clusterService, threadPool, collectors, exporters);
        return Arrays.asList(new Object[]{monitoringService, exporters, cleanerService});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ActionPlugin.ActionHandler((GenericAction)MonitoringBulkAction.INSTANCE, TransportMonitoringBulkAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new RestMonitoringBulkAction(settings, restController));
    }

    public List<Setting<?>> getSettings() {
        return Collections.unmodifiableList(Arrays.asList(HISTORY_DURATION, CLEAN_WATCHER_HISTORY, MonitoringService.INTERVAL, Exporters.EXPORTERS_SETTINGS, Collector.INDICES, ClusterStatsCollector.CLUSTER_STATS_TIMEOUT, IndexRecoveryCollector.INDEX_RECOVERY_TIMEOUT, IndexRecoveryCollector.INDEX_RECOVERY_ACTIVE_ONLY, IndexStatsCollector.INDEX_STATS_TIMEOUT, JobStatsCollector.JOB_STATS_TIMEOUT, NodeStatsCollector.NODE_STATS_TIMEOUT));
    }

    public List<String> getSettingsFilter() {
        String exportersKey = Exporters.EXPORTERS_SETTINGS.getKey();
        return Collections.unmodifiableList(Arrays.asList(exportersKey + "*.auth.*", exportersKey + "*.ssl.*"));
    }
}

