/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer.output;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerResult;

public class NormalizerResultHandler
extends AbstractComponent {
    private static final int READ_BUF_SIZE = 1024;
    private final InputStream inputStream;
    private final List<NormalizerResult> normalizedResults;

    public NormalizerResultHandler(Settings settings, InputStream inputStream) {
        super(settings);
        this.inputStream = inputStream;
        this.normalizedResults = new ArrayList<NormalizerResult>();
    }

    public List<NormalizerResult> getNormalizedResults() {
        return this.normalizedResults;
    }

    public void process() throws IOException {
        XContent xContent = XContentFactory.xContent((XContentType)XContentType.JSON);
        Object bytesRef = null;
        byte[] readBuf = new byte[1024];
        int bytesRead = this.inputStream.read(readBuf);
        while (bytesRead != -1) {
            bytesRef = bytesRef == null ? new BytesArray(readBuf, 0, bytesRead) : new CompositeBytesReference(new BytesReference[]{bytesRef, new BytesArray(readBuf, 0, bytesRead)});
            bytesRef = this.parseResults(xContent, (BytesReference)bytesRef);
            readBuf = new byte[1024];
            bytesRead = this.inputStream.read(readBuf);
        }
    }

    private BytesReference parseResults(XContent xContent, BytesReference bytesRef) throws IOException {
        int nextMarker;
        byte marker = xContent.streamSeparator();
        int from = 0;
        while ((nextMarker = NormalizerResultHandler.findNextMarker(marker, bytesRef, from)) != -1) {
            if (nextMarker > from) {
                this.parseResult(xContent, bytesRef.slice(from, nextMarker - from));
            }
            from = nextMarker + 1;
        }
        if (from >= bytesRef.length()) {
            return null;
        }
        return bytesRef.slice(from, bytesRef.length() - from);
    }

    private void parseResult(XContent xContent, BytesReference bytesRef) throws IOException {
        XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, bytesRef);
        NormalizerResult result = (NormalizerResult)NormalizerResult.PARSER.apply(parser, null);
        this.normalizedResults.add(result);
    }

    private static int findNextMarker(byte marker, BytesReference bytesRef, int from) {
        for (int i = from; i < bytesRef.length(); ++i) {
            if (bytesRef.get(i) != marker) continue;
            return i;
        }
        return -1;
    }
}

