/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobRenormalizedResultsPersister;
import org.elasticsearch.xpack.ml.job.process.normalizer.BucketNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.InfluencerNormalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Normalizable;
import org.elasticsearch.xpack.ml.job.process.normalizer.Normalizer;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.RecordNormalizable;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.job.results.Result;

public class ScoresUpdater {
    private static final Logger LOGGER = Loggers.getLogger(ScoresUpdater.class);
    private static final int TARGET_BUCKETS_TO_RENORMALIZE = 100000;
    private static final long DEFAULT_RENORMALIZATION_WINDOW_MS = 2592000000L;
    private static final int DEFAULT_BUCKETS_IN_RENORMALIZATION_WINDOW = 100;
    private static final long SECONDS_IN_DAY = 86400L;
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private final String jobId;
    private final JobProvider jobProvider;
    private final JobRenormalizedResultsPersister updatesPersister;
    private final NormalizerFactory normalizerFactory;
    private int bucketSpan;
    private long normalizationWindow;
    private volatile boolean shutdown;

    public ScoresUpdater(Job job, JobProvider jobProvider, JobRenormalizedResultsPersister jobRenormalizedResultsPersister, NormalizerFactory normalizerFactory) {
        this.jobId = job.getId();
        this.jobProvider = Objects.requireNonNull(jobProvider);
        this.updatesPersister = Objects.requireNonNull(jobRenormalizedResultsPersister);
        this.normalizerFactory = Objects.requireNonNull(normalizerFactory);
        this.bucketSpan = Long.valueOf(job.getAnalysisConfig().getBucketSpan().seconds()).intValue();
        this.normalizationWindow = this.getNormalizationWindowOrDefault(job);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private long getNormalizationWindowOrDefault(Job job) {
        if (job.getRenormalizationWindowDays() != null) {
            return job.getRenormalizationWindowDays() * 86400L * 1000L;
        }
        return Math.max(2592000000L, (long)(100 * this.bucketSpan) * 1000L);
    }

    public void update(String quantilesState, long endBucketEpochMs, long windowExtensionMs, boolean perPartitionNormalization) {
        Normalizer normalizer = this.normalizerFactory.create(this.jobId);
        int[] counts = new int[]{0, 0};
        this.updateBuckets(normalizer, quantilesState, endBucketEpochMs, windowExtensionMs, counts, perPartitionNormalization);
        this.updateRecords(normalizer, quantilesState, endBucketEpochMs, windowExtensionMs, counts, perPartitionNormalization);
        this.updateInfluencers(normalizer, quantilesState, endBucketEpochMs, windowExtensionMs, counts, perPartitionNormalization);
        this.updatesPersister.executeRequest();
        LOGGER.debug("[{}] Normalization resulted in: {} updates, {} no-ops", (Object)this.jobId, (Object)counts[0], (Object)counts[1]);
    }

    private void updateBuckets(Normalizer normalizer, String quantilesState, long endBucketEpochMs, long windowExtensionMs, int[] counts, boolean perPartitionNormalization) {
        BatchedResultsIterator<Bucket> bucketsIterator = this.jobProvider.newBatchedBucketsIterator(this.jobId).timeRange(this.calcNormalizationWindowStart(endBucketEpochMs, windowExtensionMs), endBucketEpochMs).includeInterim(false);
        ArrayList<BucketNormalizable> bucketsToRenormalize = new ArrayList<BucketNormalizable>();
        while (bucketsIterator.hasNext() && !this.shutdown) {
            Deque buckets = bucketsIterator.next();
            if (buckets.isEmpty()) {
                LOGGER.debug("[{}] No buckets to renormalize for job", (Object)this.jobId);
                break;
            }
            while (!buckets.isEmpty() && !this.shutdown) {
                Result current = (Result)buckets.removeFirst();
                if (!((Bucket)current.result).isNormalizable()) continue;
                bucketsToRenormalize.add(new BucketNormalizable((Bucket)current.result, current.index));
                if (bucketsToRenormalize.size() < 100000) continue;
                this.normalizeBuckets(normalizer, bucketsToRenormalize, quantilesState, counts, perPartitionNormalization);
                bucketsToRenormalize.clear();
            }
        }
        if (!bucketsToRenormalize.isEmpty()) {
            this.normalizeBuckets(normalizer, bucketsToRenormalize, quantilesState, counts, perPartitionNormalization);
        }
    }

    private long calcNormalizationWindowStart(long endEpochMs, long windowExtensionMs) {
        return Math.max(0L, endEpochMs - this.normalizationWindow - windowExtensionMs);
    }

    private void normalizeBuckets(Normalizer normalizer, List<BucketNormalizable> normalizableBuckets, String quantilesState, int[] counts, boolean perPartitionNormalization) {
        normalizer.normalize(this.bucketSpan, perPartitionNormalization, normalizableBuckets, quantilesState);
        for (BucketNormalizable bucketNormalizable : normalizableBuckets) {
            if (bucketNormalizable.hadBigNormalizedUpdate()) {
                this.updatesPersister.updateBucket(bucketNormalizable);
                counts[0] = counts[0] + 1;
                continue;
            }
            counts[1] = counts[1] + 1;
        }
    }

    private void updateRecords(Normalizer normalizer, String quantilesState, long endBucketEpochMs, long windowExtensionMs, int[] counts, boolean perPartitionNormalization) {
        BatchedResultsIterator<AnomalyRecord> recordsIterator = this.jobProvider.newBatchedRecordsIterator(this.jobId).timeRange(this.calcNormalizationWindowStart(endBucketEpochMs, windowExtensionMs), endBucketEpochMs).includeInterim(false);
        while (recordsIterator.hasNext() && !this.shutdown) {
            Deque records = recordsIterator.next();
            if (records.isEmpty()) {
                LOGGER.debug("[{}] No records to renormalize for job", (Object)this.jobId);
                break;
            }
            LOGGER.debug("[{}] Will renormalize a batch of {} records", (Object)this.jobId, (Object)records.size());
            List asNormalizables = records.stream().map(recordResultIndex -> new RecordNormalizable((AnomalyRecord)recordResultIndex.result, recordResultIndex.index)).collect(Collectors.toList());
            normalizer.normalize(this.bucketSpan, perPartitionNormalization, asNormalizables, quantilesState);
            this.persistChanged(counts, asNormalizables);
        }
    }

    private void updateInfluencers(Normalizer normalizer, String quantilesState, long endBucketEpochMs, long windowExtensionMs, int[] counts, boolean perPartitionNormalization) {
        BatchedResultsIterator<Influencer> influencersIterator = this.jobProvider.newBatchedInfluencersIterator(this.jobId).timeRange(this.calcNormalizationWindowStart(endBucketEpochMs, windowExtensionMs), endBucketEpochMs).includeInterim(false);
        while (influencersIterator.hasNext() && !this.shutdown) {
            Deque influencers = influencersIterator.next();
            if (influencers.isEmpty()) {
                LOGGER.debug("[{}] No influencers to renormalize for job", (Object)this.jobId);
                break;
            }
            LOGGER.debug("[{}] Will renormalize a batch of {} influencers", (Object)this.jobId, (Object)influencers.size());
            List asNormalizables = influencers.stream().map(influencerResultIndex -> new InfluencerNormalizable((Influencer)influencerResultIndex.result, influencerResultIndex.index)).collect(Collectors.toList());
            normalizer.normalize(this.bucketSpan, perPartitionNormalization, asNormalizables, quantilesState);
            this.persistChanged(counts, asNormalizables);
        }
    }

    private void persistChanged(int[] counts, List<? extends Normalizable> asNormalizables) {
        if (this.shutdown) {
            return;
        }
        List<Normalizable> toUpdate = asNormalizables.stream().filter(Normalizable::hadBigNormalizedUpdate).collect(Collectors.toList());
        counts[0] = counts[0] + toUpdate.size();
        counts[1] = counts[1] + (asNormalizables.size() - toUpdate.size());
        if (!toUpdate.isEmpty()) {
            this.updatesPersister.updateResults(toUpdate);
        }
    }
}

