/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.DefaultDetectorDescription;
import org.elasticsearch.xpack.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.ml.job.config.Detector;
import org.elasticsearch.xpack.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.utils.MlStrings;

public class FieldConfigWriter {
    private static final String DETECTOR_PREFIX = "detector.";
    private static final String DETECTOR_CLAUSE_SUFFIX = ".clause";
    private static final String DETECTOR_RULES_SUFFIX = ".rules";
    private static final String INFLUENCER_PREFIX = "influencer.";
    private static final String CATEGORIZATION_FIELD_OPTION = " categorizationfield=";
    private static final String CATEGORIZATION_FILTER_PREFIX = "categorizationfilter.";
    private static final String FILTER_PREFIX = "filter.";
    private static final char NEW_LINE = '\n';
    private final AnalysisConfig config;
    private final Set<MlFilter> filters;
    private final OutputStreamWriter writer;
    private final Logger logger;

    public FieldConfigWriter(AnalysisConfig config, Set<MlFilter> filters, OutputStreamWriter writer, Logger logger) {
        this.config = Objects.requireNonNull(config);
        this.filters = Objects.requireNonNull(filters);
        this.writer = Objects.requireNonNull(writer);
        this.logger = Objects.requireNonNull(logger);
    }

    public void write() throws IOException {
        StringBuilder contents = new StringBuilder();
        this.writeDetectors(contents);
        this.writeFilters(contents);
        FieldConfigWriter.writeAsEnumeratedSettings(CATEGORIZATION_FILTER_PREFIX, this.config.getCategorizationFilters(), contents, true);
        FieldConfigWriter.writeAsEnumeratedSettings(INFLUENCER_PREFIX, this.config.getInfluencers(), contents, false);
        this.logger.debug("FieldConfig:\n" + contents.toString());
        this.writer.write(contents.toString());
    }

    private void writeDetectors(StringBuilder contents) throws IOException {
        int counter = 0;
        for (Detector detector : this.config.getDetectors()) {
            int detectorId = counter++;
            this.writeDetectorClause(detectorId, detector, contents);
            this.writeDetectorRules(detectorId, detector, contents);
        }
    }

    private void writeDetectorClause(int detectorId, Detector detector, StringBuilder contents) {
        contents.append(DETECTOR_PREFIX).append(detectorId).append(DETECTOR_CLAUSE_SUFFIX).append(" = ");
        DefaultDetectorDescription.appendOn(detector, contents);
        if (!Strings.isNullOrEmpty((String)this.config.getCategorizationFieldName())) {
            contents.append(CATEGORIZATION_FIELD_OPTION).append(FieldConfigWriter.quoteField(this.config.getCategorizationFieldName()));
        }
        contents.append('\n');
    }

    private void writeDetectorRules(int detectorId, Detector detector, StringBuilder contents) throws IOException {
        List<DetectionRule> rules = detector.getDetectorRules();
        if (rules == null || rules.isEmpty()) {
            return;
        }
        contents.append(DETECTOR_PREFIX).append(detectorId).append(DETECTOR_RULES_SUFFIX).append(" = ");
        contents.append('[');
        boolean first = true;
        for (DetectionRule rule : detector.getDetectorRules()) {
            if (first) {
                first = false;
            } else {
                contents.append(',');
            }
            XContentBuilder contentBuilder = XContentFactory.jsonBuilder();
            Throwable throwable = null;
            try {
                contents.append(rule.toXContent(contentBuilder, ToXContent.EMPTY_PARAMS).string());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (contentBuilder == null) continue;
                if (throwable != null) {
                    try {
                        contentBuilder.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                contentBuilder.close();
            }
        }
        contents.append(']');
        contents.append('\n');
    }

    private void writeFilters(StringBuilder buffer) throws IOException {
        for (MlFilter filter : this.filters) {
            StringBuilder filterAsJson = new StringBuilder();
            filterAsJson.append('[');
            boolean first = true;
            for (String item : filter.getItems()) {
                if (first) {
                    first = false;
                } else {
                    filterAsJson.append(',');
                }
                filterAsJson.append('\"');
                filterAsJson.append(item);
                filterAsJson.append('\"');
            }
            filterAsJson.append(']');
            buffer.append(FILTER_PREFIX).append(filter.getId()).append(" = ").append((CharSequence)filterAsJson).append('\n');
        }
    }

    private static void writeAsEnumeratedSettings(String settingName, List<String> values, StringBuilder buffer, boolean quote) {
        if (values == null) {
            return;
        }
        int counter = 0;
        for (String value : values) {
            buffer.append(settingName).append(counter++).append(" = ").append(quote ? FieldConfigWriter.quoteField(value) : value).append('\n');
        }
    }

    private static String quoteField(String field) {
        return MlStrings.doubleQuoteIfNotAlphaNumeric(field);
    }
}

