/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobRenormalizedResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectCommunicator;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.ProcessContext;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.AutoDetectResultProcessor;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.ScoresUpdater;
import org.elasticsearch.xpack.ml.job.process.normalizer.ShortCircuitingRenormalizer;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class AutodetectProcessManager
extends AbstractComponent {
    @Deprecated
    public static final Setting<Integer> MAX_RUNNING_JOBS_PER_NODE = Setting.intSetting((String)"max_running_jobs", (int)20, (int)1, (int)512, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<Integer> MAX_OPEN_JOBS_PER_NODE = Setting.intSetting((String)"xpack.ml.max_open_jobs", MAX_RUNNING_JOBS_PER_NODE, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Client client;
    private final ThreadPool threadPool;
    private final JobManager jobManager;
    private final JobProvider jobProvider;
    private final AutodetectProcessFactory autodetectProcessFactory;
    private final NormalizerFactory normalizerFactory;
    private final JobResultsPersister jobResultsPersister;
    private final JobDataCountsPersister jobDataCountsPersister;
    private final ConcurrentMap<Long, ProcessContext> processByAllocation = new ConcurrentHashMap<Long, ProcessContext>();
    private final int maxAllowedRunningJobs;
    private final NamedXContentRegistry xContentRegistry;
    private final Auditor auditor;

    public AutodetectProcessManager(Settings settings, Client client, ThreadPool threadPool, JobManager jobManager, JobProvider jobProvider, JobResultsPersister jobResultsPersister, JobDataCountsPersister jobDataCountsPersister, AutodetectProcessFactory autodetectProcessFactory, NormalizerFactory normalizerFactory, NamedXContentRegistry xContentRegistry, Auditor auditor) {
        super(settings);
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.maxAllowedRunningJobs = (Integer)MAX_OPEN_JOBS_PER_NODE.get(settings);
        this.autodetectProcessFactory = autodetectProcessFactory;
        this.normalizerFactory = normalizerFactory;
        this.jobManager = jobManager;
        this.jobProvider = jobProvider;
        this.jobResultsPersister = jobResultsPersister;
        this.jobDataCountsPersister = jobDataCountsPersister;
        this.auditor = auditor;
    }

    public synchronized void closeAllJobsOnThisNode(String reason) throws IOException {
        int numJobs = this.processByAllocation.size();
        if (numJobs != 0) {
            this.logger.info("Closing [{}] jobs, because [{}]", (Object)numJobs, (Object)reason);
            for (ProcessContext process : this.processByAllocation.values()) {
                this.closeJob(process.getJobTask(), false, reason);
            }
        }
    }

    public void killProcess(OpenJobAction.JobTask jobTask, boolean awaitCompletion, String reason) {
        ProcessContext processContext = (ProcessContext)this.processByAllocation.remove(jobTask.getAllocationId());
        if (processContext != null) {
            processContext.newKillBuilder().setAwaitCompletion(awaitCompletion).setFinish(true).setReason(reason).kill();
        }
    }

    public void killAllProcessesOnThisNode() {
        Iterator iterator = this.processByAllocation.values().iterator();
        while (iterator.hasNext()) {
            ProcessContext processContext = (ProcessContext)iterator.next();
            processContext.newKillBuilder().setAwaitCompletion(false).setFinish(false).setSilent(true).kill();
            iterator.remove();
        }
    }

    public void processData(OpenJobAction.JobTask jobTask, InputStream input, XContentType xContentType, DataLoadParams params, BiConsumer<DataCounts, Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            throw ExceptionsHelper.conflictStatusException("Cannot process data because job [" + jobTask.getJobId() + "] is not open", new Object[0]);
        }
        communicator.writeToJob(input, xContentType, params, handler);
    }

    public void flushJob(OpenJobAction.JobTask jobTask, FlushJobParams params, ActionListener<FlushAcknowledgement> handler) {
        this.logger.debug("Flushing job {}", (Object)jobTask.getJobId());
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot flush because job [%s] is not open", jobTask.getJobId());
            this.logger.debug(message);
            handler.onFailure((Exception)ExceptionsHelper.conflictStatusException(message, new Object[0]));
            return;
        }
        communicator.flushJob(params, (flushAcknowledgement, e) -> {
            if (e != null) {
                String msg = String.format(Locale.ROOT, "[%s] exception while flushing job", jobTask.getJobId());
                this.logger.error(msg);
                handler.onFailure((Exception)ExceptionsHelper.serverError(msg, e));
            } else {
                handler.onResponse(flushAcknowledgement);
            }
        });
    }

    public void forecastJob(OpenJobAction.JobTask jobTask, ForecastParams params, Consumer<Exception> handler) {
        this.logger.debug("Forecasting job {}", (Object)jobTask.getJobId());
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot forecast because job [%s] is not open", jobTask.getJobId());
            this.logger.debug(message);
            handler.accept((Exception)ExceptionsHelper.conflictStatusException(message, new Object[0]));
            return;
        }
        communicator.forecastJob(params, (aVoid, e) -> {
            if (e == null) {
                handler.accept(null);
            } else {
                String msg = String.format(Locale.ROOT, "[%s] exception while forecasting job", jobTask.getJobId());
                this.logger.error(msg, (Throwable)e);
                handler.accept((Exception)ExceptionsHelper.serverError(msg, e));
            }
        });
    }

    public void writeUpdateProcessMessage(OpenJobAction.JobTask jobTask, List<JobUpdate.DetectorUpdate> updates, ModelPlotConfig config, Consumer<Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = "Cannot process update model debug config because job [" + jobTask.getJobId() + "] is not open";
            this.logger.debug(message);
            handler.accept((Exception)ExceptionsHelper.conflictStatusException(message, new Object[0]));
            return;
        }
        communicator.writeUpdateProcessMessage(config, updates, (aVoid, e) -> {
            if (e == null) {
                handler.accept(null);
            } else {
                handler.accept((Exception)e);
            }
        });
    }

    public void openJob(final OpenJobAction.JobTask jobTask, final Consumer<Exception> handler) {
        final String jobId = jobTask.getJobId();
        Job job = this.jobManager.getJobOrThrowIfUnknown(jobId);
        if (job.getJobVersion() == null) {
            handler.accept((Exception)ExceptionsHelper.badRequestException("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported", new Object[0]));
            return;
        }
        this.logger.info("Opening job [{}]", (Object)jobId);
        this.processByAllocation.putIfAbsent(jobTask.getAllocationId(), new ProcessContext(jobTask));
        this.jobProvider.getAutodetectParams(job, params -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable((AutodetectParams)params){
            final /* synthetic */ AutodetectParams val$params;
            {
                this.val$params = autodetectParams;
            }

            public void onFailure(Exception e) {
                handler.accept(e);
            }

            protected void doRun() throws Exception {
                ProcessContext processContext = (ProcessContext)AutodetectProcessManager.this.processByAllocation.get(jobTask.getAllocationId());
                if (processContext == null) {
                    AutodetectProcessManager.this.logger.debug("Aborted opening job [{}] as it has been closed", (Object)jobId);
                    return;
                }
                if (processContext.getState() != ProcessContext.ProcessStateName.NOT_RUNNING) {
                    AutodetectProcessManager.this.logger.debug("Cannot open job [{}] when its state is [{}]", (Object)jobId, (Object)((Object)((Object)processContext.getState())).getClass().getName());
                    return;
                }
                try {
                    AutodetectProcessManager.this.createProcessAndSetRunning(processContext, this.val$params, handler);
                    processContext.getAutodetectCommunicator().init(this.val$params.modelSnapshot());
                    AutodetectProcessManager.this.setJobState(jobTask, JobState.OPENED);
                }
                catch (Exception e1) {
                    try {
                        processContext.newKillBuilder().setAwaitCompletion(false).setFinish(false).kill();
                        AutodetectProcessManager.this.processByAllocation.remove(jobTask.getAllocationId());
                    }
                    finally {
                        AutodetectProcessManager.this.setJobState(jobTask, JobState.FAILED, (CheckedConsumer<Exception, IOException>)((CheckedConsumer)e2 -> handler.accept(e1)));
                    }
                }
            }
        }), e1 -> {
            this.logger.warn("Failed to gather information required to open job [" + jobId + "]", (Throwable)e1);
            this.setJobState(jobTask, JobState.FAILED, (CheckedConsumer<Exception, IOException>)((CheckedConsumer)e2 -> handler.accept((Exception)e1)));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProcessAndSetRunning(ProcessContext processContext, AutodetectParams params, Consumer<Exception> handler) {
        processContext.tryLock();
        try {
            AutodetectCommunicator communicator = this.create(processContext.getJobTask(), params, handler);
            processContext.setRunning(communicator);
        }
        finally {
            processContext.unlock();
        }
    }

    AutodetectCommunicator create(OpenJobAction.JobTask jobTask, AutodetectParams autodetectParams, Consumer<Exception> handler) {
        ExecutorService autodetectWorkerExecutor;
        int currentRunningJobs = this.processByAllocation.size();
        if (currentRunningJobs > this.maxAllowedRunningJobs) {
            throw new ElasticsearchStatusException("max running job capacity [" + this.maxAllowedRunningJobs + "] reached", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
        }
        String jobId = jobTask.getJobId();
        this.notifyLoadingSnapshot(jobId, autodetectParams);
        if (autodetectParams.dataCounts().getProcessedRecordCount() > 0L) {
            String msg;
            if (autodetectParams.modelSnapshot() == null) {
                msg = "No model snapshot could be found for a job with processed records";
                this.logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                this.auditor.warning(jobId, "No model snapshot could be found for a job with processed records");
            }
            if (autodetectParams.quantiles() == null) {
                msg = "No quantiles could be found for a job with processed records";
                this.logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                this.auditor.warning(jobId, msg);
            }
        }
        Job job = this.jobManager.getJobOrThrowIfUnknown(jobId);
        ExecutorService autoDetectExecutorService = this.threadPool.executor("ml_autodetect");
        DataCountsReporter dataCountsReporter = new DataCountsReporter(this.settings, job, autodetectParams.dataCounts(), this.jobDataCountsPersister);
        ScoresUpdater scoresUpdater = new ScoresUpdater(job, this.jobProvider, new JobRenormalizedResultsPersister(job.getId(), this.settings, this.client), this.normalizerFactory);
        ExecutorService renormalizerExecutorService = this.threadPool.executor("ml_utility");
        ShortCircuitingRenormalizer renormalizer = new ShortCircuitingRenormalizer(jobId, scoresUpdater, renormalizerExecutorService, job.getAnalysisConfig().getUsePerPartitionNormalization());
        AutodetectProcess process = this.autodetectProcessFactory.createAutodetectProcess(job, autodetectParams.modelSnapshot(), autodetectParams.quantiles(), autodetectParams.filters(), autoDetectExecutorService, this.onProcessCrash(jobTask));
        AutoDetectResultProcessor processor = new AutoDetectResultProcessor(this.client, jobId, renormalizer, this.jobResultsPersister, this.jobProvider, autodetectParams.modelSizeStats(), autodetectParams.modelSnapshot() != null);
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            autodetectWorkerExecutor = this.createAutodetectExecutorService(autoDetectExecutorService);
            autoDetectExecutorService.submit(() -> processor.process(process));
        }
        catch (EsRejectedExecutionException e) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{process});
            }
            catch (IOException ioe) {
                this.logger.error("Can't close autodetect", (Throwable)ioe);
            }
            throw e;
        }
        return new AutodetectCommunicator(job, process, new StateStreamer(this.client), dataCountsReporter, processor, handler, this.xContentRegistry, autodetectWorkerExecutor);
    }

    private void notifyLoadingSnapshot(String jobId, AutodetectParams autodetectParams) {
        ModelSnapshot modelSnapshot = autodetectParams.modelSnapshot();
        StringBuilder msgBuilder = new StringBuilder("Loading model snapshot [");
        if (modelSnapshot == null) {
            msgBuilder.append("N/A");
        } else {
            msgBuilder.append(modelSnapshot.getSnapshotId());
            msgBuilder.append("] with latest_record_timestamp [");
            Date snapshotLatestRecordTimestamp = modelSnapshot.getLatestRecordTimeStamp();
            msgBuilder.append(snapshotLatestRecordTimestamp == null ? "N/A" : XContentBuilder.DEFAULT_DATE_PRINTER.print(snapshotLatestRecordTimestamp.getTime()));
        }
        msgBuilder.append("], job latest_record_timestamp [");
        Date jobLatestRecordTimestamp = autodetectParams.dataCounts().getLatestRecordTimeStamp();
        msgBuilder.append(jobLatestRecordTimestamp == null ? "N/A" : XContentBuilder.DEFAULT_DATE_PRINTER.print(jobLatestRecordTimestamp.getTime()));
        msgBuilder.append("]");
        String msg = msgBuilder.toString();
        this.logger.info("[{}] {}", (Object)jobId, (Object)msg);
        this.auditor.info(jobId, msg);
    }

    private Runnable onProcessCrash(OpenJobAction.JobTask jobTask) {
        return () -> {
            this.processByAllocation.remove(jobTask.getAllocationId());
            this.setJobState(jobTask, JobState.FAILED);
        };
    }

    public void closeJob(OpenJobAction.JobTask jobTask, boolean restart, String reason) {
        String jobId = jobTask.getJobId();
        long allocationId = jobTask.getAllocationId();
        this.logger.debug("Attempting to close job [{}], because [{}]", (Object)jobId, (Object)reason);
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(allocationId);
        if (processContext == null) {
            this.logger.debug("Cannot close job [{}] as it has already been closed", (Object)jobId);
            return;
        }
        processContext.tryLock();
        try {
            if (!processContext.setDying()) {
                this.logger.debug("Cannot close job [{}] as it has already been closed", (Object)jobId);
                return;
            }
            if (reason == null) {
                this.logger.info("Closing job [{}]", (Object)jobId);
            } else {
                this.logger.info("Closing job [{}], because [{}]", (Object)jobId, (Object)reason);
            }
            AutodetectCommunicator communicator = processContext.getAutodetectCommunicator();
            if (communicator == null) {
                this.logger.debug("Job [{}] is being closed before its process is started", (Object)jobId);
                jobTask.markAsCompleted();
                return;
            }
            communicator.close(restart, reason);
            this.processByAllocation.remove(allocationId);
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).status() == RestStatus.CONFLICT) {
                throw e;
            }
            this.logger.warn("[" + jobId + "] Exception closing autodetect process", (Throwable)e);
            this.setJobState(jobTask, JobState.FAILED);
            throw ExceptionsHelper.serverError("Exception closing autodetect process", e);
        }
        finally {
            processContext.unlock();
        }
    }

    int numberOfOpenJobs() {
        return (int)this.processByAllocation.values().stream().filter(p -> p.getState() != ProcessContext.ProcessStateName.DYING).count();
    }

    boolean jobHasActiveAutodetectProcess(OpenJobAction.JobTask jobTask) {
        return this.getAutodetectCommunicator(jobTask) != null;
    }

    private AutodetectCommunicator getAutodetectCommunicator(OpenJobAction.JobTask jobTask) {
        return this.processByAllocation.getOrDefault(jobTask.getAllocationId(), new ProcessContext(jobTask)).getAutodetectCommunicator();
    }

    private AutodetectCommunicator getOpenAutodetectCommunicator(OpenJobAction.JobTask jobTask) {
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(jobTask.getAllocationId());
        if (processContext != null && processContext.getState() == ProcessContext.ProcessStateName.RUNNING) {
            return processContext.getAutodetectCommunicator();
        }
        return null;
    }

    public Optional<Duration> jobOpenTime(OpenJobAction.JobTask jobTask) {
        AutodetectCommunicator communicator = this.getAutodetectCommunicator(jobTask);
        if (communicator == null) {
            return Optional.empty();
        }
        return Optional.of(Duration.between(communicator.getProcessStartTime(), ZonedDateTime.now()));
    }

    void setJobState(final OpenJobAction.JobTask jobTask, final JobState state) {
        JobTaskStatus taskStatus = new JobTaskStatus(state, jobTask.getAllocationId());
        jobTask.updatePersistentStatus(taskStatus, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                AutodetectProcessManager.this.logger.info("Successfully set job state to [{}] for job [{}]", (Object)state, (Object)jobTask.getJobId());
            }

            public void onFailure(Exception e) {
                AutodetectProcessManager.this.logger.error("Could not set job state to [" + (Object)((Object)state) + "] for job [" + jobTask.getJobId() + "]", (Throwable)e);
            }
        });
    }

    void setJobState(OpenJobAction.JobTask jobTask, JobState state, final CheckedConsumer<Exception, IOException> handler) {
        JobTaskStatus taskStatus = new JobTaskStatus(state, jobTask.getAllocationId());
        jobTask.updatePersistentStatus(taskStatus, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                try {
                    handler.accept(null);
                }
                catch (IOException e1) {
                    AutodetectProcessManager.this.logger.warn("Error while delegating response", (Throwable)e1);
                }
            }

            public void onFailure(Exception e) {
                try {
                    handler.accept((Object)e);
                }
                catch (IOException e1) {
                    AutodetectProcessManager.this.logger.warn("Error while delegating exception [" + e.getMessage() + "]", (Throwable)e1);
                }
            }
        });
    }

    public Optional<Tuple<DataCounts, ModelSizeStats>> getStatistics(OpenJobAction.JobTask jobTask) {
        AutodetectCommunicator communicator = this.getAutodetectCommunicator(jobTask);
        if (communicator == null) {
            return Optional.empty();
        }
        return Optional.of(new Tuple((Object)communicator.getDataCounts(), (Object)communicator.getModelSizeStats()));
    }

    ExecutorService createAutodetectExecutorService(ExecutorService executorService) {
        AutodetectWorkerExecutorService autoDetectWorkerExecutor = new AutodetectWorkerExecutorService(this.threadPool.getThreadContext());
        executorService.submit(autoDetectWorkerExecutor::start);
        return autoDetectWorkerExecutor;
    }

    class AutodetectWorkerExecutorService
    extends AbstractExecutorService {
        private final ThreadContext contextHolder;
        private final CountDownLatch awaitTermination = new CountDownLatch(1);
        private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(100);
        private volatile boolean running = true;

        AutodetectWorkerExecutorService(ThreadContext contextHolder) {
            this.contextHolder = contextHolder;
        }

        @Override
        public void shutdown() {
            this.running = false;
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public boolean isShutdown() {
            return !this.running;
        }

        @Override
        public boolean isTerminated() {
            return this.awaitTermination.getCount() == 0L;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.awaitTermination.await(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            boolean added = this.queue.offer(this.contextHolder.preserveContext(command));
            if (!added) {
                throw new ElasticsearchStatusException("Unable to submit operation", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
            }
        }

        void start() {
            block9: {
                block7: while (true) {
                    try {
                        while (this.running) {
                            Runnable runnable = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                            if (runnable == null) continue;
                            try {
                                runnable.run();
                                continue block7;
                            }
                            catch (Exception e) {
                                AutodetectProcessManager.this.logger.error("error handling job operation", (Throwable)e);
                            }
                        }
                        break block9;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break block9;
                    }
                }
                finally {
                    this.awaitTermination.countDown();
                }
            }
        }
    }
}

