/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.results.Result;

public class JobDataDeleter {
    private static final Logger LOGGER = Loggers.getLogger(JobDataDeleter.class);
    private final Client client;
    private final String jobId;

    public JobDataDeleter(Client client, String jobId) {
        this.client = Objects.requireNonNull(client);
        this.jobId = Objects.requireNonNull(jobId);
    }

    public void deleteModelSnapshots(List<ModelSnapshot> modelSnapshots, ActionListener<BulkResponse> listener) {
        if (modelSnapshots.isEmpty()) {
            listener.onResponse((Object)new BulkResponse(new BulkItemResponse[0], 0L));
            return;
        }
        String stateIndexName = AnomalyDetectorsIndex.jobStateIndexName();
        ActionListener docDeleteListener = ActionListener.wrap(response -> {
            if (!response.hasFailures()) {
                listener.onResponse(response);
                return;
            }
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            for (ModelSnapshot modelSnapshot : modelSnapshots) {
                for (String stateDocId : modelSnapshot.legacyStateDocumentIds()) {
                    bulkRequestBuilder.add(this.client.prepareDelete(stateIndexName, "model_state", stateDocId));
                }
                bulkRequestBuilder.add(this.client.prepareDelete(AnomalyDetectorsIndex.jobResultsAliasedName(modelSnapshot.getJobId()), ModelSnapshot.TYPE.getPreferredName(), ModelSnapshot.v54DocumentId(modelSnapshot)));
            }
            bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            try {
                bulkRequestBuilder.execute(ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
                    if (e instanceof IllegalArgumentException && e.getMessage().contains("as the final mapping would have more than 1 type")) {
                        listener.onResponse(response);
                    }
                    listener.onFailure(e);
                }));
            }
            catch (Exception e2) {
                listener.onFailure(e2);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        for (ModelSnapshot modelSnapshot : modelSnapshots) {
            for (String stateDocId : modelSnapshot.stateDocumentIds()) {
                bulkRequestBuilder.add(this.client.prepareDelete(stateIndexName, "doc", stateDocId));
            }
            bulkRequestBuilder.add(this.client.prepareDelete(AnomalyDetectorsIndex.jobResultsAliasedName(modelSnapshot.getJobId()), "doc", ModelSnapshot.documentId(modelSnapshot)));
        }
        bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            ClientHelper.executeAsyncWithOrigin(this.client, "ml", BulkAction.INSTANCE, bulkRequestBuilder.request(), docDeleteListener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteResultsFromTime(long cutoffEpochMs, ActionListener<Boolean> listener) {
        DeleteByQueryHolder deleteByQueryHolder = new DeleteByQueryHolder(AnomalyDetectorsIndex.jobResultsAliasedName(this.jobId));
        deleteByQueryHolder.dbqRequest.setRefresh(true);
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)Result.RESULT_TYPE.getPreferredName())).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).gte((Object)cutoffEpochMs));
        deleteByQueryHolder.searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        deleteByQueryHolder.searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        ClientHelper.executeAsyncWithOrigin(this.client, "ml", DeleteByQueryAction.INSTANCE, deleteByQueryHolder.dbqRequest, ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteInterimResults() {
        DeleteByQueryHolder deleteByQueryHolder = new DeleteByQueryHolder(AnomalyDetectorsIndex.jobResultsAliasedName(this.jobId));
        deleteByQueryHolder.dbqRequest.setRefresh(false);
        deleteByQueryHolder.searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        TermQueryBuilder qb = QueryBuilders.termQuery((String)Result.IS_INTERIM.getPreferredName(), (boolean)true);
        deleteByQueryHolder.searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)new ConstantScoreQueryBuilder((QueryBuilder)qb)));
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(this.client.threadPool().getThreadContext(), "ml");){
            this.client.execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryHolder.dbqRequest).get();
        }
        catch (Exception e) {
            LOGGER.error("[" + this.jobId + "] An error occurred while deleting interim results", (Throwable)e);
        }
    }

    private static class DeleteByQueryHolder {
        private final SearchRequest searchRequest;
        private final DeleteByQueryRequest dbqRequest;

        private DeleteByQueryHolder(String index) {
            this.searchRequest = new SearchRequest(new String[]{index});
            this.dbqRequest = new DeleteByQueryRequest(this.searchRequest);
            this.dbqRequest.setSlices(5);
            this.dbqRequest.setAbortOnVersionConflict(false);
        }
    }
}

