/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.MlParserType;
import org.elasticsearch.xpack.ml.job.config.Connective;
import org.elasticsearch.xpack.ml.job.config.RuleAction;
import org.elasticsearch.xpack.ml.job.config.RuleCondition;
import org.elasticsearch.xpack.ml.job.config.RuleConditionType;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class DetectionRule
implements ToXContentObject,
Writeable {
    public static final ParseField DETECTION_RULE_FIELD = new ParseField("detection_rule", new String[0]);
    public static final ParseField RULE_ACTION_FIELD = new ParseField("rule_action", new String[0]);
    public static final ParseField TARGET_FIELD_NAME_FIELD = new ParseField("target_field_name", new String[0]);
    public static final ParseField TARGET_FIELD_VALUE_FIELD = new ParseField("target_field_value", new String[0]);
    public static final ParseField CONDITIONS_CONNECTIVE_FIELD = new ParseField("conditions_connective", new String[0]);
    public static final ParseField RULE_CONDITIONS_FIELD = new ParseField("rule_conditions", new String[0]);
    public static final ObjectParser<Builder, Void> METADATA_PARSER = new ObjectParser(DETECTION_RULE_FIELD.getPreferredName(), true, () -> new Builder());
    public static final ObjectParser<Builder, Void> CONFIG_PARSER = new ObjectParser(DETECTION_RULE_FIELD.getPreferredName(), false, () -> new Builder());
    public static final Map<MlParserType, ObjectParser<Builder, Void>> PARSERS = new EnumMap<MlParserType, ObjectParser<Builder, Void>>(MlParserType.class);
    private final RuleAction ruleAction;
    private final String targetFieldName;
    private final String targetFieldValue;
    private final Connective conditionsConnective;
    private final List<RuleCondition> ruleConditions;

    private DetectionRule(RuleAction ruleAction, @Nullable String targetFieldName, @Nullable String targetFieldValue, Connective conditionsConnective, List<RuleCondition> ruleConditions) {
        this.ruleAction = Objects.requireNonNull(ruleAction);
        this.targetFieldName = targetFieldName;
        this.targetFieldValue = targetFieldValue;
        this.conditionsConnective = Objects.requireNonNull(conditionsConnective);
        this.ruleConditions = Collections.unmodifiableList(ruleConditions);
    }

    public DetectionRule(StreamInput in) throws IOException {
        this.ruleAction = RuleAction.readFromStream(in);
        this.conditionsConnective = Connective.readFromStream(in);
        int size = in.readVInt();
        this.ruleConditions = new ArrayList<RuleCondition>(size);
        for (int i = 0; i < size; ++i) {
            this.ruleConditions.add(new RuleCondition(in));
        }
        this.targetFieldName = in.readOptionalString();
        this.targetFieldValue = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.ruleAction.writeTo(out);
        this.conditionsConnective.writeTo(out);
        out.writeVInt(this.ruleConditions.size());
        for (RuleCondition condition : this.ruleConditions) {
            condition.writeTo(out);
        }
        out.writeOptionalString(this.targetFieldName);
        out.writeOptionalString(this.targetFieldValue);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RULE_ACTION_FIELD.getPreferredName(), (Object)this.ruleAction);
        builder.field(CONDITIONS_CONNECTIVE_FIELD.getPreferredName(), (Object)this.conditionsConnective);
        builder.field(RULE_CONDITIONS_FIELD.getPreferredName(), this.ruleConditions);
        if (this.targetFieldName != null) {
            builder.field(TARGET_FIELD_NAME_FIELD.getPreferredName(), this.targetFieldName);
        }
        if (this.targetFieldValue != null) {
            builder.field(TARGET_FIELD_VALUE_FIELD.getPreferredName(), this.targetFieldValue);
        }
        builder.endObject();
        return builder;
    }

    public RuleAction getRuleAction() {
        return this.ruleAction;
    }

    @Nullable
    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    @Nullable
    public String getTargetFieldValue() {
        return this.targetFieldValue;
    }

    public Connective getConditionsConnective() {
        return this.conditionsConnective;
    }

    public List<RuleCondition> getRuleConditions() {
        return this.ruleConditions;
    }

    public Set<String> extractReferencedFilters() {
        return this.ruleConditions.stream().map(RuleCondition::getValueFilter).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DetectionRule)) {
            return false;
        }
        DetectionRule other = (DetectionRule)obj;
        return Objects.equals((Object)this.ruleAction, (Object)other.ruleAction) && Objects.equals(this.targetFieldName, other.targetFieldName) && Objects.equals(this.targetFieldValue, other.targetFieldValue) && Objects.equals((Object)this.conditionsConnective, (Object)other.conditionsConnective) && Objects.equals(this.ruleConditions, other.ruleConditions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ruleAction, this.targetFieldName, this.targetFieldValue, this.conditionsConnective, this.ruleConditions});
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ObjectParser<Builder, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareField(Builder::setRuleAction, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return RuleAction.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, RULE_ACTION_FIELD, ObjectParser.ValueType.STRING);
            parser.declareString(Builder::setTargetFieldName, TARGET_FIELD_NAME_FIELD);
            parser.declareString(Builder::setTargetFieldValue, TARGET_FIELD_VALUE_FIELD);
            parser.declareField(Builder::setConditionsConnective, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return Connective.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, CONDITIONS_CONNECTIVE_FIELD, ObjectParser.ValueType.STRING);
            parser.declareObjectArray(Builder::setRuleConditions, (p, c) -> (RuleCondition)RuleCondition.PARSERS.get((Object)parserType).apply(p, c), RULE_CONDITIONS_FIELD);
        }
    }

    public static class Builder {
        private RuleAction ruleAction = RuleAction.FILTER_RESULTS;
        private String targetFieldName;
        private String targetFieldValue;
        private Connective conditionsConnective = Connective.OR;
        private List<RuleCondition> ruleConditions = Collections.emptyList();

        public Builder(List<RuleCondition> ruleConditions) {
            this.ruleConditions = ExceptionsHelper.requireNonNull(ruleConditions, RULE_CONDITIONS_FIELD.getPreferredName());
        }

        private Builder() {
        }

        public Builder setRuleAction(RuleAction ruleAction) {
            this.ruleAction = ExceptionsHelper.requireNonNull(ruleAction, RULE_ACTION_FIELD.getPreferredName());
            return this;
        }

        public Builder setTargetFieldName(String targetFieldName) {
            this.targetFieldName = targetFieldName;
            return this;
        }

        public Builder setTargetFieldValue(String targetFieldValue) {
            this.targetFieldValue = targetFieldValue;
            return this;
        }

        public Builder setConditionsConnective(Connective connective) {
            this.conditionsConnective = ExceptionsHelper.requireNonNull(connective, CONDITIONS_CONNECTIVE_FIELD.getPreferredName());
            return this;
        }

        public Builder setRuleConditions(List<RuleCondition> ruleConditions) {
            this.ruleConditions = ExceptionsHelper.requireNonNull(ruleConditions, RULE_ACTION_FIELD.getPreferredName());
            return this;
        }

        public DetectionRule build() {
            if (this.targetFieldValue != null && this.targetFieldName == null) {
                String msg = Messages.getMessage("Invalid detector rule: missing target_field_name where target_field_value ''{0}'' is set", this.targetFieldValue);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            if (this.ruleConditions == null || this.ruleConditions.isEmpty()) {
                String msg = Messages.getMessage("Invalid detector rule: at least one rule_condition is required");
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            for (RuleCondition condition : this.ruleConditions) {
                if (condition.getConditionType() != RuleConditionType.CATEGORICAL || this.targetFieldName == null) continue;
                String msg = Messages.getMessage("Invalid detector rule: a categorical rule_condition does not support {0}", TARGET_FIELD_NAME_FIELD.getPreferredName());
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            return new DetectionRule(this.ruleAction, this.targetFieldName, this.targetFieldValue, this.conditionsConnective, this.ruleConditions);
        }
    }
}

