/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ExtractedField;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.MlStrings;

class ExtractedFields {
    private static final String TEXT = "text";
    private final ExtractedField timeField;
    private final List<ExtractedField> allFields;
    private final String[] docValueFields;
    private final String[] sourceFields;

    ExtractedFields(ExtractedField timeField, List<ExtractedField> allFields) {
        if (!allFields.contains(timeField)) {
            throw new IllegalArgumentException("timeField should also be contained in allFields");
        }
        this.timeField = Objects.requireNonNull(timeField);
        this.allFields = Collections.unmodifiableList(allFields);
        this.docValueFields = ExtractedFields.filterFields(ExtractedField.ExtractionMethod.DOC_VALUE, allFields);
        this.sourceFields = ExtractedFields.filterFields(ExtractedField.ExtractionMethod.SOURCE, allFields);
    }

    public List<ExtractedField> getAllFields() {
        return this.allFields;
    }

    public String[] getSourceFields() {
        return this.sourceFields;
    }

    public String[] getDocValueFields() {
        return this.docValueFields;
    }

    private static String[] filterFields(ExtractedField.ExtractionMethod method, List<ExtractedField> fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (ExtractedField field : fields) {
            if (field.getExtractionMethod() != method) continue;
            result.add(field.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public String timeField() {
        return this.timeField.getName();
    }

    public Long timeFieldValue(SearchHit hit) {
        Object[] value = this.timeField.value(hit);
        if (value.length != 1) {
            throw new RuntimeException("Time field [" + this.timeField.getAlias() + "] expected a single value; actual was: " + Arrays.toString(value));
        }
        if (value[0] instanceof Long) {
            return (Long)value[0];
        }
        throw new RuntimeException("Time field [" + this.timeField.getAlias() + "] expected a long value; actual was: " + value[0]);
    }

    public static ExtractedFields build(Job job, DatafeedConfig datafeed, FieldCapabilitiesResponse fieldsCapabilities) {
        Set scriptFields = datafeed.getScriptFields().stream().map(sf -> sf.fieldName()).collect(Collectors.toSet());
        ExtractionMethodDetector extractionMethodDetector = new ExtractionMethodDetector(datafeed.getId(), scriptFields, fieldsCapabilities);
        String timeField = job.getDataDescription().getTimeField();
        if (!scriptFields.contains(timeField) && !extractionMethodDetector.isAggregatable(timeField)) {
            throw ExceptionsHelper.badRequestException("datafeed [" + datafeed.getId() + "] cannot retrieve time field [" + timeField + "] because it is not aggregatable", new Object[0]);
        }
        ExtractedField timeExtractedField = ExtractedField.newTimeField(timeField, scriptFields.contains(timeField) ? ExtractedField.ExtractionMethod.SCRIPT_FIELD : ExtractedField.ExtractionMethod.DOC_VALUE);
        List remainingFields = job.allFields().stream().filter(f -> !f.equals(timeField) && !f.equals("mlcategory")).collect(Collectors.toList());
        ArrayList<ExtractedField> allExtractedFields = new ArrayList<ExtractedField>(remainingFields.size() + 1);
        allExtractedFields.add(timeExtractedField);
        remainingFields.stream().forEach(field -> allExtractedFields.add(extractionMethodDetector.detect(field)));
        return new ExtractedFields(timeExtractedField, allExtractedFields);
    }

    private static class ExtractionMethodDetector {
        private final String datafeedId;
        private final Set<String> scriptFields;
        private final FieldCapabilitiesResponse fieldsCapabilities;

        private ExtractionMethodDetector(String datafeedId, Set<String> scriptFields, FieldCapabilitiesResponse fieldsCapabilities) {
            this.datafeedId = datafeedId;
            this.scriptFields = scriptFields;
            this.fieldsCapabilities = fieldsCapabilities;
        }

        private ExtractedField detect(String field) {
            String parentField;
            String internalField = field;
            ExtractedField.ExtractionMethod method = ExtractedField.ExtractionMethod.SOURCE;
            if (this.scriptFields.contains(field)) {
                method = ExtractedField.ExtractionMethod.SCRIPT_FIELD;
            } else if (this.isAggregatable(field)) {
                method = ExtractedField.ExtractionMethod.DOC_VALUE;
            } else if (this.isText(field) && !Objects.equals(parentField = MlStrings.getParentField(field), field) && this.fieldsCapabilities.getField(parentField) != null) {
                internalField = parentField;
                method = this.isAggregatable(parentField) ? ExtractedField.ExtractionMethod.DOC_VALUE : ExtractedField.ExtractionMethod.SOURCE;
            }
            return ExtractedField.newField(field, internalField, method);
        }

        private boolean isAggregatable(String field) {
            Map fieldCaps = this.fieldsCapabilities.getField(field);
            if (fieldCaps == null || fieldCaps.isEmpty()) {
                throw ExceptionsHelper.badRequestException("datafeed [" + this.datafeedId + "] cannot retrieve field [" + field + "] because it has no mappings", new Object[0]);
            }
            for (FieldCapabilities capsPerIndex : fieldCaps.values()) {
                if (capsPerIndex.isAggregatable()) continue;
                return false;
            }
            return true;
        }

        private boolean isText(String field) {
            Map fieldCaps = this.fieldsCapabilities.getField(field);
            if (fieldCaps != null && fieldCaps.size() == 1) {
                return fieldCaps.containsKey(ExtractedFields.TEXT);
            }
            return false;
        }
    }
}

