/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public abstract class TransportJobTaskAction<Request extends JobTaskRequest<Request>, Response extends BaseTasksResponse>
extends TransportTasksAction<OpenJobAction.JobTask, Request, Response, Response> {
    protected final AutodetectProcessManager processManager;

    TransportJobTaskAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> requestSupplier, Supplier<Response> responseSupplier, String nodeExecutor, AutodetectProcessManager processManager) {
        super(settings, actionName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, requestSupplier, responseSupplier, nodeExecutor);
        this.processManager = processManager;
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        String jobId = ((JobTaskRequest)((Object)request)).getJobId();
        ClusterState state = this.clusterService.state();
        JobManager.getJobOrThrowIfUnknown(jobId, state);
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask<?> jobTask = MlMetadata.getJobTask(jobId, tasks);
        if (jobTask == null || !jobTask.isAssigned()) {
            String message = "Cannot perform requested action because job [" + jobId + "] is not open";
            listener.onFailure((Exception)org.elasticsearch.xpack.ml.utils.ExceptionsHelper.conflictStatusException(message, new Object[0]));
        } else {
            request.setNodes(new String[]{jobTask.getExecutorNode()});
            super.doExecute(task, request, listener);
        }
    }

    protected Response newResponse(Request request, List<Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return TransportJobTaskAction.selectFirst(tasks, taskOperationFailures, failedNodeExceptions);
    }

    static <Response extends BaseTasksResponse> Response selectFirst(List<Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (tasks.isEmpty()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            throw new IllegalStateException("No errors or response");
        }
        if (tasks.size() > 1) {
            throw new IllegalStateException("Expected one node level response, but got [" + tasks.size() + "]");
        }
        return (Response)((BaseTasksResponse)tasks.get(0));
    }

    public static class JobTaskRequest<R extends JobTaskRequest<R>>
    extends BaseTasksRequest<R> {
        String jobId;

        JobTaskRequest() {
        }

        JobTaskRequest(String jobId) {
            this.jobId = org.elasticsearch.xpack.ml.utils.ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
        }

        public boolean match(Task task) {
            return OpenJobAction.JobTask.match(task, this.jobId);
        }
    }
}

