/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class IsolateDatafeedAction
extends Action<Request, Response, RequestBuilder> {
    public static final IsolateDatafeedAction INSTANCE = new IsolateDatafeedAction();
    public static final String NAME = "cluster:internal/xpack/ml/datafeed/isolate";

    private IsolateDatafeedAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportTasksAction<StartDatafeedAction.DatafeedTask, Request, Response, Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
            super(settings, IsolateDatafeedAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, Response::new, "ml_utility");
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            ClusterState state = this.clusterService.state();
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            PersistentTasksCustomMetaData.PersistentTask<?> datafeedTask = MlMetadata.getDatafeedTask(request.getDatafeedId(), tasks);
            if (datafeedTask == null || datafeedTask.getExecutorNode() == null) {
                listener.onResponse((Object)new Response());
                return;
            }
            String executorNode = datafeedTask.getExecutorNode();
            DiscoveryNodes nodes = state.nodes();
            if (nodes.resolveNode(executorNode).getVersion().before(Version.V_5_5_0)) {
                listener.onFailure((Exception)new ElasticsearchException("Force delete datafeed is not supported because the datafeed task is running on a node [" + executorNode + "] with a version prior to " + Version.V_5_5_0, new Object[0]));
                return;
            }
            request.setNodes(new String[]{datafeedTask.getExecutorNode()});
            super.doExecute(task, (BaseTasksRequest)request, listener);
        }

        protected Response newResponse(Request request, List<Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            return new Response();
        }

        protected void taskOperation(Request request, StartDatafeedAction.DatafeedTask datafeedTask, ActionListener<Response> listener) {
            datafeedTask.isolate();
            listener.onResponse((Object)new Response());
        }

        protected Response readTaskResponse(StreamInput in) throws IOException {
            return new Response(in);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, IsolateDatafeedAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable {
        private boolean isolated;

        public Response(boolean isolated) {
            super(null, null);
            this.isolated = isolated;
        }

        public Response(StreamInput in) throws IOException {
            super(null, null);
            this.readFrom(in);
        }

        Response() {
            super(null, null);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.isolated = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.isolated);
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContentObject {
        public static ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:internal/xpack/ml/datafeed/isolate", Request::new);
        private String datafeedId;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String datafeedId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (datafeedId != null) {
                request.datafeedId = datafeedId;
            }
            return request;
        }

        public Request(String datafeedId) {
            this.datafeedId = org.elasticsearch.xpack.ml.utils.ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        Request() {
        }

        private String getDatafeedId() {
            return this.datafeedId;
        }

        public boolean match(Task task) {
            String expectedDescription = MlMetadata.datafeedTaskId(this.datafeedId);
            return task instanceof StartDatafeedAction.DatafeedTask && expectedDescription.equals(task.getDescription());
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.datafeedId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId);
        }

        static {
            PARSER.declareString((request, datafeedId) -> {
                request.datafeedId = datafeedId;
            }, DatafeedConfig.ID);
        }
    }
}

