/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.util.PageParams;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.RecordsQueryBuilder;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.Influencer;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class GetRecordsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetRecordsAction INSTANCE = new GetRecordsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/records/get";

    private GetRecordsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final JobProvider jobProvider;
        private final JobManager jobManager;
        private final Client client;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, JobManager jobManager, Client client) {
            super(settings, GetRecordsAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.jobProvider = jobProvider;
            this.jobManager = jobManager;
            this.client = client;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            this.jobManager.getJobOrThrowIfUnknown(request.getJobId());
            RecordsQueryBuilder query = new RecordsQueryBuilder().includeInterim(!request.excludeInterim).epochStart(request.start).epochEnd(request.end).from(request.pageParams.getFrom()).size(request.pageParams.getSize()).recordScore(request.recordScoreFilter).sortField(request.sort).sortDescending(request.descending);
            this.jobProvider.records(request.jobId, query, page -> listener.onResponse((Object)new Response((QueryPage<AnomalyRecord>)page)), arg_0 -> listener.onFailure(arg_0), this.client);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<AnomalyRecord> records;

        Response() {
        }

        Response(QueryPage<AnomalyRecord> records) {
            this.records = records;
        }

        public QueryPage<AnomalyRecord> getRecords() {
            return this.records;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.records = new QueryPage(in, AnomalyRecord::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.records.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.records.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.records);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.records, other.records);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
        public static final ParseField RECORD_SCORE_FILTER = new ParseField("record_score", new String[0]);
        public static final ParseField SORT = new ParseField("sort", new String[0]);
        public static final ParseField DESCENDING = new ParseField("desc", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/records/get", Request::new);
        private String jobId;
        private String start;
        private String end;
        private boolean excludeInterim = false;
        private PageParams pageParams = new PageParams();
        private double recordScoreFilter = 0.0;
        private String sort = Influencer.INFLUENCER_SCORE.getPreferredName();
        private boolean descending = true;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        Request() {
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public boolean isDescending() {
            return this.descending;
        }

        public void setDescending(boolean descending) {
            this.descending = descending;
        }

        public boolean isExcludeInterim() {
            return this.excludeInterim;
        }

        public void setExcludeInterim(boolean excludeInterim) {
            this.excludeInterim = excludeInterim;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = pageParams;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public double getRecordScoreFilter() {
            return this.recordScoreFilter;
        }

        public void setRecordScore(double recordScoreFilter) {
            this.recordScoreFilter = recordScoreFilter;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = ExceptionsHelper.requireNonNull(sort, SORT.getPreferredName());
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.excludeInterim = in.readBoolean();
            this.pageParams = new PageParams(in);
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.sort = in.readOptionalString();
            this.descending = in.readBoolean();
            this.recordScoreFilter = in.readDouble();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeBoolean(this.excludeInterim);
            this.pageParams.writeTo(out);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalString(this.sort);
            out.writeBoolean(this.descending);
            out.writeDouble(this.recordScoreFilter);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(START.getPreferredName(), this.start);
            builder.field(END.getPreferredName(), this.end);
            builder.field(SORT.getPreferredName(), this.sort);
            builder.field(DESCENDING.getPreferredName(), this.descending);
            builder.field(RECORD_SCORE_FILTER.getPreferredName(), this.recordScoreFilter);
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
            builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.start, this.end, this.sort, this.descending, this.recordScoreFilter, this.excludeInterim, this.pageParams);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.sort, other.sort) && Objects.equals(this.descending, other.descending) && Objects.equals(this.recordScoreFilter, other.recordScoreFilter) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.pageParams, other.pageParams);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareStringOrNull(Request::setStart, START);
            PARSER.declareStringOrNull(Request::setEnd, END);
            PARSER.declareString(Request::setSort, SORT);
            PARSER.declareBoolean(Request::setDescending, DESCENDING);
            PARSER.declareBoolean(Request::setExcludeInterim, EXCLUDE_INTERIM);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
            PARSER.declareDouble(Request::setRecordScore, RECORD_SCORE_FILTER);
        }
    }
}

