/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsAggregator;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsCollector;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsProcessor;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsProvider;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.OverallBucket;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.Intervals;

public class GetOverallBucketsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetOverallBucketsAction INSTANCE = new GetOverallBucketsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/overall_buckets/get";

    private GetOverallBucketsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private static final String EARLIEST_TIME = "earliest_time";
        private static final String LATEST_TIME = "latest_time";
        private final Client client;
        private final ClusterService clusterService;
        private final JobManager jobManager;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, JobManager jobManager, Client client) {
            super(settings, GetOverallBucketsAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.clusterService = clusterService;
            this.client = client;
            this.jobManager = jobManager;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            QueryPage<Job> jobsPage = this.jobManager.expandJobs(request.getJobId(), request.allowNoJobs(), this.clusterService.state());
            if (jobsPage.count() == 0L) {
                listener.onResponse((Object)new Response());
                return;
            }
            this.threadPool.executor("ml_utility").execute(() -> {
                try {
                    this.getOverallBuckets(request, jobsPage.results(), listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            });
        }

        private void getOverallBuckets(Request request, List<Job> jobs, ActionListener<Response> listener) {
            JobsContext jobsContext = JobsContext.build(jobs, request);
            ActionListener overallBucketsListener = ActionListener.wrap(overallBuckets -> listener.onResponse((Object)new Response(new QueryPage<OverallBucket>((List<OverallBucket>)overallBuckets, overallBuckets.size(), OverallBucket.RESULTS_FIELD))), arg_0 -> listener.onFailure(arg_0));
            ActionListener chunkedBucketSearcherListener = ActionListener.wrap(searcher -> {
                if (searcher == null) {
                    listener.onResponse((Object)new Response());
                    return;
                }
                searcher.searchAndComputeOverallBuckets((ActionListener<List<OverallBucket>>)overallBucketsListener);
            }, arg_0 -> listener.onFailure(arg_0));
            OverallBucketsProvider overallBucketsProvider = new OverallBucketsProvider(jobsContext.maxBucketSpan, request.getTopN(), request.getOverallScore());
            OverallBucketsProcessor overallBucketsProcessor = TransportAction.requiresAggregation(request, jobsContext.maxBucketSpan) ? new OverallBucketsAggregator(request.getBucketSpan()) : new OverallBucketsCollector();
            this.initChunkedBucketSearcher(request, jobsContext, overallBucketsProvider, overallBucketsProcessor, (ActionListener<ChunkedBucketSearcher>)chunkedBucketSearcherListener);
        }

        private static boolean requiresAggregation(Request request, TimeValue maxBucketSpan) {
            return request.getBucketSpan() != null && !request.getBucketSpan().equals((Object)maxBucketSpan);
        }

        private static void checkValidBucketSpan(TimeValue bucketSpan, TimeValue maxBucketSpan) {
            if (bucketSpan != null && bucketSpan.compareTo(maxBucketSpan) < 0) {
                throw ExceptionsHelper.badRequestException("Param [{}] must be greater or equal to the max bucket_span [{}]", Request.BUCKET_SPAN, maxBucketSpan.getStringRep());
            }
        }

        private void initChunkedBucketSearcher(Request request, JobsContext jobsContext, OverallBucketsProvider overallBucketsProvider, OverallBucketsProcessor overallBucketsProcessor, ActionListener<ChunkedBucketSearcher> listener) {
            long maxBucketSpanMillis = jobsContext.maxBucketSpan.millis();
            SearchRequest searchRequest = TransportAction.buildSearchRequest(request.getStart(), request.getEnd(), request.isExcludeInterim(), maxBucketSpanMillis, jobsContext.indices);
            searchRequest.source().aggregation((AggregationBuilder)AggregationBuilders.min((String)EARLIEST_TIME).field(Result.TIMESTAMP.getPreferredName()));
            searchRequest.source().aggregation((AggregationBuilder)AggregationBuilders.max((String)LATEST_TIME).field(Result.TIMESTAMP.getPreferredName()));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "ml", searchRequest, ActionListener.wrap(searchResponse -> {
                long totalHits = searchResponse.getHits().getTotalHits();
                if (totalHits > 0L) {
                    Aggregations aggregations = searchResponse.getAggregations();
                    Min min = (Min)aggregations.get(EARLIEST_TIME);
                    long earliestTime = Intervals.alignToFloor((long)min.getValue(), maxBucketSpanMillis);
                    Max max = (Max)aggregations.get(LATEST_TIME);
                    long latestTime = Intervals.alignToCeil((long)max.getValue() + 1L, maxBucketSpanMillis);
                    listener.onResponse((Object)new ChunkedBucketSearcher(jobsContext, earliestTime, latestTime, request.isExcludeInterim(), overallBucketsProvider, overallBucketsProcessor));
                } else {
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
        }

        private static SearchRequest buildSearchRequest(Long start, Long end, boolean excludeInterim, long bucketSpanMillis, String[] indices) {
            String startTime = start == null ? null : String.valueOf(Intervals.alignToCeil(start, bucketSpanMillis));
            String endTime = end == null ? null : String.valueOf(Intervals.alignToFloor(end, bucketSpanMillis));
            SearchSourceBuilder searchSourceBuilder = new BucketsQueryBuilder().size(0).includeInterim(!excludeInterim).start(startTime).end(endTime).build();
            SearchRequest searchRequest = new SearchRequest(indices);
            searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
            searchRequest.source(searchSourceBuilder);
            return searchRequest;
        }

        private static AggregationBuilder buildAggregations(long maxBucketSpanMillis, int jobCount) {
            ValuesSourceAggregationBuilder overallScoreAgg = AggregationBuilders.max((String)OverallBucket.OVERALL_SCORE.getPreferredName()).field(Bucket.ANOMALY_SCORE.getPreferredName());
            AbstractAggregationBuilder jobsAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)Job.ID.getPreferredName()).field(Job.ID.getPreferredName())).size(jobCount).subAggregation((AggregationBuilder)overallScoreAgg);
            ValuesSourceAggregationBuilder interimAgg = AggregationBuilders.max((String)Result.IS_INTERIM.getPreferredName()).field(Result.IS_INTERIM.getPreferredName());
            return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)Result.TIMESTAMP.getPreferredName()).field(Result.TIMESTAMP.getPreferredName())).interval(maxBucketSpanMillis).subAggregation((AggregationBuilder)jobsAgg)).subAggregation((AggregationBuilder)interimAgg);
        }

        private class ChunkedBucketSearcher {
            private static final int BUCKETS_PER_CHUNK = 1000;
            private static final int MAX_RESULT_COUNT = 10000;
            private final String[] indices;
            private final long maxBucketSpanMillis;
            private final boolean excludeInterim;
            private final long chunkMillis;
            private final long endTime;
            private volatile long curTime;
            private final AggregationBuilder aggs;
            private final OverallBucketsProvider overallBucketsProvider;
            private final OverallBucketsProcessor overallBucketsProcessor;

            ChunkedBucketSearcher(JobsContext jobsContext, long startTime, long endTime, boolean excludeInterim, OverallBucketsProvider overallBucketsProvider, OverallBucketsProcessor overallBucketsProcessor) {
                this.indices = jobsContext.indices;
                this.maxBucketSpanMillis = jobsContext.maxBucketSpan.millis();
                this.chunkMillis = 1000L * this.maxBucketSpanMillis;
                this.endTime = endTime;
                this.curTime = startTime;
                this.excludeInterim = excludeInterim;
                this.aggs = TransportAction.buildAggregations(this.maxBucketSpanMillis, jobsContext.jobCount);
                this.overallBucketsProvider = overallBucketsProvider;
                this.overallBucketsProcessor = overallBucketsProcessor;
            }

            void searchAndComputeOverallBuckets(ActionListener<List<OverallBucket>> listener) {
                if (this.curTime >= this.endTime) {
                    listener.onResponse(this.overallBucketsProcessor.finish());
                    return;
                }
                ClientHelper.executeAsyncWithOrigin(TransportAction.this.client.threadPool().getThreadContext(), "ml", this.nextSearch(), ActionListener.wrap(searchResponse -> {
                    Histogram histogram = (Histogram)searchResponse.getAggregations().get(Result.TIMESTAMP.getPreferredName());
                    this.overallBucketsProcessor.process(this.overallBucketsProvider.computeOverallBuckets(histogram));
                    if (this.overallBucketsProcessor.size() > 10000) {
                        listener.onFailure((Exception)ExceptionsHelper.badRequestException("Unable to return more than [{}] results; please use parameters [{}] and [{}] to limit the time range", 10000, Request.START, Request.END));
                        return;
                    }
                    this.searchAndComputeOverallBuckets(listener);
                }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)TransportAction.this.client).search(arg_0, arg_1));
            }

            SearchRequest nextSearch() {
                long curEnd = Math.min(this.curTime + this.chunkMillis, this.endTime);
                TransportAction.this.logger.debug("Search for buckets in: [{}, {})", (Object)this.curTime, (Object)curEnd);
                SearchRequest searchRequest = TransportAction.buildSearchRequest(this.curTime, curEnd, this.excludeInterim, this.maxBucketSpanMillis, this.indices);
                searchRequest.source().aggregation(this.aggs);
                this.curTime += this.chunkMillis;
                return searchRequest;
            }
        }

        private static class JobsContext {
            private final int jobCount;
            private final String[] indices;
            private final TimeValue maxBucketSpan;

            private JobsContext(int jobCount, String[] indices, TimeValue maxBucketSpan) {
                this.jobCount = jobCount;
                this.indices = indices;
                this.maxBucketSpan = maxBucketSpan;
            }

            private static JobsContext build(List<Job> jobs, Request request) {
                HashSet<String> indices = new HashSet<String>();
                TimeValue maxBucketSpan = TimeValue.ZERO;
                for (Job job : jobs) {
                    indices.add(AnomalyDetectorsIndex.jobResultsAliasedName(job.getId()));
                    TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
                    if (maxBucketSpan.compareTo(bucketSpan) >= 0) continue;
                    maxBucketSpan = bucketSpan;
                }
                TransportAction.checkValidBucketSpan(request.getBucketSpan(), maxBucketSpan);
                if (request.getBucketSpan() != null && (request.getTopN() == 1 || jobs.size() <= 1)) {
                    maxBucketSpan = request.getBucketSpan();
                }
                return new JobsContext(jobs.size(), indices.toArray(new String[indices.size()]), maxBucketSpan);
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<OverallBucket> overallBuckets;

        Response() {
            this.overallBuckets = new QueryPage(Collections.emptyList(), 0L, OverallBucket.RESULTS_FIELD);
        }

        Response(QueryPage<OverallBucket> overallBuckets) {
            this.overallBuckets = overallBuckets;
        }

        public QueryPage<OverallBucket> getOverallBuckets() {
            return this.overallBuckets;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.overallBuckets = new QueryPage(in, OverallBucket::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.overallBuckets.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.overallBuckets.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.overallBuckets);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.overallBuckets, other.overallBuckets);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField TOP_N = new ParseField("top_n", new String[0]);
        public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
        public static final ParseField OVERALL_SCORE = new ParseField("overall_score", new String[0]);
        public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField ALLOW_NO_JOBS = new ParseField("allow_no_jobs", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/overall_buckets/get", Request::new);
        private String jobId;
        private int topN = 1;
        private TimeValue bucketSpan;
        private double overallScore = 0.0;
        private boolean excludeInterim = false;
        private Long start;
        private Long end;
        private boolean allowNoJobs = true;

        static long parseDateOrThrow(String date, ParseField paramName, LongSupplier now) {
            DateMathParser dateMathParser = new DateMathParser(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER);
            try {
                return dateMathParser.parse(date, now);
            }
            catch (Exception e) {
                String msg = Messages.getMessage("Query param [{0}] with value [{1}] cannot be parsed as a date or converted to a number (epoch).", paramName.getPreferredName(), date);
                throw new ElasticsearchParseException(msg, (Throwable)e, new Object[0]);
            }
        }

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        Request() {
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public int getTopN() {
            return this.topN;
        }

        public void setTopN(int topN) {
            if (topN <= 0) {
                throw new IllegalArgumentException("[topN] parameter must be positive, found [" + topN + "]");
            }
            this.topN = topN;
        }

        public TimeValue getBucketSpan() {
            return this.bucketSpan;
        }

        public void setBucketSpan(TimeValue bucketSpan) {
            this.bucketSpan = bucketSpan;
        }

        public void setBucketSpan(String bucketSpan) {
            this.bucketSpan = TimeValue.parseTimeValue((String)bucketSpan, (String)BUCKET_SPAN.getPreferredName());
        }

        public double getOverallScore() {
            return this.overallScore;
        }

        public void setOverallScore(double overallScore) {
            this.overallScore = overallScore;
        }

        public boolean isExcludeInterim() {
            return this.excludeInterim;
        }

        public void setExcludeInterim(boolean excludeInterim) {
            this.excludeInterim = excludeInterim;
        }

        public Long getStart() {
            return this.start;
        }

        public void setStart(Long start) {
            this.start = start;
        }

        public void setStart(String start) {
            this.setStart(Request.parseDateOrThrow(start, START, System::currentTimeMillis));
        }

        public Long getEnd() {
            return this.end;
        }

        public void setEnd(Long end) {
            this.end = end;
        }

        public void setEnd(String end) {
            this.setEnd(Request.parseDateOrThrow(end, END, System::currentTimeMillis));
        }

        public boolean allowNoJobs() {
            return this.allowNoJobs;
        }

        public void setAllowNoJobs(boolean allowNoJobs) {
            this.allowNoJobs = allowNoJobs;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.topN = in.readVInt();
            this.bucketSpan = (TimeValue)in.readOptionalWriteable(TimeValue::new);
            this.overallScore = in.readDouble();
            this.excludeInterim = in.readBoolean();
            this.start = in.readOptionalLong();
            this.end = in.readOptionalLong();
            this.allowNoJobs = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeVInt(this.topN);
            out.writeOptionalWriteable((Writeable)this.bucketSpan);
            out.writeDouble(this.overallScore);
            out.writeBoolean(this.excludeInterim);
            out.writeOptionalLong(this.start);
            out.writeOptionalLong(this.end);
            out.writeBoolean(this.allowNoJobs);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TOP_N.getPreferredName(), this.topN);
            if (this.bucketSpan != null) {
                builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan.getStringRep());
            }
            builder.field(OVERALL_SCORE.getPreferredName(), this.overallScore);
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
            if (this.start != null) {
                builder.field(START.getPreferredName(), String.valueOf(this.start));
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), String.valueOf(this.end));
            }
            builder.field(ALLOW_NO_JOBS.getPreferredName(), this.allowNoJobs);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.topN, this.bucketSpan, this.overallScore, this.excludeInterim, this.start, this.end, this.allowNoJobs);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            Request that = (Request)((Object)other);
            return Objects.equals(this.jobId, that.jobId) && this.topN == that.topN && Objects.equals(this.bucketSpan, that.bucketSpan) && this.excludeInterim == that.excludeInterim && this.overallScore == that.overallScore && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && this.allowNoJobs == that.allowNoJobs;
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareInt(Request::setTopN, TOP_N);
            PARSER.declareString(Request::setBucketSpan, BUCKET_SPAN);
            PARSER.declareDouble(Request::setOverallScore, OVERALL_SCORE);
            PARSER.declareBoolean(Request::setExcludeInterim, EXCLUDE_INTERIM);
            PARSER.declareString((request, startTime) -> request.setStart(Request.parseDateOrThrow(startTime, START, System::currentTimeMillis)), START);
            PARSER.declareString((request, endTime) -> request.setEnd(Request.parseDateOrThrow(endTime, END, System::currentTimeMillis)), END);
            PARSER.declareBoolean(Request::setAllowNoJobs, ALLOW_NO_JOBS);
        }
    }
}

