/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ml.MlDailyMaintenanceService;
import org.elasticsearch.xpack.ml.MlMetadata;

class MlInitializationService
extends AbstractComponent
implements ClusterStateListener {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final AtomicBoolean installMlMetadataCheck = new AtomicBoolean(false);
    private volatile MlDailyMaintenanceService mlDailyMaintenanceService;

    MlInitializationService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Client client) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                super.beforeStop();
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (event.localNodeMaster()) {
            MetaData metaData = event.state().metaData();
            this.installMlMetadata(metaData);
            this.installDailyMaintenanceService();
        } else {
            this.uninstallDailyMaintenanceService();
        }
    }

    private void installMlMetadata(MetaData metaData) {
        if (metaData.custom("ml") == null) {
            if (this.installMlMetadataCheck.compareAndSet(false, true)) {
                this.threadPool.executor("generic").execute(() -> this.clusterService.submitStateUpdateTask("install-ml-metadata", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                    public ClusterState execute(ClusterState currentState) throws Exception {
                        if (currentState.metaData().custom("ml") != null) {
                            return currentState;
                        }
                        ClusterState.Builder builder = new ClusterState.Builder(currentState);
                        MetaData.Builder metadataBuilder = MetaData.builder((MetaData)currentState.metaData());
                        metadataBuilder.putCustom("ml", (MetaData.Custom)MlMetadata.EMPTY_METADATA);
                        builder.metaData(metadataBuilder.build());
                        return builder.build();
                    }

                    public void onFailure(String source, Exception e) {
                        MlInitializationService.this.installMlMetadataCheck.set(false);
                        MlInitializationService.this.logger.error("unable to install ml metadata", (Throwable)e);
                    }
                }));
            }
        } else {
            this.installMlMetadataCheck.set(false);
        }
    }

    private void installDailyMaintenanceService() {
        if (this.mlDailyMaintenanceService == null) {
            this.mlDailyMaintenanceService = new MlDailyMaintenanceService(this.clusterService.getClusterName(), this.threadPool, this.client);
            this.mlDailyMaintenanceService.start();
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    MlInitializationService.this.uninstallDailyMaintenanceService();
                }
            });
        }
    }

    private void uninstallDailyMaintenanceService() {
        if (this.mlDailyMaintenanceService != null) {
            this.mlDailyMaintenanceService.stop();
            this.mlDailyMaintenanceService = null;
        }
    }

    MlDailyMaintenanceService getDailyMaintenanceService() {
        return this.mlDailyMaintenanceService;
    }

    void setDailyMaintenanceService(MlDailyMaintenanceService service) {
        this.mlDailyMaintenanceService = service;
    }
}

