/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.XPackSettings;

public class LogstashFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public LogstashFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.LOGSTASH_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    @Override
    public String name() {
        return "logstash";
    }

    @Override
    public String description() {
        return "Logstash management component for X-Pack";
    }

    @Override
    public boolean available() {
        return this.licenseState != null && this.licenseState.isLogstashAllowed();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new Usage(this.available(), this.enabled()));
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        public Usage(StreamInput in) throws IOException {
            super(in);
        }

        public Usage(boolean available, boolean enabled) {
            super("logstash", available, enabled);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }

        @Override
        protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.innerXContent(builder, params);
        }
    }
}

