/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph.action;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class Vertex
implements ToXContentFragment {
    final String field;
    final String term;
    double weight;
    final int depth;
    final long bg;
    long fg;

    Vertex(String field, String term, double weight, int depth, long bg, long fg) {
        this.field = field;
        this.term = term;
        this.weight = weight;
        this.depth = depth;
        this.bg = bg;
        this.fg = fg;
    }

    static Vertex readFrom(StreamInput in) throws IOException {
        return new Vertex(in.readString(), in.readString(), in.readDouble(), in.readVInt(), in.readVLong(), in.readVLong());
    }

    void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.term);
        out.writeDouble(this.weight);
        out.writeVInt(this.depth);
        out.writeVLong(this.bg);
        out.writeVLong(this.fg);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean returnDetailedInfo = params.paramAsBoolean("returnDetailedInfo", false);
        builder.field("field", this.field);
        builder.field("term", this.term);
        builder.field("weight", this.weight);
        builder.field("depth", this.depth);
        if (returnDetailedInfo) {
            builder.field("fg", this.fg);
            builder.field("bg", this.bg);
        }
        return builder;
    }

    public VertexId getId() {
        return Vertex.createId(this.field, this.term);
    }

    public static VertexId createId(String field, String term) {
        return new VertexId(field, term);
    }

    public String toString() {
        return this.getId().toString();
    }

    public String getField() {
        return this.field;
    }

    public String getTerm() {
        return this.term;
    }

    public double getWeight() {
        return this.weight;
    }

    public long getBg() {
        return this.bg;
    }

    public long getFg() {
        return this.fg;
    }

    public int getHopDepth() {
        return this.depth;
    }

    public static class VertexId {
        private final String field;
        private final String term;

        public VertexId(String field, String term) {
            this.field = field;
            this.term = term;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VertexId vertexId = (VertexId)o;
            if (this.field != null ? !this.field.equals(vertexId.field) : vertexId.field != null) {
                return false;
            }
            return !(this.term != null ? !this.term.equals(vertexId.term) : vertexId.term != null);
        }

        public int hashCode() {
            int result = this.field != null ? this.field.hashCode() : 0;
            result = 31 * result + (this.term != null ? this.term.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.field + ":" + this.term;
        }
    }
}

