/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.secret;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.xpack.security.crypto.CryptoService;

public class Secret {
    protected final char[] text;

    public Secret(char[] text) {
        this.text = text;
    }

    public char[] text(CryptoService service) {
        if (service == null) {
            return this.text;
        }
        return service.decrypt(this.text);
    }

    public String value() throws IOException {
        return new String(this.text);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Secret secret = (Secret)o;
        return Arrays.equals(this.text, secret.text);
    }

    public int hashCode() {
        return Arrays.hashCode(this.text);
    }
}

