/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http.auth.basic;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.http.auth.HttpAuth;
import org.elasticsearch.xpack.common.secret.Secret;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherXContentParser;

public class BasicAuth
implements HttpAuth {
    public static final String TYPE = "basic";
    final String username;
    final Secret password;

    public BasicAuth(String username, char[] password) {
        this(username, new Secret(password));
    }

    public BasicAuth(String username, Secret password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicAuth basicAuth = (BasicAuth)o;
        if (!this.username.equals(basicAuth.username)) {
            return false;
        }
        return this.password.equals(basicAuth.password);
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.USERNAME.getPreferredName(), this.username);
        if (!WatcherParams.hideSecrets(params)) {
            builder.field(Field.PASSWORD.getPreferredName(), this.password.value());
        }
        return builder.endObject();
    }

    public static BasicAuth parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String username = null;
        Secret password = null;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (Field.USERNAME.getPreferredName().equals(fieldName)) {
                    username = parser.text();
                    continue;
                }
                if (Field.PASSWORD.getPreferredName().equals(fieldName)) {
                    password = WatcherXContentParser.secret(parser);
                    continue;
                }
                throw new ElasticsearchParseException("unsupported field [" + fieldName + "]", new Object[0]);
            }
            throw new ElasticsearchParseException("unsupported token [" + token + "]", new Object[0]);
        }
        if (username == null) {
            throw new ElasticsearchParseException("username is a required option", new Object[0]);
        }
        if (password == null) {
            throw new ElasticsearchParseException("password is a required option", new Object[0]);
        }
        return new BasicAuth(username, password);
    }

    static interface Field {
        public static final ParseField USERNAME = new ParseField("username", new String[0]);
        public static final ParseField PASSWORD = new ParseField("password", new String[0]);
    }
}

