/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.util.Locale;

public enum Scheme {
    HTTP("http", 80),
    HTTPS("https", 443);

    private final String scheme;
    private final int defaultPort;

    private Scheme(String scheme, int defaultPort) {
        this.scheme = scheme;
        this.defaultPort = defaultPort;
    }

    public String scheme() {
        return this.scheme;
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    public static Scheme parse(String value) {
        switch (value = value.toLowerCase(Locale.ROOT)) {
            case "http": {
                return HTTP;
            }
            case "https": {
                return HTTPS;
            }
        }
        throw new IllegalArgumentException("unsupported http scheme [" + value + "]");
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

