/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.util.Locale;

public enum HttpMethod {
    HEAD("HEAD"),
    GET("GET"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE");

    private final String method;

    private HttpMethod(String method) {
        this.method = method;
    }

    public String method() {
        return this.method;
    }

    public static HttpMethod parse(String value) {
        switch (value = value.toUpperCase(Locale.ROOT)) {
            case "HEAD": {
                return HEAD;
            }
            case "GET": {
                return GET;
            }
            case "POST": {
                return POST;
            }
            case "PUT": {
                return PUT;
            }
            case "DELETE": {
                return DELETE;
            }
        }
        throw new IllegalArgumentException("unsupported http method [" + value + "]");
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

