/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class ClientHelper {
    public static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    public static final String SECURITY_ORIGIN = "security";
    public static final String WATCHER_ORIGIN = "watcher";
    public static final String ML_ORIGIN = "ml";
    public static final String MONITORING_ORIGIN = "monitoring";
    public static final String DEPRECATION_ORIGIN = "deprecation";
    public static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";

    private ClientHelper() {
    }

    public static ThreadContext.StoredContext stashWithOrigin(ThreadContext threadContext, String origin) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        threadContext.putTransient(ACTION_ORIGIN_TRANSIENT_NAME, (Object)origin);
        return storedContext;
    }

    public static Client clientWithOrigin(Client client, String origin) {
        return new ClientWithOrigin(client, origin);
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeAsyncWithOrigin(ThreadContext threadContext, String origin, Request request, ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        Supplier supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(threadContext, origin);){
            consumer.accept(request, (ActionListener<Response>)new ContextPreservingActionListener(supplier, listener));
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void executeAsyncWithOrigin(Client client, String origin, Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        Supplier supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(threadContext, origin);){
            client.execute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
        }
    }

    private static final class ClientWithOrigin
    extends FilterClient {
        private final String origin;

        private ClientWithOrigin(Client in, String origin) {
            super(in);
            this.origin = origin;
        }

        protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
            Supplier supplier = this.in().threadPool().getThreadContext().newRestorableContext(false);
            try (ThreadContext.StoredContext ignore = this.in().threadPool().getThreadContext().stashContext();){
                this.in().threadPool().getThreadContext().putTransient(ClientHelper.ACTION_ORIGIN_TRANSIENT_NAME, (Object)this.origin);
                super.doExecute(action, request, (ActionListener)new ContextPreservingActionListener(supplier, listener));
            }
        }
    }
}

