/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.rest.XPackRestHandler;

public class RestPostStartTrialLicense
extends XPackRestHandler {
    RestPostStartTrialLicense(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/license/start_trial", (RestHandler)this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        return channel -> client.licensing().preparePutUpgradeToTrial().execute((ActionListener)new RestBuilderListener<PostStartTrialResponse>(channel){

            public RestResponse buildResponse(PostStartTrialResponse response, XContentBuilder builder) throws Exception {
                PostStartTrialResponse.STATUS status = response.getStatus();
                if (status == PostStartTrialResponse.STATUS.TRIAL_ALREADY_ACTIVATED) {
                    builder.startObject().field("trial_was_started", false).field("error_message", "Operation failed: Trial was already activated.").endObject();
                    return new BytesRestResponse(RestStatus.FORBIDDEN, builder);
                }
                if (status == PostStartTrialResponse.STATUS.UPGRADED_TO_TRIAL) {
                    builder.startObject().field("trial_was_started", true).endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
                throw new IllegalArgumentException("Unexpected status for PostStartTrialResponse: [" + (Object)((Object)status) + "]");
            }
        });
    }

    public String getName() {
        return "xpack_upgrade_to_trial_action";
    }
}

