/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.watch;

import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.support.clock.HaltedClock;
import org.elasticsearch.xpack.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.watcher.condition.AlwaysCondition;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.none.ExecutableNoneInput;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherXContentParser;
import org.elasticsearch.xpack.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.watcher.trigger.Trigger;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.watch.WatchStatus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Watch
implements ToXContentObject {
    public static final String ALL_ACTIONS_ID = "_all";
    public static final String INCLUDE_STATUS_KEY = "include_status";
    public static final String INDEX = ".watches";
    public static final String DOC_TYPE = "doc";
    private final String id;
    private final Trigger trigger;
    private final ExecutableInput input;
    private final Condition condition;
    @Nullable
    private final ExecutableTransform transform;
    private final List<ActionWrapper> actions;
    @Nullable
    private final TimeValue throttlePeriod;
    @Nullable
    private final Map<String, Object> metadata;
    private final WatchStatus status;
    private transient long version = -3L;
    private static final Pattern NO_WS_PATTERN = Pattern.compile("\\S+");

    public Watch(String id, Trigger trigger, ExecutableInput input, Condition condition, @Nullable ExecutableTransform transform, @Nullable TimeValue throttlePeriod, List<ActionWrapper> actions, @Nullable Map<String, Object> metadata, WatchStatus status) {
        this.id = id;
        this.trigger = trigger;
        this.input = input;
        this.condition = condition;
        this.transform = transform;
        this.actions = actions;
        this.throttlePeriod = throttlePeriod;
        this.metadata = metadata;
        this.status = status;
    }

    public String id() {
        return this.id;
    }

    public Trigger trigger() {
        return this.trigger;
    }

    public ExecutableInput input() {
        return this.input;
    }

    public Condition condition() {
        return this.condition;
    }

    public ExecutableTransform transform() {
        return this.transform;
    }

    public TimeValue throttlePeriod() {
        return this.throttlePeriod;
    }

    public List<ActionWrapper> actions() {
        return this.actions;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public WatchStatus status() {
        return this.status;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    public boolean setState(boolean active, DateTime now) {
        return this.status.setActive(active, now);
    }

    public boolean ack(DateTime now, String ... actions) {
        return this.status.onAck(now, actions);
    }

    public boolean acked(String actionId) {
        ActionStatus actionStatus = this.status.actionStatus(actionId);
        return actionStatus.ackStatus().state() == ActionStatus.AckStatus.State.ACKED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Watch watch = (Watch)o;
        return watch.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.TRIGGER.getPreferredName()).startObject().field(this.trigger.type(), (ToXContent)this.trigger, params).endObject();
        builder.field(Field.INPUT.getPreferredName()).startObject().field(this.input.type(), (ToXContent)this.input, params).endObject();
        builder.field(Field.CONDITION.getPreferredName()).startObject().field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        if (this.transform != null) {
            builder.field(Field.TRANSFORM.getPreferredName()).startObject().field(this.transform.type(), (ToXContent)this.transform, params).endObject();
        }
        if (this.throttlePeriod != null) {
            builder.timeValueField(Field.THROTTLE_PERIOD.getPreferredName(), Field.THROTTLE_PERIOD_HUMAN.getPreferredName(), this.throttlePeriod);
        }
        builder.startObject(Field.ACTIONS.getPreferredName());
        for (ActionWrapper action : this.actions) {
            builder.field(action.id(), (ToXContent)action, params);
        }
        builder.endObject();
        if (this.metadata != null) {
            builder.field(Field.METADATA.getPreferredName(), this.metadata);
        }
        if (params.paramAsBoolean(INCLUDE_STATUS_KEY, false)) {
            builder.field(Field.STATUS.getPreferredName(), (ToXContent)this.status, params);
        }
        builder.endObject();
        return builder;
    }

    public static boolean isValidId(String id) {
        return !Strings.isEmpty((CharSequence)id) && NO_WS_PATTERN.matcher(id).matches();
    }

    public static interface Field {
        public static final ParseField TRIGGER = new ParseField("trigger", new String[0]);
        public static final ParseField INPUT = new ParseField("input", new String[0]);
        public static final ParseField CONDITION = new ParseField("condition", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
        public static final ParseField TRANSFORM = new ParseField("transform", new String[0]);
        public static final ParseField THROTTLE_PERIOD = new ParseField("throttle_period_in_millis", new String[0]);
        public static final ParseField THROTTLE_PERIOD_HUMAN = new ParseField("throttle_period", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField STATUS = new ParseField("status", new String[0]);
    }

    public static class Parser
    extends AbstractComponent {
        private final TriggerService triggerService;
        private final ActionRegistry actionRegistry;
        private final InputRegistry inputRegistry;
        private final CryptoService cryptoService;
        private final ExecutableInput defaultInput;
        private final Condition defaultCondition;
        private final List<ActionWrapper> defaultActions;
        private final Clock clock;

        public Parser(Settings settings, TriggerService triggerService, ActionRegistry actionRegistry, InputRegistry inputRegistry, @Nullable CryptoService cryptoService, Clock clock) {
            super(settings);
            this.triggerService = triggerService;
            this.actionRegistry = actionRegistry;
            this.inputRegistry = inputRegistry;
            this.cryptoService = cryptoService;
            this.defaultInput = new ExecutableNoneInput(this.logger);
            this.defaultCondition = AlwaysCondition.INSTANCE;
            this.defaultActions = Collections.emptyList();
            this.clock = clock;
        }

        public Watch parse(String name, boolean includeStatus, BytesReference source, XContentType xContentType) throws IOException {
            return this.parse(name, includeStatus, false, source, new DateTime(this.clock.millis(), DateTimeZone.UTC), xContentType);
        }

        public Watch parse(String name, boolean includeStatus, BytesReference source, DateTime now, XContentType xContentType) throws IOException {
            return this.parse(name, includeStatus, false, source, now, xContentType);
        }

        public Watch parseWithSecrets(String id, boolean includeStatus, BytesReference source, DateTime now, XContentType xContentType) throws IOException {
            return this.parse(id, includeStatus, true, source, now, xContentType);
        }

        private Watch parse(String id, boolean includeStatus, boolean withSecrets, BytesReference source, DateTime now, XContentType xContentType) throws IOException {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("parsing watch [{}] ", (Object)source.utf8ToString());
            }
            try (WatcherXContentParser parser = null;){
                parser = new WatcherXContentParser(xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, source), new HaltedClock(now), withSecrets ? this.cryptoService : null);
                parser.nextToken();
                Watch watch = this.parse(id, includeStatus, parser);
                return watch;
            }
        }

        public Watch parse(String id, boolean includeStatus, XContentParser parser) throws IOException {
            XContentParser.Token token;
            Trigger trigger = null;
            ExecutableInput input = this.defaultInput;
            Condition condition = this.defaultCondition;
            List<ActionWrapper> actions = this.defaultActions;
            ExecutableTransform transform = null;
            TimeValue throttlePeriod = null;
            Map metatdata = null;
            WatchStatus status = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == null) {
                    throw new ElasticsearchParseException("could not parse watch [{}]. null token", new Object[]{id});
                }
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == null || currentFieldName == null) {
                    throw new ElasticsearchParseException("could not parse watch [{}], unexpected token [{}]", new Object[]{id, token});
                }
                if (Field.TRIGGER.match(currentFieldName)) {
                    trigger = this.triggerService.parseTrigger(id, parser);
                    continue;
                }
                if (Field.INPUT.match(currentFieldName)) {
                    input = this.inputRegistry.parse(id, parser);
                    continue;
                }
                if (Field.CONDITION.match(currentFieldName)) {
                    condition = this.actionRegistry.getConditionRegistry().parseExecutable(id, parser);
                    continue;
                }
                if (Field.TRANSFORM.match(currentFieldName)) {
                    transform = this.actionRegistry.getTransformRegistry().parse(id, parser);
                    continue;
                }
                if (Field.THROTTLE_PERIOD.match(currentFieldName)) {
                    throttlePeriod = TimeValue.timeValueMillis((long)parser.longValue());
                    continue;
                }
                if (Field.THROTTLE_PERIOD_HUMAN.match(currentFieldName)) {
                    try {
                        throttlePeriod = WatcherDateTimeUtils.parseTimeValue(parser, Field.THROTTLE_PERIOD_HUMAN.toString());
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse watch [{}]. failed to parse time value for field [{}]", (Throwable)pe, new Object[]{id, currentFieldName});
                    }
                }
                if (Field.ACTIONS.match(currentFieldName)) {
                    actions = this.actionRegistry.parseActions(id, parser);
                    continue;
                }
                if (Field.METADATA.match(currentFieldName)) {
                    metatdata = parser.map();
                    continue;
                }
                if (Field.STATUS.match(currentFieldName)) {
                    if (includeStatus) {
                        status = WatchStatus.parse(id, parser, this.clock);
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch [{}]. unexpected field [{}]", new Object[]{id, currentFieldName});
            }
            if (trigger == null) {
                throw new ElasticsearchParseException("could not parse watch [{}]. missing required field [{}]", new Object[]{id, Field.TRIGGER.getPreferredName()});
            }
            if (status != null) {
                for (ActionWrapper action : actions) {
                    if (status.actionStatus(action.id()) != null) continue;
                    throw new ElasticsearchParseException("could not parse watch [{}]. watch status in invalid state. action [{}] status is missing", new Object[]{id, action.id()});
                }
            } else {
                HashMap<String, ActionStatus> actionsStatuses = new HashMap<String, ActionStatus>();
                DateTime now = new DateTime(WatcherXContentParser.clock(parser).millis(), DateTimeZone.UTC);
                for (ActionWrapper action : actions) {
                    actionsStatuses.put(action.id(), new ActionStatus(now));
                }
                status = new WatchStatus(now, Collections.unmodifiableMap(actionsStatuses));
            }
            return new Watch(id, trigger, input, condition, transform, throttlePeriod, actions, metatdata, status);
        }
    }
}

