/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.stats;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class WatcherStatsRequest
extends BaseNodesRequest<WatcherStatsRequest> {
    private boolean includeCurrentWatches;
    private boolean includeQueuedWatches;

    public boolean includeCurrentWatches() {
        return this.includeCurrentWatches;
    }

    public void includeCurrentWatches(boolean currentWatches) {
        this.includeCurrentWatches = currentWatches;
    }

    public boolean includeQueuedWatches() {
        return this.includeQueuedWatches;
    }

    public void includeQueuedWatches(boolean includeQueuedWatches) {
        this.includeQueuedWatches = includeQueuedWatches;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.includeCurrentWatches = in.readBoolean();
        this.includeQueuedWatches = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.includeCurrentWatches);
        out.writeBoolean(this.includeQueuedWatches);
    }

    public String toString() {
        return "watcher_stats";
    }

    public static class Node
    extends BaseNodeRequest {
        private boolean includeCurrentWatches;
        private boolean includeQueuedWatches;

        public Node() {
        }

        public Node(WatcherStatsRequest request, String nodeId) {
            super(nodeId);
            this.includeCurrentWatches = request.includeCurrentWatches();
            this.includeQueuedWatches = request.includeQueuedWatches();
        }

        public boolean includeCurrentWatches() {
            return this.includeCurrentWatches;
        }

        public boolean includeQueuedWatches() {
            return this.includeQueuedWatches;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.includeCurrentWatches = in.readBoolean();
            this.includeQueuedWatches = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.includeCurrentWatches);
            out.writeBoolean(this.includeQueuedWatches);
        }
    }
}

