/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.service;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class WatcherServiceRequest
extends MasterNodeRequest<WatcherServiceRequest> {
    private Command command;

    public WatcherServiceRequest start() {
        this.command = Command.START;
        return this;
    }

    public WatcherServiceRequest stop() {
        this.command = Command.STOP;
        return this;
    }

    Command getCommand() {
        return this.command;
    }

    public ActionRequestValidationException validate() {
        if (this.command == null) {
            return ValidateActions.addValidationError((String)"no command specified", null);
        }
        return null;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.command = Command.valueOf(in.readString().toUpperCase(Locale.ROOT));
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.command.name().toLowerCase(Locale.ROOT));
    }

    static enum Command {
        START,
        STOP;

    }
}

