/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.get;

import java.time.Clock;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.watcher.watch.Watch;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TransportGetWatchAction
extends WatcherTransportAction<GetWatchRequest, GetWatchResponse> {
    private final Watch.Parser parser;
    private final Clock clock;
    private final Client client;

    @Inject
    public TransportGetWatchAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState, Watch.Parser parser, Clock clock, Client client, ClusterService clusterService) {
        super(settings, "cluster:monitor/xpack/watcher/watch/get", transportService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, clusterService, GetWatchRequest::new, GetWatchResponse::new);
        this.parser = parser;
        this.clock = clock;
        this.client = client;
    }

    @Override
    protected void masterOperation(GetWatchRequest request, ClusterState state, ActionListener<GetWatchResponse> listener) throws Exception {
        GetRequest getRequest = new GetRequest(".watches", "doc", request.getId()).preference(Preference.LOCAL.type()).realtime(true);
        ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "watcher", getRequest, ActionListener.wrap(getResponse -> {
            if (getResponse.isExists()) {
                try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                    DateTime now = new DateTime(this.clock.millis(), DateTimeZone.UTC);
                    Watch watch = this.parser.parseWithSecrets(request.getId(), true, getResponse.getSourceAsBytesRef(), now, XContentType.JSON);
                    watch.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).put("include_status", false).build());
                    watch.version(getResponse.getVersion());
                    watch.status().version(getResponse.getVersion());
                    listener.onResponse((Object)new GetWatchResponse(watch.id(), watch.status(), builder.bytes(), XContentType.JSON));
                }
            } else {
                listener.onResponse((Object)new GetWatchResponse(request.getId()));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)new GetWatchResponse(request.getId()));
            } else {
                listener.onFailure(e);
            }
        }), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
    }
}

