/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.watcher.watch.Watch;

public class GetWatchRequest
extends MasterNodeReadRequest<GetWatchRequest> {
    private String id;

    public GetWatchRequest() {
    }

    public GetWatchRequest(String id) {
        this.id = id;
    }

    GetWatchRequest setId(String id) {
        this.id = id;
        return this;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError((String)"watch id is missing", validationException);
        } else if (!Watch.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError((String)"watch id contains whitespace", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getId() {
        return this.id;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
    }

    public String toString() {
        return "get [" + this.id + "]";
    }
}

