/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.watcher.watch.Watch;

public class DeleteWatchRequest
extends MasterNodeRequest<DeleteWatchRequest> {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)10L);
    private String id;
    private long version = -3L;

    public DeleteWatchRequest() {
        this(null);
    }

    public DeleteWatchRequest(String id) {
        this.id = id;
        this.masterNodeTimeout(DEFAULT_TIMEOUT);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError((String)"watch id is missing", validationException);
        } else if (!Watch.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError((String)"watch id contains whitespace", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.version = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeLong(this.version);
    }

    public String toString() {
        return "delete [" + this.id + "]";
    }
}

