/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.activate;

import java.io.IOException;
import java.time.Clock;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.watch.WatchStatus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TransportActivateWatchAction
extends WatcherTransportAction<ActivateWatchRequest, ActivateWatchResponse> {
    private final Clock clock;
    private final Watch.Parser parser;
    private final Client client;
    private final TriggerService triggerService;

    @Inject
    public TransportActivateWatchAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Clock clock, XPackLicenseState licenseState, Watch.Parser parser, ClusterService clusterService, Client client, TriggerService triggerService) {
        super(settings, "cluster:admin/xpack/watcher/watch/activate", transportService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, clusterService, ActivateWatchRequest::new, ActivateWatchResponse::new);
        this.clock = clock;
        this.parser = parser;
        this.client = client;
        this.triggerService = triggerService;
    }

    @Override
    protected void masterOperation(ActivateWatchRequest request, ClusterState state, ActionListener<ActivateWatchResponse> listener) throws Exception {
        try {
            DateTime now = new DateTime(this.clock.millis(), DateTimeZone.UTC);
            UpdateRequest updateRequest = new UpdateRequest(".watches", "doc", request.getWatchId());
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            XContentBuilder builder = this.activateWatchBuilder(request.isActivate(), now);
            updateRequest.doc(builder);
            updateRequest.retryOnConflict(2);
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "watcher", updateRequest, ActionListener.wrap(updateResponse -> {
                GetRequest getRequest = new GetRequest(".watches", "doc", request.getWatchId()).preference(Preference.LOCAL.type()).realtime(true);
                ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "watcher", getRequest, ActionListener.wrap(getResponse -> {
                    if (getResponse.isExists()) {
                        Watch watch = this.parser.parseWithSecrets(request.getWatchId(), true, getResponse.getSourceAsBytesRef(), now, XContentType.JSON);
                        watch.version(getResponse.getVersion());
                        watch.status().version(getResponse.getVersion());
                        if (this.localExecute(request)) {
                            if (watch.status().state().isActive()) {
                                this.triggerService.add(watch);
                            } else {
                                this.triggerService.remove(watch.id());
                            }
                        }
                        listener.onResponse((Object)new ActivateWatchResponse(watch.status()));
                    } else {
                        listener.onFailure((Exception)((Object)new ResourceNotFoundException("Watch with id [{}] does not exist", new Object[]{request.getWatchId()})));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
            }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    private XContentBuilder activateWatchBuilder(boolean active, DateTime now) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject().startObject(Watch.Field.STATUS.getPreferredName()).startObject(WatchStatus.Field.STATE.getPreferredName()).field(WatchStatus.Field.ACTIVE.getPreferredName(), active);
            WatcherDateTimeUtils.writeDate(WatchStatus.Field.TIMESTAMP.getPreferredName(), builder, now);
            builder.endObject().endObject().endObject();
            XContentBuilder xContentBuilder = builder;
            return xContentBuilder;
        }
    }
}

