/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

public class WatcherSearchTemplateRequest
implements ToXContentObject {
    private final String[] indices;
    private final String[] types;
    private final SearchType searchType;
    private final IndicesOptions indicesOptions;
    private final Script template;
    private final BytesReference searchSource;
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField TYPES_FIELD = new ParseField("types", new String[0]);
    private static final ParseField BODY_FIELD = new ParseField("body", new String[0]);
    private static final ParseField SEARCH_TYPE_FIELD = new ParseField("search_type", new String[0]);
    private static final ParseField INDICES_OPTIONS_FIELD = new ParseField("indices_options", new String[0]);
    private static final ParseField EXPAND_WILDCARDS_FIELD = new ParseField("expand_wildcards", new String[0]);
    private static final ParseField IGNORE_UNAVAILABLE_FIELD = new ParseField("ignore_unavailable", new String[0]);
    private static final ParseField ALLOW_NO_INDICES_FIELD = new ParseField("allow_no_indices", new String[0]);
    private static final ParseField TEMPLATE_FIELD = new ParseField("template", new String[0]);
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.lenientExpandOpen();

    public WatcherSearchTemplateRequest(String[] indices, String[] types, SearchType searchType, IndicesOptions indicesOptions, BytesReference searchSource) {
        this.indices = indices;
        this.types = types;
        this.searchType = searchType;
        this.indicesOptions = indicesOptions;
        this.template = new Script(ScriptType.INLINE, "mustache", searchSource.utf8ToString(), Collections.emptyMap());
        this.searchSource = BytesArray.EMPTY;
    }

    public WatcherSearchTemplateRequest(String[] indices, String[] types, SearchType searchType, IndicesOptions indicesOptions, Script template) {
        this.indices = indices;
        this.types = types;
        this.searchType = searchType;
        this.indicesOptions = indicesOptions;
        this.template = template;
        this.searchSource = BytesArray.EMPTY;
    }

    public WatcherSearchTemplateRequest(WatcherSearchTemplateRequest original, BytesReference source) {
        this.indices = original.indices;
        this.types = original.types;
        this.searchType = original.searchType;
        this.indicesOptions = original.indicesOptions;
        this.searchSource = source;
        this.template = original.template;
    }

    private WatcherSearchTemplateRequest(String[] indices, String[] types, SearchType searchType, IndicesOptions indicesOptions, BytesReference searchSource, Script template) {
        this.indices = indices;
        this.types = types;
        this.searchType = searchType;
        this.indicesOptions = indicesOptions;
        this.template = template;
        this.searchSource = searchSource;
    }

    @Nullable
    public Script getTemplate() {
        return this.template;
    }

    public String[] getIndices() {
        return this.indices;
    }

    public String[] getTypes() {
        return this.types;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public BytesReference getSearchSource() {
        return this.searchSource;
    }

    public Script getOrCreateTemplate() {
        if (this.template != null) {
            return this.template;
        }
        return new Script(ScriptType.INLINE, "mustache", this.searchSource.utf8ToString(), Collections.emptyMap());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.searchType != null) {
            builder.field(SEARCH_TYPE_FIELD.getPreferredName(), this.searchType.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.indices != null) {
            builder.array(INDICES_FIELD.getPreferredName(), this.indices);
        }
        if (this.types != null) {
            builder.array(TYPES_FIELD.getPreferredName(), this.types);
        }
        if (this.searchSource != null && this.searchSource.length() > 0) {
            builder.rawField(BODY_FIELD.getPreferredName(), this.searchSource);
        }
        if (this.indicesOptions != DEFAULT_INDICES_OPTIONS) {
            builder.startObject(INDICES_OPTIONS_FIELD.getPreferredName());
            String value = this.indicesOptions.expandWildcardsClosed() && this.indicesOptions.expandWildcardsOpen() ? "all" : (this.indicesOptions.expandWildcardsOpen() ? "open" : (this.indicesOptions.expandWildcardsClosed() ? "closed" : "none"));
            builder.field(EXPAND_WILDCARDS_FIELD.getPreferredName(), value);
            builder.field(IGNORE_UNAVAILABLE_FIELD.getPreferredName(), this.indicesOptions.ignoreUnavailable());
            builder.field(ALLOW_NO_INDICES_FIELD.getPreferredName(), this.indicesOptions.allowNoIndices());
            builder.endObject();
        }
        if (this.template != null) {
            builder.field(TEMPLATE_FIELD.getPreferredName(), (ToXContent)this.template);
        }
        return builder.endObject();
    }

    public static WatcherSearchTemplateRequest fromXContent(XContentParser parser, SearchType searchType) throws IOException {
        XContentParser.Token token;
        ArrayList<String> indices = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
        BytesArray searchSource = null;
        Script template = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (INDICES_FIELD.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            indices.add(parser.textOrNull());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not read search request. expected string values in [" + currentFieldName + "] field, but instead found [" + token + "]", new Object[0]);
                    }
                    continue;
                }
                if (TYPES_FIELD.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            types.add(parser.textOrNull());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not read search request. expected string values in [" + currentFieldName + "] field, but instead found [" + token + "]", new Object[0]);
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected array field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (BODY_FIELD.match(currentFieldName)) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    Throwable throwable = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        searchSource = builder.bytes();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (builder == null) continue;
                        if (throwable != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        builder.close();
                        continue;
                    }
                }
                if (INDICES_OPTIONS_FIELD.match(currentFieldName)) {
                    boolean expandOpen = DEFAULT_INDICES_OPTIONS.expandWildcardsOpen();
                    boolean expandClosed = DEFAULT_INDICES_OPTIONS.expandWildcardsClosed();
                    boolean allowNoIndices = DEFAULT_INDICES_OPTIONS.allowNoIndices();
                    boolean ignoreUnavailable = DEFAULT_INDICES_OPTIONS.ignoreUnavailable();
                    block24: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (EXPAND_WILDCARDS_FIELD.match(currentFieldName)) {
                                switch (parser.text()) {
                                    case "all": {
                                        expandOpen = true;
                                        expandClosed = true;
                                        continue block24;
                                    }
                                    case "open": {
                                        expandOpen = true;
                                        expandClosed = false;
                                        continue block24;
                                    }
                                    case "closed": {
                                        expandOpen = false;
                                        expandClosed = true;
                                        continue block24;
                                    }
                                    case "none": {
                                        expandOpen = false;
                                        expandClosed = false;
                                        continue block24;
                                    }
                                }
                                throw new ElasticsearchParseException("could not read search request. unknown value [" + parser.text() + "] for [" + currentFieldName + "] field ", new Object[0]);
                            }
                            if (IGNORE_UNAVAILABLE_FIELD.match(currentFieldName)) {
                                ignoreUnavailable = parser.booleanValue();
                                continue;
                            }
                            if (ALLOW_NO_INDICES_FIELD.match(currentFieldName)) {
                                allowNoIndices = parser.booleanValue();
                                continue;
                            }
                            throw new ElasticsearchParseException("could not read search request. unexpected index option [" + currentFieldName + "]", new Object[0]);
                        }
                        throw new ElasticsearchParseException("could not read search request. unexpected object field [" + currentFieldName + "]", new Object[0]);
                    }
                    indicesOptions = IndicesOptions.fromOptions((boolean)ignoreUnavailable, (boolean)allowNoIndices, (boolean)expandOpen, (boolean)expandClosed, (IndicesOptions)DEFAULT_INDICES_OPTIONS);
                    continue;
                }
                if (TEMPLATE_FIELD.match(currentFieldName)) {
                    template = Script.parse((XContentParser)parser, (String)"mustache");
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected object field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (INDICES_FIELD.match(currentFieldName)) {
                    String indicesStr = parser.text();
                    indices.addAll(Arrays.asList(Strings.delimitedListToStringArray((String)indicesStr, (String)",", (String)" \t")));
                    continue;
                }
                if (TYPES_FIELD.match(currentFieldName)) {
                    String typesStr = parser.text();
                    types.addAll(Arrays.asList(Strings.delimitedListToStringArray((String)typesStr, (String)",", (String)" \t")));
                    continue;
                }
                if (SEARCH_TYPE_FIELD.match(currentFieldName)) {
                    searchType = SearchType.fromString((String)parser.text().toLowerCase(Locale.ROOT));
                    continue;
                }
                throw new ElasticsearchParseException("could not read search request. unexpected string field [" + currentFieldName + "]", new Object[0]);
            }
            throw new ElasticsearchParseException("could not read search request. unexpected token [" + token + "]", new Object[0]);
        }
        if (searchSource == null) {
            searchSource = BytesArray.EMPTY;
        }
        return new WatcherSearchTemplateRequest(indices.toArray(new String[0]), types.toArray(new String[0]), searchType, indicesOptions, (BytesReference)searchSource, template);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatcherSearchTemplateRequest other = (WatcherSearchTemplateRequest)o;
        return Arrays.equals(this.indices, other.indices) && Arrays.equals(this.types, other.types) && Objects.equals(this.searchType, other.searchType) && Objects.equals(this.indicesOptions, other.indicesOptions) && Objects.equals(this.searchSource, other.searchSource) && Objects.equals(this.template, other.template);
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.types, this.searchType, this.indicesOptions, this.searchSource, this.template);
    }
}

