/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.template.TemplateUtils;

public class WatcherIndexTemplateRegistry
extends AbstractComponent
implements ClusterStateListener {
    public static final String INDEX_TEMPLATE_VERSION = "7";
    public static final String HISTORY_TEMPLATE_NAME = ".watch-history-7";
    public static final String TRIGGERED_TEMPLATE_NAME = ".triggered_watches";
    public static final String WATCHES_TEMPLATE_NAME = ".watches";
    public static final String[] TEMPLATE_NAMES = new String[]{".watch-history-7", ".triggered_watches", ".watches"};
    public static final TemplateConfig TEMPLATE_CONFIG_TRIGGERED_WATCHES = new TemplateConfig(".triggered_watches", "triggered-watches");
    public static final TemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY = new TemplateConfig(".watch-history-7", "watch-history");
    public static final TemplateConfig TEMPLATE_CONFIG_WATCHES = new TemplateConfig(".watches", "watches");
    public static final TemplateConfig[] TEMPLATE_CONFIGS = new TemplateConfig[]{TEMPLATE_CONFIG_TRIGGERED_WATCHES, TEMPLATE_CONFIG_WATCH_HISTORY, TEMPLATE_CONFIG_WATCHES};
    private final Client client;
    private final ThreadPool threadPool;
    private final TemplateConfig[] indexTemplates;
    private final ConcurrentMap<String, AtomicBoolean> templateCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();

    public WatcherIndexTemplateRegistry(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client) {
        super(settings);
        this.client = client;
        this.threadPool = threadPool;
        this.indexTemplates = TEMPLATE_CONFIGS;
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode localNode = event.state().getNodes().getLocalNode();
        DiscoveryNode masterNode = event.state().getNodes().getMasterNode();
        boolean localNodeVersionAfterMaster = localNode.getVersion().after(masterNode.getVersion());
        if (event.localNodeMaster() || localNodeVersionAfterMaster) {
            this.addTemplatesIfMissing(state);
        }
    }

    private void addTemplatesIfMissing(ClusterState state) {
        for (TemplateConfig template : this.indexTemplates) {
            String templateName = template.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            if (!state.metaData().getTemplates().containsKey((Object)templateName)) {
                this.logger.debug("adding index template [{}], because it doesn't exist", (Object)templateName);
                this.putTemplate(template, creationCheck);
                continue;
            }
            creationCheck.set(false);
            this.logger.trace("not adding index template [{}], because it already exists", (Object)templateName);
        }
    }

    private void putTemplate(TemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(config.load(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "watcher", request, new ActionListener<PutIndexTemplateResponse>(){

                public void onResponse(PutIndexTemplateResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        WatcherIndexTemplateRegistry.this.logger.error("Error adding watcher template [{}], request was not acknowledged", (Object)templateName);
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    WatcherIndexTemplateRegistry.this.logger.error((Message)new ParameterizedMessage("Error adding watcher template [{}]", (Object)templateName), (Throwable)e);
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putTemplate(arg_0, arg_1));
        });
    }

    public static boolean validate(ClusterState state) {
        return state.getMetaData().getTemplates().containsKey((Object)HISTORY_TEMPLATE_NAME) && state.getMetaData().getTemplates().containsKey((Object)TRIGGERED_TEMPLATE_NAME) && state.getMetaData().getTemplates().containsKey((Object)WATCHES_TEMPLATE_NAME);
    }

    public static class TemplateConfig {
        private final String templateName;
        private String fileName;

        TemplateConfig(String templateName, String fileName) {
            this.templateName = templateName;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public byte[] load() {
            String template = TemplateUtils.loadTemplate("/" + this.fileName + ".json", WatcherIndexTemplateRegistry.INDEX_TEMPLATE_VERSION, Pattern.quote("${xpack.watcher.template.version}"));
            assert (template != null && template.length() > 0);
            return template.getBytes(StandardCharsets.UTF_8);
        }
    }
}

