/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestHijackOperationAction
extends WatcherRestHandler {
    private static final String ALLOW_DIRECT_ACCESS_TO_WATCH_INDEX_SETTING = "xpack.watcher.index.rest.direct_access";

    public RestHijackOperationAction(Settings settings, RestController controller) {
        super(settings);
        if (!settings.getAsBoolean(ALLOW_DIRECT_ACCESS_TO_WATCH_INDEX_SETTING, Boolean.valueOf(false)).booleanValue()) {
            UnsupportedHandler unsupportedHandler = new UnsupportedHandler(settings);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/{id}/_update", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches/watch/_query", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.GET, ".watches/watch/{id}", (RestHandler)this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/watch/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/_bulk", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/_delete_by_query", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/_delete_by_query", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/_update_by_query", (RestHandler)unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/_update_by_query", (RestHandler)unsupportedHandler);
        }
    }

    public String getName() {
        return "xpack_watcher_hijack_operation_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
        if (request.hasParam("id")) {
            request.param("id");
        }
        return channel -> {
            try (XContentBuilder builder = channel.newErrorBuilder();){
                builder.startObject().field("error", "This endpoint is not supported for " + request.method().name() + " on " + ".watches" + " index. Please use " + request.method().name() + " " + URI_BASE + "/watch/<watch_id> instead");
                builder.field("status", RestStatus.BAD_REQUEST.getStatus());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
            }
        };
    }

    private static class UnsupportedHandler
    extends WatcherRestHandler {
        private UnsupportedHandler(Settings settings) {
            super(settings);
        }

        public String getName() {
            return "xpack_watcher_unsupported_action";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
            if (request.hasParam("id")) {
                request.param("id");
            }
            return channel -> {
                try (XContentBuilder builder = channel.newErrorBuilder();){
                    builder.startObject().field("error", "This endpoint is not supported for " + request.method().name() + " on " + ".watches" + " index.");
                    builder.field("status", RestStatus.BAD_REQUEST.getStatus());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
                }
            };
        }
    }
}

