/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.search;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.watcher.WatcherClientHelper;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.watcher.input.search.SearchInput;
import org.elasticsearch.xpack.watcher.support.XContentFilterKeysUtils;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableSearchInput
extends ExecutableInput<SearchInput, SearchInput.Result> {
    public static final SearchType DEFAULT_SEARCH_TYPE = SearchType.QUERY_THEN_FETCH;
    private final Client client;
    private final WatcherSearchTemplateService searchTemplateService;
    private final TimeValue timeout;

    public ExecutableSearchInput(SearchInput input, Logger logger, Client client, WatcherSearchTemplateService searchTemplateService, TimeValue defaultTimeout) {
        super(input, logger);
        this.client = client;
        this.searchTemplateService = searchTemplateService;
        this.timeout = input.getTimeout() != null ? input.getTimeout() : defaultTimeout;
    }

    @Override
    public SearchInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        WatcherSearchTemplateRequest request = null;
        try {
            Script template = ((SearchInput)this.input).getRequest().getOrCreateTemplate();
            String renderedTemplate = this.searchTemplateService.renderTemplate(template, ctx, payload);
            request = new WatcherSearchTemplateRequest(((SearchInput)this.input).getRequest(), (BytesReference)new BytesArray(renderedTemplate));
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] input for watch [{}], reason [{}]", (Object)"search", (Object)ctx.watch().id(), (Object)e.getMessage());
            return new SearchInput.Result(request, e);
        }
    }

    SearchInput.Result doExecute(WatchExecutionContext ctx, WatcherSearchTemplateRequest request) throws Exception {
        Payload.Simple payload;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] running query for [{}] [{}]", (Object)ctx.id(), (Object)ctx.watch().id(), (Object)request.getSearchSource().utf8ToString());
        }
        SearchRequest searchRequest = this.searchTemplateService.toSearchRequest(request);
        SearchResponse response = WatcherClientHelper.execute(ctx.watch(), this.client, () -> (SearchResponse)this.client.search(searchRequest).actionGet(this.timeout));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] found [{}] hits", (Object)ctx.id(), (Object)response.getHits().getTotalHits());
            for (SearchHit hit : response.getHits()) {
                this.logger.debug("[{}] hit [{}]", (Object)ctx.id(), (Object)hit.getSourceAsMap());
            }
        }
        if (((SearchInput)this.input).getExtractKeys() != null) {
            BytesReference bytes = XContentHelper.toXContent((ToXContent)response, (XContentType)XContentType.JSON, (boolean)false);
            try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (BytesReference)bytes);){
                Map<String, Object> filteredKeys = XContentFilterKeysUtils.filterMapOrdered(((SearchInput)this.input).getExtractKeys(), parser);
                payload = new Payload.Simple(filteredKeys);
            }
        } else {
            payload = new Payload.XContent((ToXContentObject)response);
        }
        return new SearchInput.Result(request, (Payload)payload);
    }
}

