/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.history;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.watcher.history.WatchRecord;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class HistoryStore
extends AbstractComponent {
    public static final String INDEX_PREFIX = ".watcher-history-";
    public static final String INDEX_PREFIX_WITH_TEMPLATE = ".watcher-history-7-";
    public static final String DOC_TYPE = "doc";
    static final DateTimeFormatter indexTimeFormat = DateTimeFormat.forPattern((String)"YYYY.MM.dd");
    private final Client client;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock putUpdateLock = this.readWriteLock.readLock();
    private final Lock stopLock = this.readWriteLock.writeLock();
    private final AtomicBoolean started = new AtomicBoolean(false);

    public HistoryStore(Settings settings, Client client) {
        super(settings);
        this.client = client;
    }

    public void start() {
        this.started.set(true);
    }

    public void stop() {
        this.stopLock.lock();
        try {
            this.started.set(false);
        }
        finally {
            this.stopLock.unlock();
        }
    }

    public void put(WatchRecord watchRecord) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("unable to persist watch record history store is not ready");
        }
        String index = HistoryStore.getHistoryIndexNameForTime(watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();
             ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(this.client.threadPool().getThreadContext(), "watcher");){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).build());
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(builder).opType(DocWriteRequest.OpType.CREATE);
            this.client.index(request).actionGet(30L, TimeUnit.SECONDS);
            this.logger.debug("indexed watch history record [{}]", (Object)watchRecord.id().value());
        }
        catch (IOException ioe) {
            throw Exceptions.ioException("failed to persist watch record [{}]", ioe, watchRecord);
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forcePut(WatchRecord watchRecord) {
        if (!this.started.get()) {
            throw new IllegalStateException("unable to persist watch record history store is not ready");
        }
        String index = HistoryStore.getHistoryIndexNameForTime(watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();
                 ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(this.client.threadPool().getThreadContext(), "watcher");){
                watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).build());
                IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(builder).opType(DocWriteRequest.OpType.CREATE);
                this.client.index(request).get(30L, TimeUnit.SECONDS);
                this.logger.debug("indexed watch history record [{}]", (Object)watchRecord.id().value());
            }
            catch (VersionConflictEngineException vcee) {
                watchRecord = new WatchRecord.MessageWatchRecord(watchRecord, ExecutionState.EXECUTED_MULTIPLE_TIMES, "watch record [{ " + watchRecord.id() + " }] has been stored before, previous state [" + (Object)((Object)watchRecord.state()) + "]");
                try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                     ThreadContext.StoredContext ignore2 = ClientHelper.stashWithOrigin(this.client.threadPool().getThreadContext(), "watcher");){
                    IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(xContentBuilder.value((Object)watchRecord));
                    this.client.index(request).get(30L, TimeUnit.SECONDS);
                }
                this.logger.debug("overwrote watch history record [{}]", (Object)watchRecord.id().value());
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ioe) {
            WatchRecord wr = watchRecord;
            this.logger.error(() -> new ParameterizedMessage("failed to persist watch record [{}]", (Object)wr), (Throwable)ioe);
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    public static String getHistoryIndexNameForTime(DateTime time) {
        return INDEX_PREFIX_WITH_TEMPLATE + indexTimeFormat.print((ReadableInstant)time);
    }

    public static boolean validate(ClusterState state) {
        String currentIndex = HistoryStore.getHistoryIndexNameForTime(DateTime.now((DateTimeZone)DateTimeZone.UTC));
        IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(currentIndex, state.metaData());
        if (indexMetaData == null) {
            return true;
        }
        return indexMetaData.getState() == IndexMetaData.State.OPEN && state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive();
    }
}

