/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.common.stats.Counters;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.execution.CurrentExecutions;
import org.elasticsearch.xpack.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.watcher.execution.QueuedWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredExecutionContext;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionSnapshot;
import org.elasticsearch.xpack.watcher.execution.WatchExecutor;
import org.elasticsearch.xpack.watcher.history.HistoryStore;
import org.elasticsearch.xpack.watcher.history.WatchRecord;
import org.elasticsearch.xpack.watcher.input.Input;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.watch.Watch;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ExecutionService
extends AbstractComponent {
    public static final Setting<TimeValue> DEFAULT_THROTTLE_PERIOD_SETTING = Setting.positiveTimeSetting((String)"xpack.watcher.execution.default_throttle_period", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final MeanMetric totalExecutionsTime = new MeanMetric();
    private final Map<String, MeanMetric> actionByTypeExecutionTime = new HashMap<String, MeanMetric>();
    private final HistoryStore historyStore;
    private final TriggeredWatchStore triggeredWatchStore;
    private final WatchExecutor executor;
    private final Clock clock;
    private final TimeValue defaultThrottlePeriod;
    private final TimeValue maxStopTimeout;
    private final ThreadPool threadPool;
    private final Watch.Parser parser;
    private final ClusterService clusterService;
    private final Client client;
    private final TimeValue indexDefaultTimeout;
    private volatile CurrentExecutions currentExecutions;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public ExecutionService(Settings settings, HistoryStore historyStore, TriggeredWatchStore triggeredWatchStore, WatchExecutor executor, Clock clock, ThreadPool threadPool, Watch.Parser parser, ClusterService clusterService, Client client) {
        super(settings);
        this.historyStore = historyStore;
        this.triggeredWatchStore = triggeredWatchStore;
        this.executor = executor;
        this.clock = clock;
        this.defaultThrottlePeriod = (TimeValue)DEFAULT_THROTTLE_PERIOD_SETTING.get(settings);
        this.maxStopTimeout = (TimeValue)Watcher.MAX_STOP_TIMEOUT_SETTING.get(settings);
        this.threadPool = threadPool;
        this.parser = parser;
        this.clusterService = clusterService;
        this.client = client;
        this.indexDefaultTimeout = settings.getAsTime("xpack.watcher.internal.ops.index.default_timeout", TimeValue.timeValueSeconds((long)30L));
    }

    public void start(ClusterState state) throws Exception {
        if (this.started.get()) {
            return;
        }
        assert (this.executor.queue().isEmpty()) : "queue should be empty, but contains " + this.executor.queue().size() + " elements.";
        if (this.started.compareAndSet(false, true)) {
            try {
                this.logger.debug("starting execution service");
                this.historyStore.start();
                this.triggeredWatchStore.start();
                this.currentExecutions = new CurrentExecutions();
                this.logger.debug("started execution service");
            }
            catch (Exception e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public boolean validate(ClusterState state) {
        return this.triggeredWatchStore.validate(state) && HistoryStore.validate(state);
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.logger.debug("stopping execution service");
            int cancelledTaskCount = this.executor.queue().drainTo(new ArrayList());
            this.clearExecutions();
            this.triggeredWatchStore.stop();
            this.historyStore.stop();
            this.logger.debug("stopped execution service, cancelled [{}] queued tasks", (Object)cancelledTaskCount);
        }
    }

    public synchronized int pauseExecution() {
        int cancelledTaskCount = this.executor.queue().drainTo(new ArrayList());
        this.clearExecutions();
        return cancelledTaskCount;
    }

    public TimeValue defaultThrottlePeriod() {
        return this.defaultThrottlePeriod;
    }

    public long executionThreadPoolQueueSize() {
        return this.executor.queue().size();
    }

    public long executionThreadPoolMaxSize() {
        return this.executor.largestPoolSize();
    }

    CurrentExecutions getCurrentExecutions() {
        return this.currentExecutions;
    }

    public List<WatchExecutionSnapshot> currentExecutions() {
        ArrayList<WatchExecutionSnapshot> currentExecutions = new ArrayList<WatchExecutionSnapshot>();
        for (WatchExecution watchExecution : this.currentExecutions) {
            currentExecutions.add(watchExecution.createSnapshot());
        }
        Collections.sort(currentExecutions, Comparator.comparing(WatchExecutionSnapshot::executionTime));
        return currentExecutions;
    }

    public List<QueuedWatch> queuedWatches() {
        ArrayList snapshot = new ArrayList();
        this.executor.tasks().forEach(t -> snapshot.add(t));
        if (snapshot.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueuedWatch> queuedWatches = new ArrayList<QueuedWatch>(snapshot.size());
        for (Runnable task : snapshot) {
            WatchExecutionTask executionTask = (WatchExecutionTask)task;
            queuedWatches.add(new QueuedWatch(executionTask.ctx));
        }
        Collections.sort(queuedWatches, Comparator.comparing(QueuedWatch::executionTime));
        return queuedWatches;
    }

    void processEventsAsync(Iterable<TriggerEvent> events) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("not started");
        }
        Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> watchesAndContext = this.createTriggeredWatchesAndContext(events);
        List triggeredWatches = (List)watchesAndContext.v1();
        this.triggeredWatchStore.putAll(triggeredWatches, (ActionListener<BulkResponse>)ActionListener.wrap(response -> this.executeTriggeredWatches((BulkResponse)response, watchesAndContext), e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof EsRejectedExecutionException) {
                this.logger.debug("failed to store watch records due to filled up watcher threadpool");
            } else {
                this.logger.warn("failed to store watch records", (Throwable)e);
            }
        }));
    }

    void processEventsSync(Iterable<TriggerEvent> events) throws IOException {
        if (!this.started.get()) {
            throw new IllegalStateException("not started");
        }
        Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> watchesAndContext = this.createTriggeredWatchesAndContext(events);
        List triggeredWatches = (List)watchesAndContext.v1();
        this.logger.debug("saving watch records [{}]", (Object)triggeredWatches.size());
        BulkResponse bulkResponse = this.triggeredWatchStore.putAll(triggeredWatches);
        this.executeTriggeredWatches(bulkResponse, watchesAndContext);
    }

    private Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> createTriggeredWatchesAndContext(Iterable<TriggerEvent> events) {
        LinkedList<TriggeredWatch> triggeredWatches = new LinkedList<TriggeredWatch>();
        LinkedList<TriggeredExecutionContext> contexts = new LinkedList<TriggeredExecutionContext>();
        DateTime now = new DateTime(this.clock.millis(), DateTimeZone.UTC);
        for (TriggerEvent event : events) {
            GetResponse response = this.getWatch(event.jobName());
            if (!response.isExists()) {
                this.logger.warn("unable to find watch [{}] in watch index, perhaps it has been deleted", (Object)event.jobName());
                continue;
            }
            TriggeredExecutionContext ctx = new TriggeredExecutionContext(event.jobName(), now, event, this.defaultThrottlePeriod);
            contexts.add(ctx);
            triggeredWatches.add(new TriggeredWatch(ctx.id(), event));
        }
        return Tuple.tuple(triggeredWatches, contexts);
    }

    private void executeTriggeredWatches(BulkResponse response, Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> watchesAndContext) {
        for (int i = 0; i < response.getItems().length; ++i) {
            BulkItemResponse itemResponse = response.getItems()[i];
            if (itemResponse.isFailed()) {
                this.logger.error("could not store triggered watch with id [{}]: [{}]", (Object)itemResponse.getId(), (Object)itemResponse.getFailureMessage());
                continue;
            }
            this.executeAsync((WatchExecutionContext)((List)watchesAndContext.v2()).get(i), (TriggeredWatch)((List)watchesAndContext.v1()).get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchRecord execute(WatchExecutionContext ctx) {
        WatchRecord record;
        block29: {
            ctx.setNodeId(this.clusterService.localNode().getId());
            record = null;
            String watchId = ctx.id().watchId();
            try {
                boolean executionAlreadyExists = this.currentExecutions.put(watchId, new WatchExecution(ctx, Thread.currentThread()));
                if (executionAlreadyExists) {
                    this.logger.trace("not executing watch [{}] because it is already queued", (Object)watchId);
                    record = ctx.abortBeforeExecution(ExecutionState.NOT_EXECUTED_ALREADY_QUEUED, "Watch is already queued in thread pool");
                    break block29;
                }
                try {
                    ctx.ensureWatchExists((CheckedSupplier<Watch, Exception>)((CheckedSupplier)() -> {
                        GetResponse resp = this.getWatch(watchId);
                        if (!resp.isExists()) {
                            throw new ResourceNotFoundException("watch [{}] does not exist", new Object[]{watchId});
                        }
                        return this.parser.parseWithSecrets(watchId, true, resp.getSourceAsBytesRef(), ctx.executionTime(), XContentType.JSON);
                    }));
                }
                catch (ResourceNotFoundException e) {
                    String message = "unable to find watch for record [" + ctx.id() + "]";
                    record = ctx.abortBeforeExecution(ExecutionState.NOT_EXECUTED_WATCH_MISSING, message);
                }
                catch (Exception e) {
                    record = ctx.abortFailedExecution(e);
                }
                if (ctx.watch() != null) {
                    if (ctx.watch().status().state().isActive()) {
                        this.logger.debug("executing watch [{}]", (Object)watchId);
                        record = this.executeInner(ctx);
                        if (ctx.recordExecution()) {
                            this.updateWatchStatus(ctx.watch());
                        }
                    } else {
                        this.logger.debug("not executing watch [{}] because it is marked as inactive", (Object)watchId);
                        record = ctx.abortBeforeExecution(ExecutionState.EXECUTION_NOT_NEEDED, "Watch is not active");
                    }
                }
            }
            catch (Exception e) {
                record = this.createWatchRecord(record, ctx, e);
                this.logWatchRecord(ctx, e);
            }
            finally {
                if (ctx.knownWatch()) {
                    if (record != null && ctx.recordExecution()) {
                        try {
                            if (ctx.overrideRecordOnConflict()) {
                                this.historyStore.forcePut(record);
                            } else {
                                this.historyStore.put(record);
                            }
                        }
                        catch (Exception e) {
                            this.logger.error(() -> new ParameterizedMessage("failed to update watch record [{}]", (Object)ctx.id()), (Throwable)e);
                        }
                    }
                    try {
                        this.triggeredWatchStore.delete(ctx.id());
                    }
                    catch (Exception e) {
                        this.logger.error(() -> new ParameterizedMessage("failed to delete triggered watch [{}]", (Object)ctx.id()), (Throwable)e);
                    }
                }
                this.currentExecutions.remove(watchId);
                this.logger.debug("finished [{}]/[{}]", (Object)watchId, (Object)ctx.id());
            }
        }
        return record;
    }

    public void updateWatchStatus(Watch watch) throws IOException {
        Map parameters = MapBuilder.newMapBuilder().put((Object)"include_status", (Object)"true").put((Object)"include_state", (Object)"false").immutableMap();
        ToXContent.MapParams params = new ToXContent.MapParams(parameters);
        XContentBuilder source = JsonXContent.contentBuilder().startObject().field(Watch.Field.STATUS.getPreferredName(), (ToXContent)watch.status(), (ToXContent.Params)params).endObject();
        UpdateRequest updateRequest = new UpdateRequest(".watches", "doc", watch.id());
        updateRequest.doc(source);
        updateRequest.version(watch.version());
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(this.client.threadPool().getThreadContext(), "watcher");){
            this.client.update(updateRequest).actionGet(this.indexDefaultTimeout);
        }
        catch (DocumentMissingException documentMissingException) {
            // empty catch block
        }
    }

    private WatchRecord createWatchRecord(WatchRecord existingRecord, WatchExecutionContext ctx, Exception e) {
        if (ctx.executionPhase().sealed()) {
            if (existingRecord == null) {
                return new WatchRecord.ExceptionWatchRecord(ctx, e);
            }
            return new WatchRecord.ExceptionWatchRecord(existingRecord, e);
        }
        return ctx.abortFailedExecution(e);
    }

    private void logWatchRecord(WatchExecutionContext ctx, Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("failed to execute watch [{}]", (Object)ctx.id().watchId()), (Throwable)e);
        } else {
            this.logger.warn("failed to execute watch [{}]", (Object)ctx.id().watchId());
        }
    }

    private void executeAsync(WatchExecutionContext ctx, TriggeredWatch triggeredWatch) {
        try {
            this.executor.execute(new WatchExecutionTask(ctx, () -> this.execute(ctx)));
        }
        catch (EsRejectedExecutionException e) {
            String message = "failed to run triggered watch [" + triggeredWatch.id() + "] due to thread pool capacity";
            WatchRecord record = ctx.abortBeforeExecution(ExecutionState.THREADPOOL_REJECTION, message);
            try {
                if (ctx.overrideRecordOnConflict()) {
                    this.historyStore.forcePut(record);
                } else {
                    this.historyStore.put(record);
                }
            }
            catch (Exception exc) {
                this.logger.error(() -> new ParameterizedMessage("Error storing watch history record for watch [{}] after thread pool rejection", (Object)triggeredWatch.id()), (Throwable)exc);
            }
            try {
                this.triggeredWatchStore.delete(triggeredWatch.id());
            }
            catch (Exception exc) {
                this.logger.error(() -> new ParameterizedMessage("Error deleting triggered watch store record for watch [{}] after thread pool rejection", (Object)triggeredWatch.id()), (Throwable)exc);
            }
        }
    }

    WatchRecord executeInner(WatchExecutionContext ctx) {
        ctx.start();
        Watch watch = ctx.watch();
        ctx.beforeInput();
        Input.Result inputResult = ctx.inputResult();
        if (inputResult == null) {
            inputResult = watch.input().execute(ctx, ctx.payload());
            ctx.onInputResult(inputResult);
        }
        if (inputResult.status() == Input.Result.Status.FAILURE) {
            return ctx.abortFailedExecution("failed to execute watch input");
        }
        ctx.beforeCondition();
        Condition.Result conditionResult = ctx.conditionResult();
        if (conditionResult == null) {
            conditionResult = watch.condition().execute(ctx);
            ctx.onConditionResult(conditionResult);
        }
        if (conditionResult.status() == Condition.Result.Status.FAILURE) {
            return ctx.abortFailedExecution("failed to execute watch condition");
        }
        if (conditionResult.met()) {
            if (watch.actions().size() > 0 && watch.transform() != null) {
                ctx.beforeWatchTransform();
                Iterator<ActionWrapper> transformResult = watch.transform().execute(ctx, ctx.payload());
                ctx.onWatchTransformResult((Transform.Result)((Object)transformResult));
                if (((Transform.Result)((Object)transformResult)).status() == Transform.Result.Status.FAILURE) {
                    return ctx.abortFailedExecution("failed to execute watch transform");
                }
            }
            ctx.beforeActions();
            for (ActionWrapper action : watch.actions()) {
                long now = System.currentTimeMillis();
                ActionWrapper.Result actionResult = action.execute(ctx);
                long executionTime = System.currentTimeMillis() - now;
                String type = action.action().type();
                this.actionByTypeExecutionTime.putIfAbsent(type, new MeanMetric());
                this.actionByTypeExecutionTime.get(type).inc(executionTime);
                ctx.onActionResult(actionResult);
            }
        }
        WatchRecord record = ctx.finish();
        this.totalExecutionsTime.inc(record.result().executionDurationMs());
        return record;
    }

    public void executeTriggeredWatches(Collection<TriggeredWatch> triggeredWatches) {
        assert (triggeredWatches != null);
        int counter = 0;
        for (TriggeredWatch triggeredWatch : triggeredWatches) {
            GetResponse response = this.getWatch(triggeredWatch.id().watchId());
            if (!response.isExists()) {
                String message = "unable to find watch for record [" + triggeredWatch.id().watchId() + "]/[" + triggeredWatch.id() + "], perhaps it has been deleted, ignoring...";
                WatchRecord.MessageWatchRecord record = new WatchRecord.MessageWatchRecord(triggeredWatch.id(), triggeredWatch.triggerEvent(), ExecutionState.NOT_EXECUTED_WATCH_MISSING, message, this.clusterService.localNode().getId());
                this.historyStore.forcePut(record);
                this.triggeredWatchStore.delete(triggeredWatch.id());
                continue;
            }
            DateTime now = new DateTime(this.clock.millis(), DateTimeZone.UTC);
            TriggeredExecutionContext ctx = new TriggeredExecutionContext(triggeredWatch.id().watchId(), now, triggeredWatch.triggerEvent(), this.defaultThrottlePeriod, true);
            this.executeAsync(ctx, triggeredWatch);
            ++counter;
        }
        this.logger.debug("triggered execution of [{}] watches", (Object)counter);
    }

    private GetResponse getWatch(String id) {
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(this.client.threadPool().getThreadContext(), "watcher");){
            GetRequest getRequest = new GetRequest(".watches", "doc", id).preference(Preference.LOCAL.type()).realtime(true);
            PlainActionFuture future = PlainActionFuture.newFuture();
            this.client.get(getRequest, (ActionListener)future);
            GetResponse getResponse = (GetResponse)future.actionGet();
            return getResponse;
        }
    }

    public Map<String, Object> usageStats() {
        Counters counters = new Counters(new String[0]);
        counters.inc("execution.actions._all.total", this.totalExecutionsTime.count());
        counters.inc("execution.actions._all.total_time_in_ms", this.totalExecutionsTime.sum());
        for (Map.Entry<String, MeanMetric> entry : this.actionByTypeExecutionTime.entrySet()) {
            counters.inc("execution.actions." + entry.getKey() + ".total", entry.getValue().count());
            counters.inc("execution.actions." + entry.getKey() + ".total_time_in_ms", entry.getValue().sum());
        }
        return counters.toMap();
    }

    public void clearExecutions() {
        this.currentExecutions.sealAndAwaitEmpty(this.maxStopTimeout);
        this.currentExecutions = new CurrentExecutions();
    }

    public static class WatchExecution {
        private final WatchExecutionContext context;
        private final Thread executionThread;

        public WatchExecution(WatchExecutionContext context, Thread executionThread) {
            this.context = context;
            this.executionThread = executionThread;
        }

        public WatchExecutionSnapshot createSnapshot() {
            return this.context.createSnapshot(this.executionThread);
        }
    }

    static final class WatchExecutionTask
    implements Runnable {
        private final WatchExecutionContext ctx;
        private final Runnable runnable;

        WatchExecutionTask(WatchExecutionContext ctx, Runnable runnable) {
            this.ctx = ctx;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

