/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ssl.SSLClientAuth;
import org.elasticsearch.xpack.ssl.VerificationMode;

public class SSLConfigurationSettings {
    public final Setting<List<String>> ciphers;
    public final Setting<List<String>> supportedProtocols;
    public final Setting<Optional<String>> keystorePath;
    public final Setting<SecureString> keystorePassword;
    public final Setting<String> keystoreAlgorithm;
    public final Setting<Optional<String>> keystoreType;
    public final Setting<SecureString> keystoreKeyPassword;
    public final Setting<Optional<String>> truststorePath;
    public final Setting<SecureString> truststorePassword;
    public final Setting<String> truststoreAlgorithm;
    public final Setting<Optional<String>> truststoreType;
    public final Setting<Optional<String>> trustRestrictionsPath;
    public final Setting<Optional<String>> keyPath;
    public final Setting<SecureString> keyPassword;
    public final Setting<Optional<String>> cert;
    public final Setting<List<String>> caPaths;
    public final Setting<Optional<SSLClientAuth>> clientAuth;
    public final Setting<Optional<VerificationMode>> verificationMode;
    public final Setting<SecureString> legacyTruststorePassword;
    final Setting<SecureString> legacyKeystorePassword;
    final Setting<SecureString> legacyKeystoreKeyPassword;
    final Setting<SecureString> legacyKeyPassword;
    private final List<Setting<?>> allSettings;
    private static final String DEFAULT_KEYSTORE_TYPE = "jks";
    private static final String PKCS12_KEYSTORE_TYPE = "PKCS12";
    private static final Function<String, Setting<List<String>>> CIPHERS_SETTING_TEMPLATE = key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<List<String>> CIPHERS_SETTING_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.cipher_suites", CIPHERS_SETTING_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<List<String>>> SUPPORTED_PROTOCOLS_TEMPLATE = key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<List<String>> SUPPORTED_PROTOCOLS_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.supported_protocols", SUPPORTED_PROTOCOLS_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<String>>> KEYSTORE_PATH_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<String>> KEYSTORE_PATH_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.keystore.path", KEYSTORE_PATH_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> LEGACY_KEYSTORE_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    public static final Setting<SecureString> LEGACY_KEYSTORE_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.keystore.password", LEGACY_KEYSTORE_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> KEYSTORE_PASSWORD_TEMPLATE = key -> SecureSetting.secureString((String)key, LEGACY_KEYSTORE_PASSWORD_TEMPLATE.apply(key.replace("keystore.secure_password", "keystore.password")), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> KEYSTORE_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.keystore.secure_password", KEYSTORE_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    public static final Setting<SecureString> LEGACY_KEYSTORE_KEY_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.keystore.key_password", LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> KEYSTORE_KEY_PASSWORD_TEMPLATE = key -> SecureSetting.secureString((String)key, LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE.apply(key.replace("keystore.secure_key_password", "keystore.key_password")), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> KEYSTORE_KEY_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.keystore.secure_key_password", KEYSTORE_KEY_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<String>>> TRUST_STORE_PATH_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<String>> TRUST_STORE_PATH_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.truststore.path", TRUST_STORE_PATH_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<String>>> KEY_PATH_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<String>> KEY_PATH_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.key", KEY_PATH_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> LEGACY_TRUSTSTORE_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    public static final Setting<SecureString> LEGACY_TRUSTSTORE_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.truststore.password", LEGACY_TRUSTSTORE_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> TRUSTSTORE_PASSWORD_TEMPLATE = key -> SecureSetting.secureString((String)key, LEGACY_TRUSTSTORE_PASSWORD_TEMPLATE.apply(key.replace("truststore.secure_password", "truststore.password")), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> TRUSTSTORE_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.truststore.secure_password", TRUSTSTORE_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<String>> KEY_STORE_ALGORITHM_TEMPLATE = key -> new Setting(key, s -> KeyManagerFactory.getDefaultAlgorithm(), Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<String> KEY_STORE_ALGORITHM_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.keystore.algorithm", KEY_STORE_ALGORITHM_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<String>> TRUST_STORE_ALGORITHM_TEMPLATE = key -> new Setting(key, s -> TrustManagerFactory.getDefaultAlgorithm(), Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<String> TRUST_STORE_ALGORITHM_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.truststore.algorithm", TRUST_STORE_ALGORITHM_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<String>>> KEY_STORE_TYPE_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<String>> KEY_STORE_TYPE_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.keystore.type", KEY_STORE_TYPE_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<String>>> TRUST_STORE_TYPE_TEMPLATE = KEY_STORE_TYPE_TEMPLATE;
    public static final Setting<Optional<String>> TRUST_STORE_TYPE_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.truststore.type", TRUST_STORE_TYPE_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<String>>> TRUST_RESTRICTIONS_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<String>> TRUST_RESTRICTIONS_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.trust_restrictions", TRUST_RESTRICTIONS_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> LEGACY_KEY_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    public static final Setting<SecureString> LEGACY_KEY_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.key_passphrase", LEGACY_KEY_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<SecureString>> KEY_PASSWORD_TEMPLATE = key -> SecureSetting.secureString((String)key, LEGACY_KEY_PASSWORD_TEMPLATE.apply(key.replace("secure_key_passphrase", "key_passphrase")), (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> KEY_PASSWORD_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.secure_key_passphrase", KEY_PASSWORD_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<String>>> CERT_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<String>> CERT_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.certificate", CERT_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<List<String>>> CAPATH_SETTING_TEMPLATE = key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<List<String>> CAPATH_SETTING_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.certificate_authorities", CAPATH_SETTING_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<SSLClientAuth>>> CLIENT_AUTH_SETTING_TEMPLATE = key -> new Setting(key, (String)null, s -> s == null ? Optional.empty() : Optional.of(SSLClientAuth.parse(s)), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<SSLClientAuth>> CLIENT_AUTH_SETTING_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.client_authentication", CLIENT_AUTH_SETTING_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Function<String, Setting<Optional<VerificationMode>>> VERIFICATION_MODE_SETTING_TEMPLATE = key -> new Setting(key, (String)null, s -> s == null ? Optional.empty() : Optional.of(VerificationMode.parse(s)), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final Setting<Optional<VerificationMode>> VERIFICATION_MODE_SETTING_PROFILES = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.ssl.verification_mode", VERIFICATION_MODE_SETTING_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);

    private SSLConfigurationSettings(String prefix) {
        assert (prefix != null) : "Prefix cannot be null (but can be blank)";
        this.ciphers = CIPHERS_SETTING_TEMPLATE.apply(prefix + "cipher_suites");
        this.supportedProtocols = SUPPORTED_PROTOCOLS_TEMPLATE.apply(prefix + "supported_protocols");
        this.keystorePath = KEYSTORE_PATH_TEMPLATE.apply(prefix + "keystore.path");
        this.legacyKeystorePassword = LEGACY_KEYSTORE_PASSWORD_TEMPLATE.apply(prefix + "keystore.password");
        this.keystorePassword = KEYSTORE_PASSWORD_TEMPLATE.apply(prefix + "keystore.secure_password");
        this.legacyKeystoreKeyPassword = LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE.apply(prefix + "keystore.key_password");
        this.keystoreKeyPassword = KEYSTORE_KEY_PASSWORD_TEMPLATE.apply(prefix + "keystore.secure_key_password");
        this.truststorePath = TRUST_STORE_PATH_TEMPLATE.apply(prefix + "truststore.path");
        this.legacyTruststorePassword = LEGACY_TRUSTSTORE_PASSWORD_TEMPLATE.apply(prefix + "truststore.password");
        this.truststorePassword = TRUSTSTORE_PASSWORD_TEMPLATE.apply(prefix + "truststore.secure_password");
        this.keystoreAlgorithm = KEY_STORE_ALGORITHM_TEMPLATE.apply(prefix + "keystore.algorithm");
        this.truststoreAlgorithm = TRUST_STORE_ALGORITHM_TEMPLATE.apply(prefix + "truststore.algorithm");
        this.keystoreType = KEY_STORE_TYPE_TEMPLATE.apply(prefix + "keystore.type");
        this.truststoreType = TRUST_STORE_TYPE_TEMPLATE.apply(prefix + "truststore.type");
        this.trustRestrictionsPath = TRUST_RESTRICTIONS_TEMPLATE.apply(prefix + "trust_restrictions.path");
        this.keyPath = KEY_PATH_TEMPLATE.apply(prefix + "key");
        this.legacyKeyPassword = LEGACY_KEY_PASSWORD_TEMPLATE.apply(prefix + "key_passphrase");
        this.keyPassword = KEY_PASSWORD_TEMPLATE.apply(prefix + "secure_key_passphrase");
        this.cert = CERT_TEMPLATE.apply(prefix + "certificate");
        this.caPaths = CAPATH_SETTING_TEMPLATE.apply(prefix + "certificate_authorities");
        this.clientAuth = CLIENT_AUTH_SETTING_TEMPLATE.apply(prefix + "client_authentication");
        this.verificationMode = VERIFICATION_MODE_SETTING_TEMPLATE.apply(prefix + "verification_mode");
        this.allSettings = Arrays.asList(this.ciphers, this.supportedProtocols, this.keystorePath, this.keystorePassword, this.keystoreAlgorithm, this.keystoreType, this.keystoreKeyPassword, this.truststorePath, this.truststorePassword, this.truststoreAlgorithm, this.truststoreType, this.trustRestrictionsPath, this.keyPath, this.keyPassword, this.cert, this.caPaths, this.clientAuth, this.verificationMode, this.legacyKeystorePassword, this.legacyKeystoreKeyPassword, this.legacyKeyPassword, this.legacyTruststorePassword);
    }

    public static String getKeyStoreType(Setting<Optional<String>> setting, Settings settings, String path) {
        return ((Optional)setting.get(settings)).orElseGet(() -> SSLConfigurationSettings.inferKeyStoreType(path));
    }

    private static String inferKeyStoreType(String path) {
        String name;
        String string = name = path == null ? "" : path.toLowerCase(Locale.ROOT);
        if (name.endsWith(".p12") || name.endsWith(".pfx") || name.endsWith(".pkcs12")) {
            return PKCS12_KEYSTORE_TYPE;
        }
        return DEFAULT_KEYSTORE_TYPE;
    }

    public List<Setting<?>> getAllSettings() {
        return this.allSettings;
    }

    public static SSLConfigurationSettings withoutPrefix() {
        return new SSLConfigurationSettings("");
    }

    public static SSLConfigurationSettings withPrefix(String prefix) {
        assert (prefix.endsWith("ssl.")) : "The ssl config prefix (" + prefix + ") should end in 'ssl.'";
        return new SSLConfigurationSettings(prefix);
    }

    public static Collection<Setting<?>> getProfileSettings() {
        return Arrays.asList(CIPHERS_SETTING_PROFILES, SUPPORTED_PROTOCOLS_PROFILES, KEYSTORE_PATH_PROFILES, LEGACY_KEYSTORE_PASSWORD_PROFILES, KEYSTORE_PASSWORD_PROFILES, LEGACY_KEYSTORE_KEY_PASSWORD_PROFILES, KEYSTORE_KEY_PASSWORD_PROFILES, TRUST_STORE_PATH_PROFILES, LEGACY_TRUSTSTORE_PASSWORD_PROFILES, TRUSTSTORE_PASSWORD_PROFILES, KEY_STORE_ALGORITHM_PROFILES, TRUST_STORE_ALGORITHM_PROFILES, KEY_STORE_TYPE_PROFILES, TRUST_STORE_TYPE_PROFILES, TRUST_RESTRICTIONS_PROFILES, KEY_PATH_PROFILES, LEGACY_KEY_PASSWORD_PROFILES, KEY_PASSWORD_PROFILES, CERT_PROFILES, CAPATH_SETTING_PROFILES, CLIENT_AUTH_SETTING_PROFILES, VERIFICATION_MODE_SETTING_PROFILES);
    }
}

