/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.realm;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.security.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestClearRealmCacheAction
extends SecurityBaseRestHandler {
    public RestClearRealmCacheAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/realm/{realms}/_clear_cache", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_shield/realm/{realms}/_cache/clear", (RestHandler)this, "[POST /_shield/realm/{realms}/_cache/clear] is deprecated! Use [POST /_xpack/security/realm/{realms}/_clear_cache] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_shield/realm/{realms}/_clear_cache", (RestHandler)this, "[POST /_shield/realm/{realms}/_clear_cache] is deprecated! Use [POST /_xpack/security/realm/{realms}/_clear_cache] instead.", this.deprecationLogger);
    }

    public String getName() {
        return "xpack_security_clear_realm_cache_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] realms = request.paramAsStringArrayOrEmptyIfAll("realms");
        String[] usernames = request.paramAsStringArrayOrEmptyIfAll("usernames");
        ClearRealmCacheRequest req = new ClearRealmCacheRequest().realms(realms).usernames(usernames);
        return channel -> new SecurityClient((ElasticsearchClient)client).clearRealmCache(req, (ActionListener<ClearRealmCacheResponse>)new RestActions.NodesResponseRestListener(channel));
    }
}

