/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oauth2;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.security.action.token.InvalidateTokenRequest;
import org.elasticsearch.xpack.security.action.token.InvalidateTokenResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestInvalidateTokenAction
extends SecurityBaseRestHandler {
    static final ConstructingObjectParser<String, Void> PARSER = new ConstructingObjectParser("invalidate_token", a -> (String)a[0]);

    public RestInvalidateTokenAction(Settings settings, RestController controller, XPackLicenseState xPackLicenseState) {
        super(settings, xPackLicenseState);
        controller.registerHandler(RestRequest.Method.DELETE, "/_xpack/security/oauth2/token", (RestHandler)this);
    }

    public String getName() {
        return "xpack_security_invalidate_token_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            String token = (String)PARSER.parse(parser, null);
            InvalidateTokenRequest tokenRequest = new InvalidateTokenRequest(token);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((Action)InvalidateTokenAction.INSTANCE, (ActionRequest)tokenRequest, (ActionListener)new RestBuilderListener<InvalidateTokenResponse>(channel){

                public RestResponse buildResponse(InvalidateTokenResponse invalidateResp, XContentBuilder builder) throws Exception {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().field("created", invalidateResp.isCreated()).endObject());
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("token", new String[0]));
    }
}

