/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;

public final class DocumentSubsetReader
extends FilterLeafReader {
    private final BitSet roleQueryBits;
    private volatile int numDocs = -1;

    public static DocumentSubsetDirectoryReader wrap(DirectoryReader in, BitsetFilterCache bitsetFilterCache, Query roleQuery) throws IOException {
        return new DocumentSubsetDirectoryReader(in, bitsetFilterCache, roleQuery);
    }

    private DocumentSubsetReader(LeafReader in, BitsetFilterCache bitsetFilterCache, Query roleQuery) throws Exception {
        super(in);
        this.roleQueryBits = bitsetFilterCache.getBitSetProducer(roleQuery).getBitSet(in.getContext());
    }

    public Bits getLiveDocs() {
        final Bits actualLiveDocs = this.in.getLiveDocs();
        if (this.roleQueryBits == null) {
            return new Bits.MatchNoBits(this.in.maxDoc());
        }
        if (actualLiveDocs == null) {
            return this.roleQueryBits;
        }
        return new Bits(){

            public boolean get(int index) {
                return DocumentSubsetReader.this.roleQueryBits.get(index) && actualLiveDocs.get(index);
            }

            public int length() {
                return DocumentSubsetReader.this.roleQueryBits.length();
            }
        };
    }

    public int numDocs() {
        if (this.numDocs == -1) {
            final Bits liveDocs = this.in.getLiveDocs();
            if (this.roleQueryBits == null) {
                this.numDocs = 0;
            } else if (liveDocs == null) {
                this.numDocs = this.roleQueryBits.cardinality();
            } else {
                try {
                    FilteredDocIdSetIterator iterator = new FilteredDocIdSetIterator((DocIdSetIterator)new BitSetIterator(this.roleQueryBits, (long)this.roleQueryBits.approximateCardinality())){

                        protected boolean match(int doc) {
                            return liveDocs.get(doc);
                        }
                    };
                    int counter = 0;
                    int docId = iterator.nextDoc();
                    while (docId < Integer.MAX_VALUE) {
                        ++counter;
                        docId = iterator.nextDoc();
                    }
                    this.numDocs = counter;
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToElastic((Exception)e);
                }
            }
        }
        return this.numDocs;
    }

    public boolean hasDeletions() {
        return true;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    BitSet getRoleQueryBits() {
        return this.roleQueryBits;
    }

    Bits getWrappedLiveDocs() {
        return this.in.getLiveDocs();
    }

    static final class DocumentSubsetDirectoryReader
    extends FilterDirectoryReader {
        private final Query roleQuery;
        private final BitsetFilterCache bitsetFilterCache;

        DocumentSubsetDirectoryReader(DirectoryReader in, final BitsetFilterCache bitsetFilterCache, final Query roleQuery) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    try {
                        return new DocumentSubsetReader(reader, bitsetFilterCache, roleQuery);
                    }
                    catch (Exception e) {
                        throw ExceptionsHelper.convertToElastic((Exception)e);
                    }
                }
            });
            this.bitsetFilterCache = bitsetFilterCache;
            this.roleQuery = roleQuery;
            DocumentSubsetDirectoryReader.verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(in);
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DocumentSubsetDirectoryReader(in, this.bitsetFilterCache, this.roleQuery);
        }

        private static void verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(DirectoryReader reader) {
            if (reader instanceof FilterDirectoryReader) {
                FilterDirectoryReader filterDirectoryReader = (FilterDirectoryReader)reader;
                if (filterDirectoryReader instanceof DocumentSubsetDirectoryReader) {
                    throw new IllegalArgumentException(LoggerMessageFormat.format((String)"Can't wrap [{}] twice", (Object[])new Object[]{DocumentSubsetDirectoryReader.class}));
                }
                DocumentSubsetDirectoryReader.verifyNoOtherDocumentSubsetDirectoryReaderIsWrapped(filterDirectoryReader.getDelegate());
            }
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }
}

