/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative.tool;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bouncycastle.util.io.Streams;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.LoggingAwareMultiCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.esnative.tool.CommandLineHttpClient;
import org.elasticsearch.xpack.security.support.Validation;

public class SetupPasswordTool
extends LoggingAwareMultiCommand {
    private static final char[] CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789~!@#$%^&*-_=+?".toCharArray();
    public static final List<String> USERS = Arrays.asList("elastic", "kibana", "logstash_system");
    private final CheckedFunction<Environment, CommandLineHttpClient, Exception> clientFunction;
    private final CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction;
    private CommandLineHttpClient client;

    SetupPasswordTool() {
        this((CheckedFunction<Environment, CommandLineHttpClient, Exception>)((CheckedFunction)environment -> new CommandLineHttpClient(environment.settings(), (Environment)environment)), (CheckedFunction<Environment, KeyStoreWrapper, Exception>)((CheckedFunction)environment -> {
            KeyStoreWrapper keyStoreWrapper = KeyStoreWrapper.load((Path)environment.configFile());
            if (keyStoreWrapper == null) {
                throw new UserException(78, "Elasticsearch keystore file is missing [" + KeyStoreWrapper.keystorePath((Path)environment.configFile()) + "]");
            }
            return keyStoreWrapper;
        }));
    }

    SetupPasswordTool(CheckedFunction<Environment, CommandLineHttpClient, Exception> clientFunction, CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction) {
        super("Sets the passwords for reserved users");
        this.subcommands.put("auto", this.newAutoSetup());
        this.subcommands.put("interactive", this.newInteractiveSetup());
        this.clientFunction = clientFunction;
        this.keyStoreFunction = keyStoreFunction;
    }

    protected AutoSetup newAutoSetup() {
        return new AutoSetup();
    }

    protected InteractiveSetup newInteractiveSetup() {
        return new InteractiveSetup();
    }

    public static void main(String[] args) throws Exception {
        SetupPasswordTool.exit((int)new SetupPasswordTool().main(args, Terminal.DEFAULT));
    }

    OptionParser getParser() {
        return this.parser;
    }

    private abstract class SetupCommand
    extends EnvironmentAwareCommand {
        boolean shouldPrompt;
        private OptionSpec<String> urlOption;
        private OptionSpec<String> noPromptOption;
        private String elasticUser;
        private SecureString elasticUserPassword;
        private URL url;

        SetupCommand(String description) {
            super(description);
            this.elasticUser = "elastic";
            this.setParser();
        }

        void setupOptions(OptionSet options, Environment env) throws Exception {
            SetupPasswordTool.this.client = (CommandLineHttpClient)SetupPasswordTool.this.clientFunction.apply((Object)env);
            try (KeyStoreWrapper keyStore = (KeyStoreWrapper)SetupPasswordTool.this.keyStoreFunction.apply((Object)env);){
                String providedUrl = (String)this.urlOption.value(options);
                this.url = new URL(providedUrl == null ? SetupPasswordTool.this.client.getDefaultURL() : providedUrl);
                this.setShouldPrompt(options);
                keyStore.decrypt(new char[0]);
                Settings build = Settings.builder().setSecureSettings((SecureSettings)keyStore).build();
                this.elasticUserPassword = (SecureString)ReservedRealm.BOOTSTRAP_ELASTIC_PASSWORD.get(build);
            }
        }

        private void setParser() {
            this.urlOption = this.parser.acceptsAll(Arrays.asList("u", "url"), "The url for the change password request.").withRequiredArg();
            this.noPromptOption = this.parser.acceptsAll(Arrays.asList("b", "batch"), "If enabled, run the change password process without prompting the user.").withOptionalArg();
        }

        private void setShouldPrompt(OptionSet options) {
            String optionalNoPrompt = (String)this.noPromptOption.value(options);
            this.shouldPrompt = options.has(this.noPromptOption) ? optionalNoPrompt != null && !Booleans.parseBoolean((String)optionalNoPrompt) : true;
        }

        void checkElasticKeystorePasswordValid(Terminal terminal, Environment env) throws Exception {
            URL route = new URL(this.url, (this.url.toURI().getPath() + "/_xpack/security/_authenticate").replaceAll("/+", "/") + "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, "");
            terminal.println(Terminal.Verbosity.VERBOSE, "Testing if bootstrap password is valid for " + route.toString());
            try {
                int httpCode = SetupPasswordTool.this.client.postURL("GET", route, this.elasticUser, this.elasticUserPassword, (CheckedSupplier<String, Exception>)((CheckedSupplier)() -> null), (CheckedConsumer<InputStream, Exception>)((CheckedConsumer)is -> this.verboseLogResponse((InputStream)is, terminal)));
                if (httpCode == 401) {
                    terminal.println("");
                    terminal.println("Failed to authenticate user '" + this.elasticUser + "' against " + route.toString());
                    terminal.println("Possible causes include:");
                    terminal.println(" * The password for the '" + this.elasticUser + "' user has already been changed on this cluster");
                    terminal.println(" * Your elasticsearch node is running against a different keystore");
                    terminal.println("   This tool used the keystore at " + KeyStoreWrapper.keystorePath((Path)env.configFile()));
                    terminal.println("");
                    throw new UserException(78, "Failed to verify bootstrap password");
                }
                if (httpCode != 200) {
                    terminal.println("");
                    terminal.println("Unexpected response code [" + httpCode + "] from calling GET " + route.toString());
                    terminal.println("Possible causes include:");
                    terminal.println(" * The relative path of the URL is incorrect. Is there a proxy in-between?");
                    terminal.println(" * The protocol (http/https) does not match the port.");
                    terminal.println(" * Is this really an Elasticsearch server?");
                    terminal.println("");
                    throw new UserException(78, "Uknown error");
                }
            }
            catch (SSLException e) {
                terminal.println("");
                terminal.println("SSL connection to " + route.toString() + " failed: " + e.getMessage());
                terminal.println("Please check the elasticsearch SSL settings under " + CommandLineHttpClient.HTTP_SSL_SETTING);
                terminal.println(Terminal.Verbosity.VERBOSE, "");
                terminal.println(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.println("");
                throw new UserException(78, "Failed to establish SSL connection to elasticsearch at " + route.toString() + ". ", (Throwable)e);
            }
            catch (IOException e) {
                terminal.println("");
                terminal.println("Connection failure to: " + route.toString() + " failed: " + e.getMessage());
                terminal.println(Terminal.Verbosity.VERBOSE, "");
                terminal.println(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.println("");
                throw new UserException(78, "Failed to connect to elasticsearch at " + route.toString() + ". Is the URL correct and elasticsearch running?", (Throwable)e);
            }
        }

        private void changeUserPassword(String user, SecureString password, Terminal terminal) throws Exception {
            URL route = new URL(this.url, (this.url.toURI().getPath() + "/_xpack/security/user/" + user + "/_password").replaceAll("/+", "/") + "?pretty");
            terminal.println(Terminal.Verbosity.VERBOSE, "");
            terminal.println(Terminal.Verbosity.VERBOSE, "Trying user password change call " + route.toString());
            try {
                SecureString supplierPassword = password.clone();
                int httpCode = SetupPasswordTool.this.client.postURL("PUT", route, this.elasticUser, this.elasticUserPassword, (CheckedSupplier<String, Exception>)((CheckedSupplier)() -> {
                    try {
                        XContentBuilder xContentBuilder = JsonXContent.contentBuilder();
                        xContentBuilder.startObject().field("password", supplierPassword.toString()).endObject();
                        String string = xContentBuilder.string();
                        return string;
                    }
                    finally {
                        supplierPassword.close();
                    }
                }), (CheckedConsumer<InputStream, Exception>)((CheckedConsumer)is -> this.verboseLogResponse((InputStream)is, terminal)));
                if (httpCode != 200) {
                    terminal.println("");
                    terminal.println("Unexpected response code [" + httpCode + "] from calling PUT " + route.toString());
                    terminal.println("Possible next steps:");
                    terminal.println("* Try running this tool again.");
                    terminal.println("* Check the elasticsearch logs for additional error details.");
                    terminal.println("* Use the change password API manually. ");
                    terminal.println("");
                    throw new UserException(75, "Failed to set password for user [" + user + "].");
                }
            }
            catch (IOException e) {
                terminal.println("");
                terminal.println("Connection failure to: " + route.toString() + " failed: " + e.getMessage());
                terminal.println(Terminal.Verbosity.VERBOSE, "");
                terminal.println(Terminal.Verbosity.VERBOSE, ExceptionsHelper.stackTrace((Throwable)e));
                terminal.println("");
                throw new UserException(75, "Failed to set password for user [" + user + "].", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void changePasswords(CheckedFunction<String, SecureString, UserException> passwordFn, CheckedBiConsumer<String, SecureString, Exception> successCallback, Terminal terminal) throws Exception {
            HashMap<String, Object> passwordsMap = new HashMap<String, Object>(USERS.size());
            try {
                for (String user2 : USERS) {
                    passwordsMap.put(user2, passwordFn.apply((Object)user2));
                }
                Map.Entry superUserEntry = null;
                for (Map.Entry entry : passwordsMap.entrySet()) {
                    if (((String)entry.getKey()).equals(this.elasticUser)) {
                        superUserEntry = entry;
                        continue;
                    }
                    this.changeUserPassword((String)entry.getKey(), (SecureString)entry.getValue(), terminal);
                    successCallback.accept(entry.getKey(), entry.getValue());
                }
                if (superUserEntry != null) {
                    this.changeUserPassword((String)superUserEntry.getKey(), (SecureString)superUserEntry.getValue(), terminal);
                    successCallback.accept(superUserEntry.getKey(), superUserEntry.getValue());
                }
            }
            finally {
                passwordsMap.forEach((user, pass) -> pass.close());
            }
        }

        private void verboseLogResponse(InputStream is, Terminal terminal) throws IOException {
            if (is != null) {
                byte[] bytes = Streams.readAll((InputStream)is);
                terminal.println(Terminal.Verbosity.VERBOSE, new String(bytes, StandardCharsets.UTF_8));
            } else {
                terminal.println(Terminal.Verbosity.VERBOSE, "<Empty response>");
            }
        }
    }

    class InteractiveSetup
    extends SetupCommand {
        InteractiveSetup() {
            super("Uses passwords entered by a user");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            terminal.println(Terminal.Verbosity.VERBOSE, "Running with configuration path: " + env.configFile());
            this.setupOptions(options, env);
            this.checkElasticKeystorePasswordValid(terminal, env);
            if (this.shouldPrompt) {
                terminal.println("Initiating the setup of passwords for reserved users " + String.join((CharSequence)",", USERS) + ".");
                terminal.println("You will be prompted to enter passwords as the process progresses.");
                boolean shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println("\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            this.changePasswords((CheckedFunction<String, SecureString, UserException>)((CheckedFunction)user -> this.promptForPassword(terminal, (String)user)), (CheckedBiConsumer<String, SecureString, Exception>)((CheckedBiConsumer)(user, password) -> this.changedPasswordCallback(terminal, (String)user, (SecureString)password)), terminal);
        }

        private SecureString promptForPassword(Terminal terminal, String user) throws UserException {
            SecureString password1;
            while (true) {
                Validation.Error err;
                if ((err = Validation.Users.validatePassword((password1 = new SecureString(terminal.readSecret("Enter password for [" + user + "]: "))).getChars())) != null) {
                    terminal.println(err.toString());
                    terminal.println("Try again.");
                    password1.close();
                    continue;
                }
                SecureString password2 = new SecureString(terminal.readSecret("Reenter password for [" + user + "]: "));
                Throwable throwable = null;
                try {
                    if (password1.equals((Object)password2)) break;
                    terminal.println("Passwords do not match.");
                    terminal.println("Try again.");
                    password1.close();
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (password2 == null) continue;
                    if (throwable != null) {
                        try {
                            password2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    password2.close();
                    continue;
                }
                break;
            }
            return password1;
        }

        private void changedPasswordCallback(Terminal terminal, String user, SecureString password) {
            terminal.println("Changed password for user [" + user + "]");
        }
    }

    class AutoSetup
    extends SetupCommand {
        AutoSetup() {
            super("Uses randomly generated passwords");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            terminal.println(Terminal.Verbosity.VERBOSE, "Running with configuration path: " + env.configFile());
            this.setupOptions(options, env);
            this.checkElasticKeystorePasswordValid(terminal, env);
            if (this.shouldPrompt) {
                terminal.println("Initiating the setup of passwords for reserved users " + String.join((CharSequence)",", USERS) + ".");
                terminal.println("The passwords will be randomly generated and printed to the console.");
                boolean shouldContinue = terminal.promptYesNo("Please confirm that you would like to continue", false);
                terminal.println("\n");
                if (!shouldContinue) {
                    throw new UserException(0, "User cancelled operation");
                }
            }
            SecureRandom secureRandom = new SecureRandom();
            this.changePasswords((CheckedFunction<String, SecureString, UserException>)((CheckedFunction)user -> this.generatePassword(secureRandom, (String)user)), (CheckedBiConsumer<String, SecureString, Exception>)((CheckedBiConsumer)(user, password) -> this.changedPasswordCallback(terminal, (String)user, (SecureString)password)), terminal);
        }

        private SecureString generatePassword(SecureRandom secureRandom, String user) {
            int passwordLength = 20;
            char[] characters = new char[passwordLength];
            for (int i = 0; i < passwordLength; ++i) {
                characters[i] = CHARS[secureRandom.nextInt(CHARS.length)];
            }
            return new SecureString(characters);
        }

        private void changedPasswordCallback(Terminal terminal, String user, SecureString password) {
            terminal.println("Changed password for user " + user + "\nPASSWORD " + user + " = " + password + "\n");
        }
    }
}

