/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.user.ElasticUser;
import org.elasticsearch.xpack.security.user.KibanaUser;
import org.elasticsearch.xpack.security.user.LogstashSystemUser;
import org.elasticsearch.xpack.security.user.User;

public class ReservedRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "reserved";
    private final NativeUsersStore.ReservedUserInfo bootstrapUserInfo;
    static final char[] EMPTY_PASSWORD_HASH = Hasher.BCRYPT.hash(new SecureString("".toCharArray()));
    static final NativeUsersStore.ReservedUserInfo DISABLED_DEFAULT_USER_INFO = new NativeUsersStore.ReservedUserInfo(EMPTY_PASSWORD_HASH, false, true);
    static final NativeUsersStore.ReservedUserInfo ENABLED_DEFAULT_USER_INFO = new NativeUsersStore.ReservedUserInfo(EMPTY_PASSWORD_HASH, true, true);
    public static final Setting<Boolean> ACCEPT_DEFAULT_PASSWORD_SETTING = Setting.boolSetting((String)Security.setting("authc.accept_default_password"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated});
    public static final Setting<SecureString> BOOTSTRAP_ELASTIC_PASSWORD = SecureSetting.secureString((String)"bootstrap.password", (Setting)KeyStoreWrapper.SEED_SETTING, (Setting.Property[])new Setting.Property[0]);
    private final NativeUsersStore nativeUsersStore;
    private final AnonymousUser anonymousUser;
    private final boolean realmEnabled;
    private final boolean anonymousEnabled;
    private final SecurityLifecycleService securityLifecycleService;

    public ReservedRealm(Environment env, Settings settings, NativeUsersStore nativeUsersStore, AnonymousUser anonymousUser, SecurityLifecycleService securityLifecycleService, ThreadContext threadContext) {
        super(TYPE, new RealmConfig(TYPE, Settings.EMPTY, settings, env, threadContext));
        this.nativeUsersStore = nativeUsersStore;
        this.realmEnabled = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
        this.anonymousUser = anonymousUser;
        this.anonymousEnabled = AnonymousUser.isAnonymousEnabled(settings);
        this.securityLifecycleService = securityLifecycleService;
        char[] hash = ((SecureString)BOOTSTRAP_ELASTIC_PASSWORD.get(settings)).length() == 0 ? EMPTY_PASSWORD_HASH : Hasher.BCRYPT.hash((SecureString)BOOTSTRAP_ELASTIC_PASSWORD.get(settings));
        this.bootstrapUserInfo = new NativeUsersStore.ReservedUserInfo(hash, true, hash == EMPTY_PASSWORD_HASH);
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        if (!this.realmEnabled) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else if (!ReservedRealm.isReserved(token.principal(), this.config.globalSettings())) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else {
            this.getUserInfo(token.principal(), (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                AuthenticationResult result;
                if (userInfo != null) {
                    try {
                        if (userInfo.hasEmptyPassword) {
                            result = AuthenticationResult.terminate("failed to authenticate user [" + token.principal() + "]", null);
                        }
                        if (Hasher.BCRYPT.verify(token.credentials(), userInfo.passwordHash)) {
                            User user = this.getUser(token.principal(), (NativeUsersStore.ReservedUserInfo)userInfo);
                            result = AuthenticationResult.success(user);
                        }
                        result = AuthenticationResult.terminate("failed to authenticate user [" + token.principal() + "]", null);
                    }
                    finally {
                        assert (userInfo.passwordHash != ReservedRealm.DISABLED_DEFAULT_USER_INFO.passwordHash) : "default user info must be cloned";
                        assert (userInfo.passwordHash != ReservedRealm.ENABLED_DEFAULT_USER_INFO.passwordHash) : "default user info must be cloned";
                        assert (userInfo.passwordHash != this.bootstrapUserInfo.passwordHash) : "bootstrap user info must be cloned";
                        Arrays.fill(userInfo.passwordHash, '\u0000');
                    }
                } else {
                    result = AuthenticationResult.terminate("failed to authenticate user [" + token.principal() + "]", null);
                }
                listener.onResponse((Object)result);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        if (!this.realmEnabled) {
            if (this.anonymousEnabled && AnonymousUser.isAnonymousUsername(username, this.config.globalSettings())) {
                listener.onResponse((Object)this.anonymousUser);
            }
            listener.onResponse(null);
        } else if (!ReservedRealm.isReserved(username, this.config.globalSettings())) {
            listener.onResponse(null);
        } else if (AnonymousUser.isAnonymousUsername(username, this.config.globalSettings())) {
            listener.onResponse((Object)(this.anonymousEnabled ? this.anonymousUser : null));
        } else {
            this.getUserInfo(username, (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                if (userInfo != null) {
                    listener.onResponse((Object)this.getUser(username, (NativeUsersStore.ReservedUserInfo)userInfo));
                } else {
                    listener.onFailure((Exception)((Object)Exceptions.authenticationError("failed to lookup user [{}]", username)));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public static boolean isReserved(String username, Settings settings) {
        assert (username != null);
        switch (username) {
            case "elastic": 
            case "kibana": 
            case "logstash_system": {
                return (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
            }
        }
        return AnonymousUser.isAnonymousUsername(username, settings);
    }

    private User getUser(String username, NativeUsersStore.ReservedUserInfo userInfo) {
        assert (username != null);
        switch (username) {
            case "elastic": {
                return new ElasticUser(userInfo.enabled);
            }
            case "kibana": {
                return new KibanaUser(userInfo.enabled);
            }
            case "logstash_system": {
                return new LogstashSystemUser(userInfo.enabled);
            }
        }
        if (this.anonymousEnabled && this.anonymousUser.principal().equals(username)) {
            return this.anonymousUser;
        }
        return null;
    }

    public void users(ActionListener<Collection<User>> listener) {
        if (!this.realmEnabled) {
            listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
        } else {
            this.nativeUsersStore.getAllReservedUserInfo((ActionListener<Map<String, NativeUsersStore.ReservedUserInfo>>)ActionListener.wrap(reservedUserInfos -> {
                ArrayList<User> users = new ArrayList<User>(4);
                NativeUsersStore.ReservedUserInfo userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("elastic");
                users.add(new ElasticUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("kibana");
                users.add(new KibanaUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("logstash_system");
                users.add(new LogstashSystemUser(userInfo == null || userInfo.enabled));
                if (this.anonymousEnabled) {
                    users.add(this.anonymousUser);
                }
                listener.onResponse(users);
            }, e -> {
                this.logger.error("failed to retrieve reserved users", (Throwable)e);
                listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
            }));
        }
    }

    private void getUserInfo(String username, ActionListener<NativeUsersStore.ReservedUserInfo> listener) {
        if (!this.userIsDefinedForCurrentSecurityMapping(username)) {
            this.logger.debug("Marking user [{}] as disabled because the security mapping is not at the required version", (Object)username);
            listener.onResponse((Object)DISABLED_DEFAULT_USER_INFO.deepClone());
        } else if (!this.securityLifecycleService.isSecurityIndexExisting()) {
            listener.onResponse((Object)this.getDefaultUserInfo(username));
        } else {
            this.nativeUsersStore.getReservedUserInfo(username, (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                if (userInfo == null) {
                    listener.onResponse((Object)this.getDefaultUserInfo(username));
                } else {
                    listener.onResponse(userInfo);
                }
            }, e -> {
                this.logger.error(() -> new ParameterizedMessage("failed to retrieve password hash for reserved user [{}]", (Object)username), (Throwable)e);
                listener.onResponse(null);
            }));
        }
    }

    private NativeUsersStore.ReservedUserInfo getDefaultUserInfo(String username) {
        if ("elastic".equals(username)) {
            return this.bootstrapUserInfo.deepClone();
        }
        return ENABLED_DEFAULT_USER_INFO.deepClone();
    }

    private boolean userIsDefinedForCurrentSecurityMapping(String username) {
        Version requiredVersion = this.getDefinedVersion(username);
        return this.securityLifecycleService.checkSecurityMappingVersion(arg_0 -> ((Version)requiredVersion).onOrBefore(arg_0));
    }

    private Version getDefinedVersion(String username) {
        switch (username) {
            case "logstash_system": {
                return LogstashSystemUser.DEFINED_SINCE;
            }
        }
        return Version.V_5_0_0;
    }

    public static void addSettings(List<Setting<?>> settingsList) {
        settingsList.add(ACCEPT_DEFAULT_PASSWORD_SETTING);
        settingsList.add(BOOTSTRAP_ELASTIC_PASSWORD);
    }
}

