/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ExpiredTokenRemover;
import org.elasticsearch.xpack.security.authc.TokenMetaData;
import org.elasticsearch.xpack.security.authc.UserToken;

public final class TokenService
extends AbstractComponent {
    private static final int ITERATIONS = 100000;
    private static final String KDF_ALGORITHM = "PBKDF2withHMACSHA512";
    private static final int SALT_BYTES = 32;
    private static final int KEY_BYTES = 64;
    private static final int IV_BYTES = 12;
    private static final int VERSION_BYTES = 4;
    private static final String ENCRYPTION_CIPHER = "AES/GCM/NoPadding";
    private static final String EXPIRED_TOKEN_WWW_AUTH_VALUE = "Bearer realm=\"security\", error=\"invalid_token\", error_description=\"The access token expired\"";
    private static final String MALFORMED_TOKEN_WWW_AUTH_VALUE = "Bearer realm=\"security\", error=\"invalid_token\", error_description=\"The access token is malformed\"";
    private static final String TYPE = "doc";
    public static final String THREAD_POOL_NAME = "security-token-key";
    public static final Setting<SecureString> TOKEN_PASSPHRASE = SecureSetting.secureString((String)"xpack.security.authc.token.passphrase", null, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated});
    public static final Setting<TimeValue> TOKEN_EXPIRATION = Setting.timeSetting((String)"xpack.security.authc.token.timeout", (TimeValue)TimeValue.timeValueMinutes((long)20L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELETE_INTERVAL = Setting.timeSetting((String)"xpack.security.authc.token.delete.interval", (TimeValue)TimeValue.timeValueMinutes((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELETE_TIMEOUT = Setting.timeSetting((String)"xpack.security.authc.token.delete.timeout", (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final String DOC_TYPE = "invalidated-token";
    static final int MINIMUM_BYTES = 49;
    static final int MINIMUM_BASE64_BYTES = Double.valueOf(Math.ceil(65.0)).intValue();
    private final SecureRandom secureRandom = new SecureRandom();
    private final ClusterService clusterService;
    private final Clock clock;
    private final TimeValue expirationDelay;
    private final TimeValue deleteInterval;
    private final Client client;
    private final SecurityLifecycleService lifecycleService;
    private final ExpiredTokenRemover expiredTokenRemover;
    private final boolean enabled;
    private final byte[] currentVersionBytes;
    private volatile TokenKeys keyCache;
    private volatile long lastExpirationRunMs;
    private final AtomicLong createdTimeStamps = new AtomicLong(-1L);
    private static final Version TOKEN_SERVICE_VERSION = Version.CURRENT;

    public TokenService(Settings settings, Clock clock, Client client, SecurityLifecycleService lifecycleService, ClusterService clusterService) throws GeneralSecurityException {
        super(settings);
        byte[] saltArr = new byte[32];
        this.secureRandom.nextBytes(saltArr);
        SecureString tokenPassphraseValue = (SecureString)TOKEN_PASSPHRASE.get(settings);
        SecureString tokenPassphrase = tokenPassphraseValue.length() == 0 ? this.generateTokenKey() : tokenPassphraseValue;
        this.clock = clock.withZone(ZoneOffset.UTC);
        this.expirationDelay = (TimeValue)TOKEN_EXPIRATION.get(settings);
        this.client = client;
        this.lifecycleService = lifecycleService;
        this.lastExpirationRunMs = client.threadPool().relativeTimeInMillis();
        this.deleteInterval = (TimeValue)DELETE_INTERVAL.get(settings);
        this.enabled = (Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings);
        this.expiredTokenRemover = new ExpiredTokenRemover(settings, client);
        this.currentVersionBytes = ByteBuffer.allocate(4).putInt(TokenService.TOKEN_SERVICE_VERSION.id).array();
        this.ensureEncryptionCiphersSupported();
        KeyAndCache keyAndCache = new KeyAndCache(new KeyAndTimestamp(tokenPassphrase.clone(), this.createdTimeStamps.incrementAndGet()), new BytesKey(saltArr));
        this.keyCache = new TokenKeys(Collections.singletonMap(keyAndCache.getKeyHash(), keyAndCache), keyAndCache.getKeyHash());
        this.clusterService = clusterService;
        this.initialize(clusterService);
        this.getTokenMetaData();
    }

    public UserToken createUserToken(Authentication authentication) throws IOException, GeneralSecurityException {
        this.ensureEnabled();
        Instant expiration = this.getExpirationTime();
        return new UserToken(authentication, expiration);
    }

    void getAndValidateToken(ThreadContext ctx, ActionListener<UserToken> listener) {
        if (this.enabled) {
            String token = this.getFromHeader(ctx);
            if (token == null) {
                listener.onResponse(null);
            } else {
                try {
                    this.decodeToken(token, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
                        if (userToken != null) {
                            Instant currentTime = this.clock.instant();
                            if (currentTime.isAfter(userToken.getExpirationTime())) {
                                listener.onFailure((Exception)((Object)TokenService.expiredTokenException()));
                            } else {
                                this.checkIfTokenIsRevoked((UserToken)userToken, listener);
                            }
                        } else {
                            listener.onResponse(null);
                        }
                    }, arg_0 -> listener.onFailure(arg_0)));
                }
                catch (IOException e) {
                    this.logger.debug("invalid token", (Throwable)e);
                    listener.onResponse(null);
                }
            }
        } else {
            listener.onResponse(null);
        }
    }

    void decodeToken(String token, ActionListener<UserToken> listener) throws IOException {
        byte[] bytes = token.getBytes(StandardCharsets.UTF_8);
        InputStreamStreamInput in = new InputStreamStreamInput(Base64.getDecoder().wrap(new ByteArrayInputStream(bytes)), (long)bytes.length);
        if (in.available() < MINIMUM_BASE64_BYTES) {
            this.logger.debug("invalid token");
            listener.onResponse(null);
        } else {
            Version version = Version.readVersion((StreamInput)in);
            if (version.before(Version.V_5_5_0)) {
                listener.onResponse(null);
            } else {
                BytesKey decodedSalt = new BytesKey(in.readByteArray());
                BytesKey passphraseHash = version.onOrAfter(Version.V_6_0_0_beta2) ? new BytesKey(in.readByteArray()) : this.keyCache.currentTokenKeyHash;
                KeyAndCache keyAndCache = this.keyCache.get(passphraseHash);
                if (keyAndCache != null) {
                    SecretKey decodeKey = keyAndCache.getKey(decodedSalt);
                    byte[] iv = in.readByteArray();
                    if (decodeKey != null) {
                        try {
                            TokenService.decryptToken((StreamInput)in, this.getDecryptionCipher(iv, decodeKey, version, decodedSalt), version, listener);
                        }
                        catch (GeneralSecurityException e) {
                            this.logger.warn("invalid token", (Throwable)e);
                            listener.onResponse(null);
                        }
                    } else {
                        this.client.threadPool().executor(THREAD_POOL_NAME).submit((Runnable)((Object)new KeyComputingRunnable((StreamInput)in, iv, version, decodedSalt, listener, keyAndCache)));
                    }
                } else {
                    this.logger.debug("invalid key {} key: {}", (Object)passphraseHash, this.keyCache.cache.keySet());
                    listener.onResponse(null);
                }
            }
        }
    }

    private static void decryptToken(StreamInput in, Cipher cipher, Version version, ActionListener<UserToken> listener) throws IOException {
        try (CipherInputStream cis = new CipherInputStream((InputStream)in, cipher);
             InputStreamStreamInput decryptedInput = new InputStreamStreamInput((InputStream)cis);){
            decryptedInput.setVersion(version);
            listener.onResponse((Object)new UserToken((StreamInput)decryptedInput));
        }
    }

    public void invalidateToken(String tokenString, final ActionListener<Boolean> listener) {
        this.ensureEnabled();
        if (this.lifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        if (!this.lifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("cannot write to the tokens index"));
        } else if (Strings.isNullOrEmpty((String)tokenString)) {
            listener.onFailure((Exception)new IllegalArgumentException("token must be provided"));
        } else {
            this.maybeStartTokenRemover();
            try {
                this.decodeToken(tokenString, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
                    if (userToken == null) {
                        listener.onFailure((Exception)((Object)TokenService.malformedTokenException()));
                    } else if (userToken.getExpirationTime().isBefore(this.clock.instant())) {
                        listener.onResponse((Object)false);
                    } else {
                        String id = TokenService.getDocumentId(userToken);
                        this.lifecycleService.createIndexIfNeededThenExecute(listener, () -> ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", ((IndexRequestBuilder)this.client.prepareIndex(".security", TYPE, id).setOpType(DocWriteRequest.OpType.CREATE).setSource(new Object[]{"doc_type", DOC_TYPE, "expiration_time", this.getExpirationTime().toEpochMilli()}).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL)).request(), new ActionListener<IndexResponse>(){

                            public void onResponse(IndexResponse indexResponse) {
                                listener.onResponse((Object)(indexResponse.getResult() == DocWriteResponse.Result.CREATED ? 1 : 0));
                            }

                            public void onFailure(Exception e) {
                                if (e instanceof VersionConflictEngineException) {
                                    listener.onResponse((Object)false);
                                } else {
                                    listener.onFailure(e);
                                }
                            }
                        }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)));
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (IOException e) {
                this.logger.error("received a malformed token as part of a invalidation request", (Throwable)e);
                listener.onFailure((Exception)((Object)TokenService.malformedTokenException()));
            }
        }
    }

    private static String getDocumentId(UserToken userToken) {
        return "invalidated-token_" + userToken.getId();
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("tokens are not enabled");
        }
    }

    private void checkIfTokenIsRevoked(final UserToken userToken, final ActionListener<UserToken> listener) {
        if (this.lifecycleService.isSecurityIndexAvailable()) {
            if (this.lifecycleService.isSecurityIndexOutOfDate()) {
                listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
                return;
            }
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", this.client.prepareGet(".security", TYPE, TokenService.getDocumentId(userToken)).request(), new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (response.isExists()) {
                        listener.onFailure((Exception)((Object)TokenService.expiredTokenException()));
                    } else {
                        listener.onResponse((Object)userToken);
                    }
                }

                public void onFailure(Exception e) {
                    if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                        TokenService.this.logger.warn("failed to get token [{}] since index is not available", (Object)userToken.getId());
                        listener.onResponse(null);
                    } else {
                        TokenService.this.logger.error((Message)new ParameterizedMessage("failed to get token [{}]", (Object)userToken.getId()), (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
        } else if (this.lifecycleService.isSecurityIndexExisting()) {
            this.logger.warn("could not validate token as the security index is not available");
            listener.onResponse(null);
        } else {
            listener.onResponse((Object)userToken);
        }
    }

    public TimeValue getExpirationDelay() {
        return this.expirationDelay;
    }

    private Instant getExpirationTime() {
        return this.clock.instant().plusSeconds(this.expirationDelay.getSeconds());
    }

    private void maybeStartTokenRemover() {
        if (this.lifecycleService.isSecurityIndexAvailable() && this.client.threadPool().relativeTimeInMillis() - this.lastExpirationRunMs > this.deleteInterval.getMillis()) {
            this.expiredTokenRemover.submit(this.client.threadPool());
            this.lastExpirationRunMs = this.client.threadPool().relativeTimeInMillis();
        }
    }

    String getFromHeader(ThreadContext threadContext) {
        String header = threadContext.getHeader("Authorization");
        if (Strings.hasLength((String)header) && header.startsWith("Bearer ") && header.length() > "Bearer ".length()) {
            return header.substring("Bearer ".length());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String getUserTokenString(UserToken userToken) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ensureEncryptionCiphersSupported() throws NoSuchPaddingException, NoSuchAlgorithmException {
        Cipher.getInstance(ENCRYPTION_CIPHER);
        SecretKeyFactory.getInstance(KDF_ALGORITHM);
    }

    private Cipher getEncryptionCipher(byte[] iv, KeyAndCache keyAndCache) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_CIPHER);
        BytesKey salt = keyAndCache.getSalt();
        cipher.init(1, (Key)keyAndCache.getKey(salt), new GCMParameterSpec(128, iv), this.secureRandom);
        cipher.updateAAD(this.currentVersionBytes);
        cipher.updateAAD(salt.bytes);
        return cipher;
    }

    private Cipher getDecryptionCipher(byte[] iv, SecretKey key, Version version, BytesKey salt) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_CIPHER);
        cipher.init(2, (Key)key, new GCMParameterSpec(128, iv), this.secureRandom);
        cipher.updateAAD(ByteBuffer.allocate(4).putInt(version.id).array());
        cipher.updateAAD(salt.bytes);
        return cipher;
    }

    private byte[] getNewInitializationVector() {
        byte[] initializationVector = new byte[12];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    static SecretKey computeSecretKey(char[] rawPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(KDF_ALGORITHM);
        PBEKeySpec keySpec = new PBEKeySpec(rawPassword, salt, 100000, 128);
        SecretKey tmp = secretKeyFactory.generateSecret(keySpec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private static ElasticsearchSecurityException expiredTokenException() {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("token expired", RestStatus.UNAUTHORIZED, new Object[0]);
        e.addHeader("WWW-Authenticate", new String[]{EXPIRED_TOKEN_WWW_AUTH_VALUE});
        return e;
    }

    private static ElasticsearchSecurityException malformedTokenException() {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("token malformed", RestStatus.UNAUTHORIZED, new Object[0]);
        e.addHeader("WWW-Authenticate", new String[]{MALFORMED_TOKEN_WWW_AUTH_VALUE});
        return e;
    }

    boolean isExpiredTokenException(ElasticsearchSecurityException e) {
        List headers = e.getHeader("WWW-Authenticate");
        return headers != null && headers.stream().anyMatch(EXPIRED_TOKEN_WWW_AUTH_VALUE::equals);
    }

    boolean isExpirationInProgress() {
        return this.expiredTokenRemover.isExpirationInProgress();
    }

    synchronized TokenMetaData generateSpareKey() {
        KeyAndCache currentKey = this.keyCache.activeKeyCache;
        KeyAndCache maxKey = this.keyCache.cache.values().stream().max(Comparator.comparingLong(v -> ((KeyAndCache)v).keyAndTimestamp.timestamp)).get();
        if (currentKey == maxKey) {
            KeyAndCache keyAndCache;
            long timestamp = this.createdTimeStamps.incrementAndGet();
            do {
                byte[] saltArr = new byte[32];
                this.secureRandom.nextBytes(saltArr);
                SecureString tokenKey = this.generateTokenKey();
                keyAndCache = new KeyAndCache(new KeyAndTimestamp(tokenKey, timestamp), new BytesKey(saltArr));
            } while (this.keyCache.cache.containsKey(keyAndCache.getKeyHash()));
            return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, Iterables.concat((Iterable[])new Iterable[]{this.keyCache.cache.values(), Collections.singletonList(keyAndCache)}));
        }
        return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, this.keyCache.cache.values());
    }

    synchronized TokenMetaData rotateToSpareKey() {
        KeyAndCache maxKey = this.keyCache.cache.values().stream().max(Comparator.comparingLong(v -> ((KeyAndCache)v).keyAndTimestamp.timestamp)).get();
        if (maxKey == this.keyCache.activeKeyCache) {
            throw new IllegalStateException("call generateSpareKey first");
        }
        return this.newTokenMetaData(maxKey.getKeyHash(), this.keyCache.cache.values());
    }

    synchronized TokenMetaData pruneKeys(int numKeysToKeep) {
        if (this.keyCache.cache.size() <= numKeysToKeep) {
            return this.getTokenMetaData();
        }
        HashMap<BytesKey, KeyAndCache> map = new HashMap<BytesKey, KeyAndCache>(this.keyCache.cache.size() + 1);
        KeyAndCache currentKey = this.keyCache.get(this.keyCache.currentTokenKeyHash);
        ArrayList<KeyAndCache> entries = new ArrayList<KeyAndCache>(this.keyCache.cache.values());
        Collections.sort(entries, (left, right) -> Long.compare(((KeyAndCache)right).keyAndTimestamp.timestamp, ((KeyAndCache)left).keyAndTimestamp.timestamp));
        for (KeyAndCache value : entries) {
            if (map.size() < numKeysToKeep || value.keyAndTimestamp.timestamp >= currentKey.keyAndTimestamp.timestamp) {
                this.logger.debug("keeping key {} ", (Object)value.getKeyHash());
                map.put(value.getKeyHash(), value);
                continue;
            }
            this.logger.debug("prune key {} ", (Object)value.getKeyHash());
        }
        assert (!map.isEmpty());
        assert (map.containsKey(this.keyCache.currentTokenKeyHash));
        return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, map.values());
    }

    public synchronized TokenMetaData getTokenMetaData() {
        return this.newTokenMetaData(this.keyCache.currentTokenKeyHash, this.keyCache.cache.values());
    }

    private TokenMetaData newTokenMetaData(BytesKey activeTokenKey, Iterable<KeyAndCache> iterable) {
        ArrayList<KeyAndTimestamp> list = new ArrayList<KeyAndTimestamp>();
        for (KeyAndCache v : iterable) {
            list.add(v.keyAndTimestamp);
        }
        return new TokenMetaData(list, activeTokenKey.bytes);
    }

    synchronized void refreshMetaData(TokenMetaData metaData) {
        BytesKey currentUsedKeyHash = new BytesKey(metaData.currentKeyHash);
        byte[] saltArr = new byte[32];
        HashMap<BytesKey, KeyAndCache> map = new HashMap<BytesKey, KeyAndCache>(metaData.keys.size());
        long maxTimestamp = this.createdTimeStamps.get();
        for (KeyAndTimestamp key : metaData.keys) {
            this.secureRandom.nextBytes(saltArr);
            KeyAndCache keyAndCache = new KeyAndCache(key, new BytesKey(saltArr));
            maxTimestamp = Math.max(keyAndCache.keyAndTimestamp.timestamp, maxTimestamp);
            if (!this.keyCache.cache.containsKey(keyAndCache.getKeyHash())) {
                map.put(keyAndCache.getKeyHash(), keyAndCache);
                continue;
            }
            map.put(keyAndCache.getKeyHash(), this.keyCache.get(keyAndCache.getKeyHash()));
        }
        if (!map.containsKey(currentUsedKeyHash)) {
            throw new IllegalStateException("Current key is not in the map: " + map.keySet() + " key: " + currentUsedKeyHash);
        }
        this.createdTimeStamps.set(maxTimestamp);
        this.keyCache = new TokenKeys(Collections.unmodifiableMap(map), currentUsedKeyHash);
        this.logger.debug("refreshed keys current: {}, keys: {}", (Object)currentUsedKeyHash, this.keyCache.cache.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecureString generateTokenKey() {
        byte[] keyBytes = new byte[64];
        byte[] encode = new byte[]{};
        char[] ref = new char[]{};
        try {
            this.secureRandom.nextBytes(keyBytes);
            encode = Base64.getUrlEncoder().withoutPadding().encode(keyBytes);
            ref = new char[encode.length];
            int len = UnicodeUtil.UTF8toUTF16((byte[])encode, (int)0, (int)encode.length, (char[])ref);
            SecureString secureString = new SecureString(Arrays.copyOfRange(ref, 0, len));
            return secureString;
        }
        finally {
            Arrays.fill(keyBytes, (byte)0);
            Arrays.fill(encode, (byte)0);
            Arrays.fill(ref, '\u0000');
        }
    }

    synchronized String getActiveKeyHash() {
        return new BytesRef(Base64.getUrlEncoder().withoutPadding().encode(this.keyCache.currentTokenKeyHash.bytes)).utf8ToString();
    }

    void rotateKeysOnMaster(ActionListener<ClusterStateUpdateResponse> listener) {
        this.logger.info("rotate keys on master");
        TokenMetaData tokenMetaData = this.generateSpareKey();
        this.clusterService.submitStateUpdateTask("publish next key to prepare key rotation", (ClusterStateTaskConfig)new TokenMetadataPublishAction((ActionListener<ClusterStateUpdateResponse>)ActionListener.wrap(res -> {
            if (res.isAcknowledged()) {
                TokenMetaData metaData = this.rotateToSpareKey();
                this.clusterService.submitStateUpdateTask("publish next key to prepare key rotation", (ClusterStateTaskConfig)new TokenMetadataPublishAction(listener, metaData));
            } else {
                listener.onFailure((Exception)new IllegalStateException("not acked"));
            }
        }, arg_0 -> listener.onFailure(arg_0)), tokenMetaData));
    }

    private void initialize(ClusterService clusterService) {
        clusterService.addListener(event -> {
            ClusterState state = event.state();
            if (state.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                return;
            }
            TokenMetaData custom = (TokenMetaData)event.state().custom("security_tokens");
            if (custom != null && !custom.equals((Object)this.getTokenMetaData())) {
                this.logger.info("refresh keys");
                try {
                    this.refreshMetaData(custom);
                }
                catch (Exception e) {
                    this.logger.warn((Object)e);
                }
                this.logger.info("refreshed keys");
            }
        });
    }

    private static final class TokenKeys {
        final Map<BytesKey, KeyAndCache> cache;
        final BytesKey currentTokenKeyHash;
        final KeyAndCache activeKeyCache;

        private TokenKeys(Map<BytesKey, KeyAndCache> cache, BytesKey currentTokenKeyHash) {
            this.cache = cache;
            this.currentTokenKeyHash = currentTokenKeyHash;
            this.activeKeyCache = cache.get(currentTokenKeyHash);
        }

        KeyAndCache get(BytesKey passphraseHash) {
            return this.cache.get(passphraseHash);
        }
    }

    static final class KeyAndCache
    implements Closeable {
        private final KeyAndTimestamp keyAndTimestamp;
        private final Cache<BytesKey, SecretKey> keyCache;
        private final BytesKey salt;
        private final BytesKey keyHash;

        private KeyAndCache(KeyAndTimestamp keyAndTimestamp, BytesKey salt) {
            this.keyAndTimestamp = keyAndTimestamp;
            this.keyCache = CacheBuilder.builder().setExpireAfterAccess(TimeValue.timeValueMinutes((long)60L)).setMaximumWeight(500L).build();
            try {
                SecretKey secretKey = TokenService.computeSecretKey(keyAndTimestamp.key.getChars(), salt.bytes);
                this.keyCache.put((Object)salt, (Object)secretKey);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.salt = salt;
            this.keyHash = KeyAndCache.calculateKeyHash(keyAndTimestamp.key);
        }

        private SecretKey getKey(BytesKey salt) {
            return (SecretKey)this.keyCache.get((Object)salt);
        }

        public SecretKey getOrComputeKey(BytesKey decodedSalt) throws ExecutionException {
            return (SecretKey)this.keyCache.computeIfAbsent((Object)decodedSalt, salt -> {
                try (SecureString closeableChars = this.keyAndTimestamp.key.clone();){
                    SecretKey secretKey = TokenService.computeSecretKey(closeableChars.getChars(), salt.bytes);
                    return secretKey;
                }
            });
        }

        @Override
        public void close() throws IOException {
            this.keyAndTimestamp.key.close();
        }

        BytesKey getKeyHash() {
            return this.keyHash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static BytesKey calculateKeyHash(SecureString key) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            BytesRefBuilder b = new BytesRefBuilder();
            try {
                BytesKey bytesKey;
                b.copyChars((CharSequence)key);
                BytesRef bytesRef = b.toBytesRef();
                try {
                    messageDigest.update(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                    bytesKey = new BytesKey(Arrays.copyOfRange(messageDigest.digest(), 0, 8));
                }
                catch (Throwable throwable) {
                    Arrays.fill(bytesRef.bytes, (byte)0);
                    throw throwable;
                }
                Arrays.fill(bytesRef.bytes, (byte)0);
                return bytesKey;
            }
            finally {
                Arrays.fill(b.bytes(), (byte)0);
            }
        }

        BytesKey getSalt() {
            return this.salt;
        }
    }

    static final class KeyAndTimestamp
    implements Writeable {
        private final SecureString key;
        private final long timestamp;

        private KeyAndTimestamp(SecureString key, long timestamp) {
            this.key = key;
            this.timestamp = timestamp;
        }

        KeyAndTimestamp(StreamInput input) throws IOException {
            this.timestamp = input.readVLong();
            byte[] keyBytes = input.readByteArray();
            char[] ref = new char[keyBytes.length];
            int len = UnicodeUtil.UTF8toUTF16((byte[])keyBytes, (int)0, (int)keyBytes.length, (char[])ref);
            this.key = new SecureString(Arrays.copyOfRange(ref, 0, len));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.timestamp);
            BytesRef bytesRef = new BytesRef((CharSequence)this.key);
            out.writeVInt(bytesRef.length);
            out.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndTimestamp that = (KeyAndTimestamp)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            return this.key.equals((Object)that.key);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }
    }

    private final class TokenMetadataPublishAction
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final TokenMetaData tokenMetaData;

        protected TokenMetadataPublishAction(ActionListener<ClusterStateUpdateResponse> listener, TokenMetaData tokenMetaData) {
            super(new AckedRequest(){

                public TimeValue ackTimeout() {
                    return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
                }

                public TimeValue masterNodeTimeout() {
                    return AcknowledgedRequest.DEFAULT_MASTER_NODE_TIMEOUT;
                }
            }, listener);
            this.tokenMetaData = tokenMetaData;
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            if (this.tokenMetaData.equals(currentState.custom("security_tokens"))) {
                return currentState;
            }
            return ClusterState.builder((ClusterState)currentState).putCustom("security_tokens", (ClusterState.Custom)this.tokenMetaData).build();
        }

        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }
    }

    static class BytesKey {
        final byte[] bytes;
        private final int hashCode;

        BytesKey(byte[] bytes) {
            this.bytes = bytes;
            this.hashCode = StringHelper.murmurhash3_x86_32((byte[])bytes, (int)0, (int)bytes.length, (int)StringHelper.GOOD_FAST_HASH_SEED);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof BytesKey)) {
                return false;
            }
            BytesKey otherBytes = (BytesKey)other;
            return Arrays.equals(otherBytes.bytes, this.bytes);
        }

        public String toString() {
            return new BytesRef(this.bytes).toString();
        }
    }

    private class KeyComputingRunnable
    extends AbstractRunnable {
        private final StreamInput in;
        private final Version version;
        private final BytesKey decodedSalt;
        private final ActionListener<UserToken> listener;
        private final byte[] iv;
        private final KeyAndCache keyAndCache;

        KeyComputingRunnable(StreamInput input, byte[] iv, Version version, BytesKey decodedSalt, ActionListener<UserToken> listener, KeyAndCache keyAndCache) {
            this.in = input;
            this.version = version;
            this.decodedSalt = decodedSalt;
            this.listener = listener;
            this.iv = iv;
            this.keyAndCache = keyAndCache;
        }

        protected void doRun() {
            try {
                SecretKey computedKey = this.keyAndCache.getOrComputeKey(this.decodedSalt);
                TokenService.decryptToken(this.in, TokenService.this.getDecryptionCipher(this.iv, computedKey, this.version, this.decodedSalt), this.version, (ActionListener<UserToken>)this.listener);
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && (e.getCause() instanceof GeneralSecurityException || e.getCause() instanceof IOException || e.getCause() instanceof IllegalArgumentException)) {
                    TokenService.this.logger.debug("unable to decode bearer token", (Throwable)e);
                    this.listener.onResponse(null);
                } else {
                    this.listener.onFailure((Exception)e);
                }
            }
            catch (IOException | GeneralSecurityException e) {
                TokenService.this.logger.debug("unable to decode bearer token", (Throwable)e);
                this.listener.onResponse(null);
            }
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        public void onAfter() {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.in});
        }
    }
}

