/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.security.authc.RealmSettings;

public class RealmConfig {
    final String name;
    final boolean enabled;
    final int order;
    private final String type;
    final Settings settings;
    private final Environment env;
    private final Settings globalSettings;
    private final ThreadContext threadContext;

    public RealmConfig(String name, Settings settings, Settings globalSettings, Environment env, ThreadContext threadContext) {
        this.name = name;
        this.settings = settings;
        this.globalSettings = globalSettings;
        this.env = env;
        this.enabled = (Boolean)RealmSettings.ENABLED_SETTING.get(settings);
        this.order = (Integer)RealmSettings.ORDER_SETTING.get(settings);
        this.type = (String)RealmSettings.TYPE_SETTING.get(settings);
        this.threadContext = threadContext;
    }

    public String name() {
        return this.name;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public int order() {
        return this.order;
    }

    public String type() {
        return this.type;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings globalSettings() {
        return this.globalSettings;
    }

    public Logger logger(Class clazz) {
        return Loggers.getLogger((Class)clazz, (Settings)this.globalSettings, (String[])new String[0]);
    }

    public Environment env() {
        return this.env;
    }

    public ThreadContext threadContext() {
        return this.threadContext;
    }
}

