/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Objects;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.xpack.security.user.User;

public final class AuthenticationResult {
    private static final AuthenticationResult NOT_HANDLED = new AuthenticationResult(Status.CONTINUE, null, null, null);
    private final Status status;
    private final User user;
    private final String message;
    private final Exception exception;

    private AuthenticationResult(Status status, @Nullable User user, @Nullable String message, @Nullable Exception exception) {
        this.status = status;
        this.user = user;
        this.message = message;
        this.exception = exception;
    }

    public Status getStatus() {
        return this.status;
    }

    public User getUser() {
        return this.user;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public static AuthenticationResult success(User user) {
        Objects.requireNonNull(user);
        return new AuthenticationResult(Status.SUCCESS, user, null, null);
    }

    public static AuthenticationResult notHandled() {
        return NOT_HANDLED;
    }

    public static AuthenticationResult unsuccessful(String message, @Nullable Exception cause) {
        Objects.requireNonNull(message);
        return new AuthenticationResult(Status.CONTINUE, null, message, cause);
    }

    public static AuthenticationResult terminate(String message, @Nullable Exception cause) {
        return new AuthenticationResult(Status.TERMINATE, null, message, cause);
    }

    public boolean isAuthenticated() {
        return this.status == Status.SUCCESS;
    }

    public String toString() {
        return "AuthenticationResult{status=" + (Object)((Object)this.status) + ", user=" + this.user + ", message=" + this.message + ", exception=" + this.exception + '}';
    }

    public static enum Status {
        SUCCESS,
        CONTINUE,
        TERMINATE;

    }
}

