/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.interceptor;

import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.user.User;

abstract class FieldAndDocumentLevelSecurityRequestInterceptor<Request extends IndicesRequest>
extends AbstractComponent
implements RequestInterceptor<Request> {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;

    FieldAndDocumentLevelSecurityRequestInterceptor(Settings settings, ThreadContext threadContext, XPackLicenseState licenseState) {
        super(settings);
        this.threadContext = threadContext;
        this.licenseState = licenseState;
    }

    @Override
    public void intercept(Request request, User user, Role userPermissions, String action) {
        if (!this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            return;
        }
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
        for (String index : request.indices()) {
            IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
            if (indexAccessControl != null) {
                boolean documentLevelSecurityEnabled;
                boolean fieldLevelSecurityEnabled = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                boolean bl = documentLevelSecurityEnabled = indexAccessControl.getQueries() != null;
                if (fieldLevelSecurityEnabled || documentLevelSecurityEnabled) {
                    if (fieldLevelSecurityEnabled || documentLevelSecurityEnabled) {
                        this.logger.trace("intercepted request for index [{}] with field level access controls [{}] document level access controls [{}]. disabling conflicting features", (Object)index, (Object)fieldLevelSecurityEnabled, (Object)documentLevelSecurityEnabled);
                    }
                    this.disableFeatures(request, fieldLevelSecurityEnabled, documentLevelSecurityEnabled);
                    return;
                }
            }
            this.logger.trace("intercepted request for index [{}] without field or document level access controls", (Object)index);
        }
    }

    protected abstract void disableFeatures(Request var1, boolean var2, boolean var3);
}

