/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Locale;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.TokenService;

final class TokenPassphraseBootstrapCheck
implements BootstrapCheck {
    static final int MINIMUM_PASSPHRASE_LENGTH = 8;
    private final boolean tokenServiceEnabled;
    private final SecureString tokenPassphrase;

    TokenPassphraseBootstrapCheck(Settings settings) {
        this.tokenServiceEnabled = (Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings);
        this.tokenPassphrase = TokenService.TOKEN_PASSPHRASE.exists(settings) ? (SecureString)TokenService.TOKEN_PASSPHRASE.get(settings) : null;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        if (this.tokenPassphrase == null) {
            return BootstrapCheck.BootstrapCheckResult.success();
        }
        try (SecureString ignore = this.tokenPassphrase;){
            if (this.tokenServiceEnabled && this.tokenPassphrase.length() < 8) {
                String message = String.format(Locale.ROOT, "please set a passphrase using the elasticsearch-keystore tool for the setting [%s] that is at least [%d] characters in length or disable the token service using the [%s] setting", TokenService.TOKEN_PASSPHRASE.getKey(), 8, XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey());
                BootstrapCheck.BootstrapCheckResult bootstrapCheckResult = BootstrapCheck.BootstrapCheckResult.failure((String)message);
                return bootstrapCheckResult;
            }
            BootstrapCheck.BootstrapCheckResult bootstrapCheckResult = BootstrapCheck.BootstrapCheckResult.success();
            return bootstrapCheckResult;
        }
    }
}

