/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.extensions.XPackExtension;
import org.elasticsearch.xpack.extensions.XPackExtensionsService;
import org.elasticsearch.xpack.security.PkiRealmBootstrapCheck;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.SecurityFeatureSet;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.TokenPassphraseBootstrapCheck;
import org.elasticsearch.xpack.security.TokenSSLBootstrapCheck;
import org.elasticsearch.xpack.security.action.filter.SecurityActionFilter;
import org.elasticsearch.xpack.security.action.interceptor.BulkShardRequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.IndicesAliasesRequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.ResizeRequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.SearchRequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.UpdateRequestInterceptor;
import org.elasticsearch.xpack.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.security.action.realm.TransportClearRealmCacheAction;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.security.action.role.DeleteRoleAction;
import org.elasticsearch.xpack.security.action.role.GetRolesAction;
import org.elasticsearch.xpack.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.security.action.role.TransportClearRolesCacheAction;
import org.elasticsearch.xpack.security.action.role.TransportDeleteRoleAction;
import org.elasticsearch.xpack.security.action.role.TransportGetRolesAction;
import org.elasticsearch.xpack.security.action.role.TransportPutRoleAction;
import org.elasticsearch.xpack.security.action.rolemapping.DeleteRoleMappingAction;
import org.elasticsearch.xpack.security.action.rolemapping.GetRoleMappingsAction;
import org.elasticsearch.xpack.security.action.rolemapping.PutRoleMappingAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportDeleteRoleMappingAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportGetRoleMappingsAction;
import org.elasticsearch.xpack.security.action.rolemapping.TransportPutRoleMappingAction;
import org.elasticsearch.xpack.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.security.action.token.TransportCreateTokenAction;
import org.elasticsearch.xpack.security.action.token.TransportInvalidateTokenAction;
import org.elasticsearch.xpack.security.action.user.AuthenticateAction;
import org.elasticsearch.xpack.security.action.user.ChangePasswordAction;
import org.elasticsearch.xpack.security.action.user.DeleteUserAction;
import org.elasticsearch.xpack.security.action.user.GetUsersAction;
import org.elasticsearch.xpack.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.security.action.user.PutUserAction;
import org.elasticsearch.xpack.security.action.user.SetEnabledAction;
import org.elasticsearch.xpack.security.action.user.TransportAuthenticateAction;
import org.elasticsearch.xpack.security.action.user.TransportChangePasswordAction;
import org.elasticsearch.xpack.security.action.user.TransportDeleteUserAction;
import org.elasticsearch.xpack.security.action.user.TransportGetUsersAction;
import org.elasticsearch.xpack.security.action.user.TransportHasPrivilegesAction;
import org.elasticsearch.xpack.security.action.user.TransportPutUserAction;
import org.elasticsearch.xpack.security.action.user.TransportSetEnabledAction;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.index.IndexAuditTrail;
import org.elasticsearch.xpack.security.audit.index.IndexNameResolver;
import org.elasticsearch.xpack.security.audit.logfile.LoggingAuditTrail;
import org.elasticsearch.xpack.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.DefaultAuthenticationFailureHandler;
import org.elasticsearch.xpack.security.authc.InternalRealms;
import org.elasticsearch.xpack.security.authc.Realm;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenMetaData;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.SecuritySearchOperationListener;
import org.elasticsearch.xpack.security.authz.accesscontrol.OptOutQueryCache;
import org.elasticsearch.xpack.security.authz.accesscontrol.SecurityIndexSearcherWrapper;
import org.elasticsearch.xpack.security.authz.accesscontrol.SetSecurityUserProcessor;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.security.rest.SecurityRestFilter;
import org.elasticsearch.xpack.security.rest.action.RestAuthenticateAction;
import org.elasticsearch.xpack.security.rest.action.oauth2.RestGetTokenAction;
import org.elasticsearch.xpack.security.rest.action.oauth2.RestInvalidateTokenAction;
import org.elasticsearch.xpack.security.rest.action.realm.RestClearRealmCacheAction;
import org.elasticsearch.xpack.security.rest.action.role.RestClearRolesCacheAction;
import org.elasticsearch.xpack.security.rest.action.role.RestDeleteRoleAction;
import org.elasticsearch.xpack.security.rest.action.role.RestGetRolesAction;
import org.elasticsearch.xpack.security.rest.action.role.RestPutRoleAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestDeleteRoleMappingAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestGetRoleMappingsAction;
import org.elasticsearch.xpack.security.rest.action.rolemapping.RestPutRoleMappingAction;
import org.elasticsearch.xpack.security.rest.action.user.RestChangePasswordAction;
import org.elasticsearch.xpack.security.rest.action.user.RestDeleteUserAction;
import org.elasticsearch.xpack.security.rest.action.user.RestGetUsersAction;
import org.elasticsearch.xpack.security.rest.action.user.RestHasPrivilegesAction;
import org.elasticsearch.xpack.security.rest.action.user.RestPutUserAction;
import org.elasticsearch.xpack.security.rest.action.user.RestSetEnabledAction;
import org.elasticsearch.xpack.security.support.IndexLifecycleManager;
import org.elasticsearch.xpack.security.transport.SecurityServerTransportInterceptor;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.SecurityNetty4HttpServerTransport;
import org.elasticsearch.xpack.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.security.user.AnonymousUser;
import org.elasticsearch.xpack.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.ssl.SSLService;
import org.elasticsearch.xpack.ssl.TLSLicenseBootstrapCheck;
import org.elasticsearch.xpack.template.TemplateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Security
implements ActionPlugin,
IngestPlugin,
NetworkPlugin,
ClusterPlugin,
DiscoveryPlugin {
    private static final Logger logger = Loggers.getLogger(XPackPlugin.class);
    public static final String NAME4 = "security4";
    public static final Setting<Optional<String>> USER_SETTING = new Setting(Security.setting("user"), (String)null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<List<String>> AUDIT_OUTPUTS_SETTING = Setting.listSetting((String)Security.setting("audit.outputs"), s -> s.keySet().contains(Security.setting("audit.outputs")) ? Collections.emptyList() : Collections.singletonList("logfile"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private final Environment env;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final XPackLicenseState licenseState;
    private final SSLService sslService;
    private final SetOnce<TransportInterceptor> securityInterceptor = new SetOnce();
    private final SetOnce<IPFilter> ipFilter = new SetOnce();
    private final SetOnce<AuthenticationService> authcService = new SetOnce();
    private final SetOnce<AuditTrailService> auditTrailService = new SetOnce();
    private final SetOnce<SecurityContext> securityContext = new SetOnce();
    private final SetOnce<ThreadContext> threadContext = new SetOnce();
    private final SetOnce<TokenService> tokenService = new SetOnce();
    private final SetOnce<SecurityActionFilter> securityActionFilter = new SetOnce();
    private final List<BootstrapCheck> bootstrapChecks;

    public Security(Settings settings, Environment env, XPackLicenseState licenseState, SSLService sslService) throws IOException, GeneralSecurityException {
        this.settings = settings;
        this.env = env;
        this.transportClientMode = XPackPlugin.transportClientMode(settings);
        this.enabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
        if (this.enabled && !this.transportClientMode) {
            Security.validateAutoCreateIndex(settings);
        }
        this.licenseState = licenseState;
        this.sslService = sslService;
        if (this.enabled) {
            ArrayList<BootstrapCheck> checks = new ArrayList<BootstrapCheck>();
            checks.addAll(Arrays.asList(new TokenPassphraseBootstrapCheck(settings), new TokenSSLBootstrapCheck(), new PkiRealmBootstrapCheck(sslService), new TLSLicenseBootstrapCheck()));
            checks.addAll(InternalRealms.getBootstrapChecks(settings, env));
            this.bootstrapChecks = Collections.unmodifiableList(checks);
        } else {
            this.bootstrapChecks = Collections.emptyList();
        }
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (!this.enabled || this.transportClientMode) {
            modules.add(b -> b.bind(IPFilter.class).toProvider(Providers.of(null)));
        }
        if (this.transportClientMode) {
            if (!this.enabled) {
                return modules;
            }
            modules.add(b -> b.bind(SSLService.class).toInstance((Object)this.sslService));
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet(b, SecurityFeatureSet.class));
        if (!this.enabled) {
            modules.add(b -> {
                b.bind(Realms.class).toProvider(Providers.of(null));
                b.bind(CompositeRolesStore.class).toProvider(Providers.of(null));
                b.bind(NativeRoleMappingStore.class).toProvider(Providers.of(null));
                b.bind(AuditTrailService.class).toInstance((Object)new AuditTrailService(this.settings, Collections.emptyList(), this.licenseState));
            });
            return modules;
        }
        modules.add(b -> {
            if (((Boolean)XPackSettings.AUDIT_ENABLED.get(this.settings)).booleanValue()) {
                b.bind(AuditTrail.class).to(AuditTrailService.class);
            }
        });
        return modules;
    }

    public Collection<Object> createComponents(Client client, ThreadPool threadPool, ClusterService clusterService, ResourceWatcherService resourceWatcherService, List<XPackExtension> extensions) throws Exception {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        this.threadContext.set((Object)threadPool.getThreadContext());
        ArrayList<Object> components = new ArrayList<Object>();
        this.securityContext.set((Object)new SecurityContext(this.settings, threadPool.getThreadContext()));
        components.add(this.securityContext.get());
        IndexAuditTrail indexAuditTrail = null;
        LinkedHashSet<AbstractComponent> auditTrails = new LinkedHashSet<AbstractComponent>();
        if (((Boolean)XPackSettings.AUDIT_ENABLED.get(this.settings)).booleanValue()) {
            List outputs = (List)AUDIT_OUTPUTS_SETTING.get(this.settings);
            if (outputs.isEmpty()) {
                throw new IllegalArgumentException("Audit logging is enabled but there are zero output types in " + XPackSettings.AUDIT_ENABLED.getKey());
            }
            Iterator iterator = outputs.iterator();
            block8: while (iterator.hasNext()) {
                String output;
                switch (output = (String)iterator.next()) {
                    case "logfile": {
                        auditTrails.add(new LoggingAuditTrail(this.settings, clusterService, threadPool));
                        continue block8;
                    }
                    case "index": {
                        indexAuditTrail = new IndexAuditTrail(this.settings, client, threadPool, clusterService);
                        auditTrails.add(indexAuditTrail);
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Unknown audit trail output [" + output + "]");
            }
        }
        AuditTrailService auditTrailService = new AuditTrailService(this.settings, auditTrails.stream().collect(Collectors.toList()), this.licenseState);
        components.add(auditTrailService);
        this.auditTrailService.set((Object)auditTrailService);
        SecurityLifecycleService securityLifecycleService = new SecurityLifecycleService(this.settings, clusterService, threadPool, client, indexAuditTrail);
        TokenService tokenService = new TokenService(this.settings, Clock.systemUTC(), client, securityLifecycleService, clusterService);
        this.tokenService.set((Object)tokenService);
        components.add((Object)tokenService);
        NativeUsersStore nativeUsersStore = new NativeUsersStore(this.settings, client, securityLifecycleService);
        NativeRoleMappingStore nativeRoleMappingStore = new NativeRoleMappingStore(this.settings, client, securityLifecycleService);
        AnonymousUser anonymousUser = new AnonymousUser(this.settings);
        ReservedRealm reservedRealm = new ReservedRealm(this.env, this.settings, nativeUsersStore, anonymousUser, securityLifecycleService, threadPool.getThreadContext());
        HashMap<String, Realm.Factory> realmFactories = new HashMap<String, Realm.Factory>();
        realmFactories.putAll(InternalRealms.getFactories(threadPool, resourceWatcherService, this.sslService, nativeUsersStore, nativeRoleMappingStore, securityLifecycleService));
        for (XPackExtension extension : extensions) {
            Map<String, Realm.Factory> newRealms = extension.getRealms(resourceWatcherService);
            for (Map.Entry<String, Realm.Factory> entry : newRealms.entrySet()) {
                if (realmFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Realm type [" + entry.getKey() + "] is already registered");
            }
        }
        Realms realms = new Realms(this.settings, this.env, realmFactories, this.licenseState, threadPool.getThreadContext(), reservedRealm);
        components.add((Object)nativeUsersStore);
        components.add(nativeRoleMappingStore);
        components.add(realms);
        components.add(reservedRealm);
        AuthenticationFailureHandler failureHandler = null;
        String extensionName = null;
        for (XPackExtension extension : extensions) {
            AuthenticationFailureHandler extensionFailureHandler = extension.getAuthenticationFailureHandler();
            if (extensionFailureHandler != null && failureHandler != null) {
                throw new IllegalStateException("Extensions [" + extensionName + "] and [" + extension.name() + "] both set an authentication failure handler");
            }
            failureHandler = extensionFailureHandler;
            extensionName = extension.name();
        }
        if (failureHandler == null) {
            logger.debug("Using default authentication failure handler");
            failureHandler = new DefaultAuthenticationFailureHandler();
        } else {
            logger.debug("Using authentication failure handler from extension [" + extensionName + "]");
        }
        this.authcService.set((Object)new AuthenticationService(this.settings, realms, auditTrailService, failureHandler, threadPool, anonymousUser, tokenService));
        components.add(this.authcService.get());
        FileRolesStore fileRolesStore = new FileRolesStore(this.settings, this.env, resourceWatcherService, this.licenseState);
        NativeRolesStore nativeRolesStore = new NativeRolesStore(this.settings, client, this.licenseState, securityLifecycleService);
        ReservedRolesStore reservedRolesStore = new ReservedRolesStore();
        ArrayList<BiConsumer<Set<String>, ActionListener<Set<RoleDescriptor>>>> rolesProviders = new ArrayList<BiConsumer<Set<String>, ActionListener<Set<RoleDescriptor>>>>();
        for (XPackExtension extension : extensions) {
            rolesProviders.addAll(extension.getRolesProviders(this.settings, resourceWatcherService));
        }
        CompositeRolesStore allRolesStore = new CompositeRolesStore(this.settings, fileRolesStore, nativeRolesStore, reservedRolesStore, rolesProviders, threadPool.getThreadContext(), this.licenseState);
        securityLifecycleService.addSecurityIndexHealthChangeListener(allRolesStore::onSecurityIndexHealthChange);
        securityLifecycleService.addSecurityIndexOutOfDateListener(allRolesStore::onSecurityIndexOutOfDateChange);
        this.licenseState.addListener(allRolesStore::invalidateAll);
        AuthorizationService authzService = new AuthorizationService(this.settings, allRolesStore, clusterService, auditTrailService, failureHandler, threadPool, anonymousUser);
        components.add((Object)nativeRolesStore);
        components.add(reservedRolesStore);
        components.add((Object)allRolesStore);
        components.add((Object)authzService);
        components.add((Object)securityLifecycleService);
        this.ipFilter.set((Object)new IPFilter(this.settings, auditTrailService, clusterService.getClusterSettings(), this.licenseState));
        components.add(this.ipFilter.get());
        DestructiveOperations destructiveOperations = new DestructiveOperations(this.settings, clusterService.getClusterSettings());
        this.securityInterceptor.set((Object)new SecurityServerTransportInterceptor(this.settings, threadPool, (AuthenticationService)((Object)this.authcService.get()), authzService, this.licenseState, this.sslService, (SecurityContext)this.securityContext.get(), destructiveOperations));
        Set<RequestInterceptor<Object>> requestInterceptors = (Boolean)XPackSettings.DLS_FLS_ENABLED.get(this.settings) != false ? Collections.unmodifiableSet(Sets.newHashSet((Object[])new RequestInterceptor[]{new SearchRequestInterceptor(this.settings, threadPool, this.licenseState), new UpdateRequestInterceptor(this.settings, threadPool, this.licenseState), new BulkShardRequestInterceptor(this.settings, threadPool, this.licenseState), new ResizeRequestInterceptor(this.settings, threadPool, this.licenseState, auditTrailService), new IndicesAliasesRequestInterceptor(threadPool.getThreadContext(), this.licenseState, auditTrailService)})) : Collections.emptySet();
        this.securityActionFilter.set((Object)new SecurityActionFilter(this.settings, (AuthenticationService)((Object)this.authcService.get()), authzService, this.licenseState, requestInterceptors, threadPool, (SecurityContext)this.securityContext.get(), destructiveOperations));
        return components;
    }

    public Settings additionalSettings() {
        if (!this.enabled) {
            return Settings.EMPTY;
        }
        return Security.additionalSettings(this.settings, this.transportClientMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Settings additionalSettings(Settings settings, boolean transportClientMode) {
        Settings.Builder settingsBuilder = Settings.builder();
        if (NetworkModule.TRANSPORT_TYPE_SETTING.exists(settings)) {
            String transportType = (String)NetworkModule.TRANSPORT_TYPE_SETTING.get(settings);
            if (!NAME4.equals(transportType)) {
                throw new IllegalArgumentException("transport type setting [transport.type] must be [security4] but is [" + transportType + "]");
            }
        } else {
            settingsBuilder.put("transport.type", NAME4);
        }
        if (NetworkModule.HTTP_TYPE_SETTING.exists(settings)) {
            String httpType = (String)NetworkModule.HTTP_TYPE_SETTING.get(settings);
            if (!httpType.equals(NAME4)) throw new IllegalArgumentException("http type setting [http.type] must be [security4] but is [" + httpType + "]");
            SecurityNetty4HttpServerTransport.overrideSettings(settingsBuilder, settings);
        } else {
            settingsBuilder.put("http.type", NAME4);
            SecurityNetty4HttpServerTransport.overrideSettings(settingsBuilder, settings);
        }
        Security.addUserSettings(settings, settingsBuilder);
        Security.addTribeSettings(settings, settingsBuilder);
        return settingsBuilder.build();
    }

    public static List<Setting<?>> getSettings(boolean transportClientMode, @Nullable XPackExtensionsService extensionsService) {
        ArrayList settingsList = new ArrayList();
        settingsList.add(USER_SETTING);
        if (transportClientMode) {
            return settingsList;
        }
        IPFilter.addSettings(settingsList);
        settingsList.add(AUDIT_OUTPUTS_SETTING);
        LoggingAuditTrail.registerSettings(settingsList);
        IndexAuditTrail.registerSettings(settingsList);
        AnonymousUser.addSettings(settingsList);
        RealmSettings.addSettings(settingsList, extensionsService == null ? null : extensionsService.getExtensions());
        NativeRolesStore.addSettings(settingsList);
        ReservedRealm.addSettings(settingsList);
        AuthenticationService.addSettings(settingsList);
        AuthorizationService.addSettings(settingsList);
        settingsList.add(CompositeRolesStore.CACHE_SIZE_SETTING);
        settingsList.add(FieldPermissionsCache.CACHE_SIZE_SETTING);
        settingsList.add(TokenService.TOKEN_EXPIRATION);
        settingsList.add(TokenService.TOKEN_PASSPHRASE);
        settingsList.add(TokenService.DELETE_INTERVAL);
        settingsList.add(TokenService.DELETE_TIMEOUT);
        settingsList.add(SecurityServerTransportInterceptor.TRANSPORT_TYPE_PROFILE_SETTING);
        settingsList.addAll(SSLConfigurationSettings.getProfileSettings());
        settingsList.add(Setting.listSetting((String)Security.setting("hide_settings"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        return settingsList;
    }

    public List<String> getSettingsFilter(@Nullable XPackExtensionsService extensionsService) {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        List asArray = this.settings.getAsList(Security.setting("hide_settings"));
        for (String pattern : asArray) {
            settingsFilter.add(pattern);
        }
        List<XPackExtension> extensions = extensionsService == null ? Collections.emptyList() : extensionsService.getExtensions();
        settingsFilter.addAll(RealmSettings.getSettingsFilter(extensions));
        settingsFilter.add("transport.profiles.*." + Security.setting("*"));
        return settingsFilter;
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        return this.bootstrapChecks;
    }

    public void onIndexModule(IndexModule module) {
        if (this.enabled) {
            assert (this.licenseState != null);
            if (((Boolean)XPackSettings.DLS_FLS_ENABLED.get(this.settings)).booleanValue()) {
                module.setSearcherWrapper(indexService -> new SecurityIndexSearcherWrapper(indexService.getIndexSettings(), shardId -> indexService.newQueryShardContext(shardId.id(), null, () -> {
                    throw new IllegalArgumentException("permission filters are not allowed to use the current timestamp");
                }, null), indexService.cache().bitsetFilterCache(), indexService.getThreadPool().getThreadContext(), this.licenseState, indexService.getScriptService()));
                module.forceQueryCacheProvider((settings, cache) -> new OptOutQueryCache((IndexSettings)settings, (IndicesQueryCache)cache, (ThreadContext)this.threadContext.get()));
            }
            module.addSearchOperationListener((SearchOperationListener)new SecuritySearchOperationListener((ThreadContext)this.threadContext.get(), this.licenseState, (AuditTrailService)this.auditTrailService.get()));
        }
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)ClearRealmCacheAction.INSTANCE, TransportClearRealmCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ClearRolesCacheAction.INSTANCE, TransportClearRolesCacheAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetUsersAction.INSTANCE, TransportGetUsersAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutUserAction.INSTANCE, TransportPutUserAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteUserAction.INSTANCE, TransportDeleteUserAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetRolesAction.INSTANCE, TransportGetRolesAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutRoleAction.INSTANCE, TransportPutRoleAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteRoleAction.INSTANCE, TransportDeleteRoleAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ChangePasswordAction.INSTANCE, TransportChangePasswordAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)AuthenticateAction.INSTANCE, TransportAuthenticateAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)SetEnabledAction.INSTANCE, TransportSetEnabledAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)HasPrivilegesAction.INSTANCE, TransportHasPrivilegesAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetRoleMappingsAction.INSTANCE, TransportGetRoleMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)PutRoleMappingAction.INSTANCE, TransportPutRoleMappingAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteRoleMappingAction.INSTANCE, TransportDeleteRoleMappingAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)CreateTokenAction.INSTANCE, TransportCreateTokenAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)InvalidateTokenAction.INSTANCE, TransportInvalidateTokenAction.class, new Class[0]));
    }

    public List<ActionFilter> getActionFilters() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        if (!this.transportClientMode) {
            return Collections.singletonList(this.securityActionFilter.get());
        }
        return Collections.emptyList();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestAuthenticateAction(settings, restController, (SecurityContext)this.securityContext.get(), this.licenseState), new RestClearRealmCacheAction(settings, restController, this.licenseState), new RestClearRolesCacheAction(settings, restController, this.licenseState), new RestGetUsersAction(settings, restController, this.licenseState), new RestPutUserAction(settings, restController, this.licenseState), new RestDeleteUserAction(settings, restController, this.licenseState), new RestGetRolesAction(settings, restController, this.licenseState), new RestPutRoleAction(settings, restController, this.licenseState), new RestDeleteRoleAction(settings, restController, this.licenseState), new RestChangePasswordAction(settings, restController, (SecurityContext)this.securityContext.get(), this.licenseState), new RestSetEnabledAction(settings, restController, this.licenseState), new RestHasPrivilegesAction(settings, restController, (SecurityContext)this.securityContext.get(), this.licenseState), new RestGetRoleMappingsAction(settings, restController, this.licenseState), new RestPutRoleMappingAction(settings, restController, this.licenseState), new RestDeleteRoleMappingAction(settings, restController, this.licenseState), new RestGetTokenAction(settings, restController, this.licenseState), new RestInvalidateTokenAction(settings, restController, this.licenseState)});
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Collections.singletonMap("set_security_user", new SetSecurityUserProcessor.Factory(parameters.threadContext));
    }

    private static void addUserSettings(Settings settings, Settings.Builder settingsBuilder) {
        String authHeaderSettingName = "request.headers.Authorization";
        if (settings.get(authHeaderSettingName) != null) {
            return;
        }
        Optional userOptional = (Optional)USER_SETTING.get(settings);
        userOptional.ifPresent(userSetting -> {
            int i = userSetting.indexOf(":");
            if (i < 0 || i == userSetting.length() - 1) {
                throw new IllegalArgumentException("invalid [" + USER_SETTING.getKey() + "] setting. must be in the form of \"<username>:<password>\"");
            }
            String username = userSetting.substring(0, i);
            String password = userSetting.substring(i + 1);
            settingsBuilder.put(authHeaderSettingName, UsernamePasswordToken.basicAuthHeaderValue(username, new SecureString(password)));
        });
    }

    private static void addTribeSettings(Settings settings, Settings.Builder settingsBuilder) {
        boolean hasNativeRealm;
        Map tribesSettings = settings.getGroups("tribe", true);
        if (tribesSettings.isEmpty()) {
            return;
        }
        for (Map.Entry tribeSettings : tribesSettings.entrySet()) {
            String tribeName = (String)tribeSettings.getKey();
            String tribePrefix = "tribe." + tribeName + ".";
            if ("blocks".equals(tribeName) || "on_conflict".equals(tribeName) || "name".equals(tribeName)) continue;
            String tribeEnabledSetting = tribePrefix + XPackSettings.SECURITY_ENABLED.getKey();
            if (settings.get(tribeEnabledSetting) != null) {
                boolean enabled = (Boolean)XPackSettings.SECURITY_ENABLED.get((Settings)tribeSettings.getValue());
                if (!enabled) {
                    throw new IllegalStateException("tribe setting [" + tribeEnabledSetting + "] must be set to true but the value is [" + settings.get(tribeEnabledSetting) + "]");
                }
            } else {
                settingsBuilder.put(tribeEnabledSetting, true);
            }
            settings.keySet().forEach(k -> {
                if (k.startsWith("xpack.security.")) {
                    settingsBuilder.copy(tribePrefix + k, k, settings);
                }
            });
        }
        Map realmsSettings = settings.getGroups(Security.setting("authc.realms"), true);
        boolean bl = hasNativeRealm = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings) != false || realmsSettings.isEmpty() || realmsSettings.entrySet().stream().anyMatch(e -> "native".equals(((Settings)e.getValue()).get("type")) && ((Settings)e.getValue()).getAsBoolean("enabled", Boolean.valueOf(true)) != false);
        if (hasNativeRealm && !settings.get("tribe.on_conflict", "").startsWith("prefer_")) {
            throw new IllegalArgumentException("use of security on tribe nodes requires setting [tribe.on_conflict] to specify the name of the tribe to prefer such as [prefer_t1] as the security index can exist in multiple tribes but only one can be used by the tribe node");
        }
    }

    public static String settingPrefix() {
        return XPackPlugin.featureSettingPrefix("security") + ".";
    }

    public static String setting(String setting) {
        assert (setting != null && !setting.startsWith("."));
        return Security.settingPrefix() + setting;
    }

    static boolean indexAuditLoggingEnabled(Settings settings) {
        if (((Boolean)XPackSettings.AUDIT_ENABLED.get(settings)).booleanValue()) {
            List outputs = (List)AUDIT_OUTPUTS_SETTING.get(settings);
            for (String output : outputs) {
                if (!output.equals("index")) continue;
                return true;
            }
        }
        return false;
    }

    static void validateAutoCreateIndex(Settings settings) {
        String value = settings.get("action.auto_create_index");
        if (value == null) {
            return;
        }
        boolean indexAuditingEnabled = Security.indexAuditLoggingEnabled(settings);
        String auditIndex = indexAuditingEnabled ? ",.security_audit_log*" : "";
        String securityIndices = SecurityLifecycleService.indexNames().stream().collect(Collectors.joining(","));
        String errorMessage = LoggerMessageFormat.format((String)"the [action.auto_create_index] setting value [{}] is too restrictive. disable [action.auto_create_index] or set it to [{}{}]", (Object[])new Object[]{value, securityIndices, auditIndex});
        if (Booleans.isFalse((String)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
        if (Booleans.isTrue((String)value)) {
            return;
        }
        String[] matches = Strings.commaDelimitedListToStringArray((String)value);
        ArrayList<String> indices = new ArrayList<String>();
        indices.addAll(SecurityLifecycleService.indexNames());
        if (indexAuditingEnabled) {
            DateTime now = new DateTime(DateTimeZone.UTC);
            indices.add(IndexNameResolver.resolve(".security_audit_log", now, IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".security_audit_log", now.plusDays(1), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".security_audit_log", now.plusMonths(1), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".security_audit_log", now.plusMonths(2), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".security_audit_log", now.plusMonths(3), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".security_audit_log", now.plusMonths(4), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".security_audit_log", now.plusMonths(5), IndexNameResolver.Rollover.DAILY));
            indices.add(IndexNameResolver.resolve(".security_audit_log", now.plusMonths(6), IndexNameResolver.Rollover.DAILY));
        }
        for (String index : indices) {
            boolean matched = false;
            for (String match : matches) {
                char c = match.charAt(0);
                if (c == '-') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    throw new IllegalArgumentException(errorMessage);
                }
                if (c == '+') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    matched = true;
                    break;
                }
                if (!Regex.simpleMatch((String)match, (String)index)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException(errorMessage);
        }
        if (indexAuditingEnabled) {
            logger.warn("the [action.auto_create_index] setting is configured to be restrictive [{}].  for the next 6 months audit indices are allowed to be created, but please make sure that any future history indices after 6 months with the pattern [.security_audit_log*] are allowed to be created", (Object)value);
        }
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        if (this.transportClientMode || !this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new TransportInterceptor(){

            public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
                assert (Security.this.securityInterceptor.get() != null);
                return ((TransportInterceptor)Security.this.securityInterceptor.get()).interceptHandler(action, executor, forceExecution, actualHandler);
            }

            public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
                assert (Security.this.securityInterceptor.get() != null);
                return ((TransportInterceptor)Security.this.securityInterceptor.get()).interceptSender(sender);
            }
        });
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(NAME4, () -> new SecurityNetty4Transport(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService, (IPFilter)this.ipFilter.get(), this.sslService));
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(NAME4, () -> new SecurityNetty4HttpServerTransport(settings, networkService, bigArrays, (IPFilter)this.ipFilter.get(), this.sslService, threadPool, xContentRegistry, dispatcher));
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        if (!this.enabled || this.transportClientMode) {
            return null;
        }
        boolean ssl = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(this.settings);
        Settings httpSSLSettings = SSLService.getHttpTransportSSLSettings(this.settings);
        boolean extractClientCertificate = ssl && this.sslService.isSSLClientAuthEnabled(httpSSLSettings);
        return handler -> new SecurityRestFilter(this.licenseState, threadContext, (AuthenticationService)((Object)((Object)this.authcService.get())), (RestHandler)handler, extractClientCertificate);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(ClusterState.Custom.class, "security_tokens", TokenMetaData::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "security_tokens", TokenMetaData::readDiffFrom));
        entries.addAll(Arrays.asList(ExpressionParser.NAMED_WRITEABLES));
        return entries;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (this.enabled && !this.transportClientMode) {
            return Collections.singletonList(new FixedExecutorBuilder(settings, "security-token-key", 1, 1000, "xpack.security.authc.token.thread_pool"));
        }
        return Collections.emptyList();
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return templates -> {
            byte[] securityTemplate = TemplateUtils.loadTemplate("/security-index-template.json", Version.CURRENT.toString(), IndexLifecycleManager.TEMPLATE_VERSION_PATTERN).getBytes(StandardCharsets.UTF_8);
            XContent xContent = XContentFactory.xContent((XContentType)XContentType.JSON);
            try (XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, securityTemplate);){
                templates.put("security-index-template", IndexTemplateMetaData.Builder.fromXContent((XContentParser)parser, (String)"security-index-template"));
            }
            catch (IOException e) {
                logger.error("Error loading template [{}] as part of metadata upgrading", (Object)"security-index-template");
            }
            byte[] auditTemplate = TemplateUtils.loadTemplate("/security_audit_log.json", Version.CURRENT.toString(), IndexLifecycleManager.TEMPLATE_VERSION_PATTERN).getBytes(StandardCharsets.UTF_8);
            try (XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, auditTemplate);){
                IndexTemplateMetaData auditMetadata = new IndexTemplateMetaData.Builder(IndexTemplateMetaData.Builder.fromXContent((XContentParser)parser, (String)"security_audit_log")).settings(IndexAuditTrail.customAuditIndexSettings(this.settings, logger)).build();
                templates.put("security_audit_log", auditMetadata);
            }
            catch (IOException e) {
                logger.error("Error loading template [{}] as part of metadata upgrading", (Object)"security_audit_log");
            }
            return templates;
        };
    }

    public Map<String, Supplier<ClusterState.Custom>> getInitialClusterStateCustomSupplier() {
        if (this.enabled) {
            return Collections.singletonMap("security_tokens", () -> ((TokenService)((Object)((Object)this.tokenService.get()))).getTokenMetaData());
        }
        return Collections.emptyMap();
    }

    public BiConsumer<DiscoveryNode, ClusterState> getJoinValidator() {
        if (this.enabled) {
            return new ValidateTLSOnJoin((Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings), (String)DiscoveryModule.DISCOVERY_TYPE_SETTING.get(this.settings)).andThen(new ValidateUpgradedSecurityIndex());
        }
        return null;
    }

    static final class ValidateUpgradedSecurityIndex
    implements BiConsumer<DiscoveryNode, ClusterState> {
        ValidateUpgradedSecurityIndex() {
        }

        @Override
        public void accept(DiscoveryNode node, ClusterState state) {
            IndexMetaData indexMetaData;
            if (state.getNodes().getMinNodeVersion().before(Version.V_6_0_0) && (indexMetaData = (IndexMetaData)state.getMetaData().getIndices().get((Object)".security")) != null && (Integer)IndexMetaData.INDEX_FORMAT_SETTING.get(indexMetaData.getSettings()) < 6) {
                throw new IllegalStateException("Security index is not on the current version [6] - The Upgrade API must be run for 6.x nodes to join the cluster");
            }
        }
    }

    static final class ValidateTLSOnJoin
    implements BiConsumer<DiscoveryNode, ClusterState> {
        private final boolean isTLSEnabled;
        private final String discoveryType;

        ValidateTLSOnJoin(boolean isTLSEnabled, String discoveryType) {
            this.isTLSEnabled = isTLSEnabled;
            this.discoveryType = discoveryType;
        }

        @Override
        public void accept(DiscoveryNode node, ClusterState state) {
            License license = LicenseService.getLicense(state.metaData());
            if (license != null && license.isProductionLicense() && !this.isTLSEnabled && !"single-node".equals(this.discoveryType)) {
                throw new IllegalStateException("TLS setup is required for license type [" + license.operationMode().name() + "]");
            }
        }
    }
}

