/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.persistent;

import java.util.function.Predicate;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.persistent.AllocatedPersistentTask;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public abstract class PersistentTasksExecutor<Params extends PersistentTaskParams>
extends AbstractComponent {
    private final String executor;
    private final String taskName;
    public static final PersistentTasksCustomMetaData.Assignment NO_NODE_FOUND = new PersistentTasksCustomMetaData.Assignment(null, "no appropriate nodes found for the assignment");

    protected PersistentTasksExecutor(Settings settings, String taskName, String executor) {
        super(settings);
        this.taskName = taskName;
        this.executor = executor;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public PersistentTasksCustomMetaData.Assignment getAssignment(Params params, ClusterState clusterState) {
        DiscoveryNode discoveryNode = this.selectLeastLoadedNode(clusterState, DiscoveryNode::isDataNode);
        if (discoveryNode == null) {
            return NO_NODE_FOUND;
        }
        return new PersistentTasksCustomMetaData.Assignment(discoveryNode.getId(), "");
    }

    protected DiscoveryNode selectLeastLoadedNode(ClusterState clusterState, Predicate<DiscoveryNode> selector) {
        long minLoad = Long.MAX_VALUE;
        DiscoveryNode minLoadedNode = null;
        PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!selector.test(node)) continue;
            if (persistentTasks == null) {
                return node;
            }
            long numberOfTasks = persistentTasks.getNumberOfTasksOnNode(node.getId(), this.taskName);
            if (minLoad <= numberOfTasks) continue;
            minLoad = numberOfTasks;
            minLoadedNode = node;
        }
        return minLoadedNode;
    }

    public void validate(Params params, ClusterState clusterState) {
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<Params> taskInProgress) {
        return new AllocatedPersistentTask(id, type, action, this.getDescription(taskInProgress), parentTaskId);
    }

    protected String getDescription(PersistentTasksCustomMetaData.PersistentTask<Params> taskInProgress) {
        return "id=" + taskInProgress.getId();
    }

    protected abstract void nodeOperation(AllocatedPersistentTask var1, @Nullable Params var2, @Nullable Task.Status var3);

    public String getExecutor() {
        return this.executor;
    }
}

