/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.hipchat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpMethod;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.http.Scheme;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.notification.hipchat.HipChatMessage;
import org.elasticsearch.xpack.notification.hipchat.HipChatServer;
import org.elasticsearch.xpack.notification.hipchat.SentMessages;

public class V1Account
extends HipChatAccount {
    public static final String TYPE = "v1";
    final Defaults defaults;

    public V1Account(String name, Settings settings, HipChatServer defaultServer, HttpClient httpClient, Logger logger) {
        super(name, HipChatAccount.Profile.V1, settings, defaultServer, httpClient, logger);
        this.defaults = new Defaults(settings);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void validateParsedTemplate(String watchId, String actionId, HipChatMessage.Template template) throws ElasticsearchParseException {
        if (template.users != null) {
            throw new ElasticsearchParseException("invalid [hipchat] action for [" + watchId + "/" + actionId + "]. [" + this.name + "] hipchat account doesn't support user private messaging", new Object[0]);
        }
        if (!(template.rooms != null && template.rooms.length != 0 || this.defaults.rooms != null && this.defaults.rooms.length != 0)) {
            throw new ElasticsearchParseException("invalid [hipchat] action for [" + watchId + "/" + actionId + "]. missing required [" + HipChatMessage.Field.ROOM + "] field for [" + this.name + "] hipchat account", new Object[0]);
        }
    }

    @Override
    public HipChatMessage render(String watchId, String actionId, TextTemplateEngine engine, HipChatMessage.Template template, Map<String, Object> model) {
        String message = engine.render(template.body, model);
        String[] rooms = this.defaults.rooms;
        if (template.rooms != null) {
            rooms = new String[template.rooms.length];
            for (int i = 0; i < template.rooms.length; ++i) {
                rooms[i] = engine.render(template.rooms[i], model);
            }
        }
        String from = template.from != null ? template.from : (this.defaults.from != null ? this.defaults.from : watchId);
        HipChatMessage.Color color = HipChatMessage.Color.resolve(engine.render(template.color, model), this.defaults.color);
        Boolean notify = template.notify != null ? template.notify : this.defaults.notify;
        HipChatMessage.Format messageFormat = template.format != null ? template.format : this.defaults.format;
        return new HipChatMessage(message, rooms, null, from, messageFormat, color, notify);
    }

    @Override
    public SentMessages send(HipChatMessage message, @Nullable HttpProxy proxy) {
        ArrayList<SentMessages.SentMessage> sentMessages = new ArrayList<SentMessages.SentMessage>();
        if (message.rooms != null) {
            for (String room : message.rooms) {
                HttpRequest request = this.buildRoomRequest(room, message, proxy);
                try {
                    HttpResponse response = this.httpClient.execute(request);
                    sentMessages.add(SentMessages.SentMessage.responded(room, SentMessages.SentMessage.TargetType.ROOM, message, request, response));
                }
                catch (Exception e) {
                    this.logger.error("failed to execute hipchat api http request", (Throwable)e);
                    sentMessages.add(SentMessages.SentMessage.error(room, SentMessages.SentMessage.TargetType.ROOM, message, e));
                }
            }
        }
        return new SentMessages(this.name, sentMessages);
    }

    public HttpRequest buildRoomRequest(String room, HipChatMessage message, HttpProxy proxy) {
        HttpRequest.Builder builder = this.server.httpRequest();
        builder.method(HttpMethod.POST);
        builder.scheme(Scheme.HTTPS);
        builder.path("/v1/rooms/message");
        builder.setHeader("Content-Type", "application/x-www-form-urlencoded");
        builder.setParam("format", "json");
        builder.setParam("auth_token", this.authToken);
        if (proxy != null) {
            builder.proxy(proxy);
        }
        StringBuilder body = new StringBuilder();
        body.append("room_id=").append(HttpRequest.encodeUrl(room));
        body.append("&from=").append(HttpRequest.encodeUrl(message.from));
        body.append("&message=").append(HttpRequest.encodeUrl(message.body));
        if (message.format != null) {
            body.append("&message_format=").append(message.format.value());
        }
        if (message.color != null) {
            body.append("&color=").append(message.color.value());
        }
        if (message.notify != null) {
            body.append("&notify=").append(message.notify != false ? "1" : "0");
        }
        builder.body(body.toString());
        return builder.build();
    }

    static class Defaults {
        @Nullable
        final String[] rooms;
        @Nullable
        final String from;
        @Nullable
        final HipChatMessage.Format format;
        @Nullable
        final HipChatMessage.Color color;
        @Nullable
        final Boolean notify;

        Defaults(Settings settings) {
            List rooms = settings.getAsList(HipChatAccount.DEFAULT_ROOM_SETTING, null);
            this.rooms = rooms == null ? null : rooms.toArray(Strings.EMPTY_ARRAY);
            this.from = settings.get(HipChatAccount.DEFAULT_FROM_SETTING);
            this.format = HipChatMessage.Format.resolve(settings, HipChatAccount.DEFAULT_FORMAT_SETTING, null);
            this.color = HipChatMessage.Color.resolve(settings, HipChatAccount.DEFAULT_COLOR_SETTING, null);
            this.notify = settings.getAsBoolean(HipChatAccount.DEFAULT_NOTIFY_SETTING, null);
        }
    }
}

