/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.hipchat;

import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.notification.NotificationService;
import org.elasticsearch.xpack.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.notification.hipchat.HipChatServer;

public class HipChatService
extends NotificationService<HipChatAccount> {
    private final HttpClient httpClient;
    public static final Setting<Settings> HIPCHAT_ACCOUNT_SETTING = Setting.groupSetting((String)"xpack.notification.hipchat.", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private HipChatServer defaultServer;

    public HipChatService(Settings settings, HttpClient httpClient, ClusterSettings clusterSettings) {
        super(settings, "hipchat");
        this.httpClient = httpClient;
        clusterSettings.addSettingsUpdateConsumer(HIPCHAT_ACCOUNT_SETTING, this::setAccountSetting);
        this.setAccountSetting((Settings)HIPCHAT_ACCOUNT_SETTING.get(settings));
    }

    @Override
    protected synchronized void setAccountSetting(Settings settings) {
        this.defaultServer = new HipChatServer(settings);
        super.setAccountSetting(settings);
    }

    @Override
    protected HipChatAccount createAccount(String name, Settings accountSettings) {
        HipChatAccount.Profile profile = HipChatAccount.Profile.resolve(accountSettings, "profile", null);
        if (profile == null) {
            throw new SettingsException("missing [profile] setting for hipchat account [" + name + "]");
        }
        return profile.createAccount(name, accountSettings, this.defaultServer, this.httpClient, this.logger);
    }
}

