/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.email;

import javax.mail.MessagingException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.notification.NotificationService;
import org.elasticsearch.xpack.notification.email.Account;
import org.elasticsearch.xpack.notification.email.Authentication;
import org.elasticsearch.xpack.notification.email.Email;
import org.elasticsearch.xpack.notification.email.Profile;
import org.elasticsearch.xpack.security.crypto.CryptoService;

public class EmailService
extends NotificationService<Account> {
    private final CryptoService cryptoService;
    public static final Setting<Settings> EMAIL_ACCOUNT_SETTING = Setting.groupSetting((String)"xpack.notification.email.", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});

    public EmailService(Settings settings, @Nullable CryptoService cryptoService, ClusterSettings clusterSettings) {
        super(settings, "email");
        this.cryptoService = cryptoService;
        clusterSettings.addSettingsUpdateConsumer(EMAIL_ACCOUNT_SETTING, this::setAccountSetting);
        this.setAccountSetting((Settings)EMAIL_ACCOUNT_SETTING.get(settings));
    }

    @Override
    protected Account createAccount(String name, Settings accountSettings) {
        Account.Config config = new Account.Config(name, accountSettings);
        return new Account(config, this.cryptoService, this.logger);
    }

    public EmailSent send(Email email, Authentication auth, Profile profile, String accountName) throws MessagingException {
        Account account = (Account)this.getAccount(accountName);
        if (account == null) {
            throw new IllegalArgumentException("failed to send email with subject [" + email.subject() + "] via account [" + accountName + "]. account does not exist");
        }
        return this.send(email, auth, profile, account);
    }

    private EmailSent send(Email email, Authentication auth, Profile profile, Account account) throws MessagingException {
        assert (account != null);
        try {
            email = account.send(email, auth, profile);
        }
        catch (MessagingException me) {
            throw new MessagingException("failed to send email with subject [" + email.subject() + "] via account [" + account.name() + "]", (Exception)((Object)me));
        }
        return new EmailSent(account.name(), email);
    }

    public static class EmailSent {
        private final String account;
        private final Email email;

        public EmailSent(String account, Email email) {
            this.account = account;
            this.email = email;
        }

        public String account() {
            return this.account;
        }

        public Email email() {
            return this.email;
        }
    }
}

